/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Types;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.spincast.core.exchange.DefaultRequestContextDefault;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.guice.SpincastContextTypesInterested;
import org.spincast.core.websocket.DefaultWebsocketContextDefault;
import org.spincast.core.websocket.WebsocketContext;

public abstract class SpincastGuiceModuleBase
extends AbstractModule
implements SpincastContextTypesInterested {
    private Class<? extends RequestContext<?>> requestContextInterface;
    private Class<? extends WebsocketContext<?>> websocketContextInterface;
    private Class<? extends RequestContext<?>> requestContextImplementationClass;
    private Class<? extends WebsocketContext<?>> websocketContextImplementationClass;

    public SpincastGuiceModuleBase() {
        this(DefaultRequestContextDefault.class, DefaultWebsocketContextDefault.class);
    }

    public SpincastGuiceModuleBase(Class<? extends RequestContext<?>> requestContextImplementationClass, Class<? extends WebsocketContext<?>> websocketContextImplementationClass) {
        this.requestContextImplementationClass = requestContextImplementationClass;
        this.websocketContextImplementationClass = websocketContextImplementationClass;
    }

    protected Class<? extends RequestContext<?>> getRequestContextImplementationClass() {
        return this.requestContextImplementationClass;
    }

    protected Class<? extends WebsocketContext<?>> getWebsocketContextImplementationClass() {
        return this.websocketContextImplementationClass;
    }

    @Override
    public void setRequestContextImplementationClass(Class<? extends RequestContext<?>> requestContextImplementationClass) {
        this.requestContextImplementationClass = requestContextImplementationClass;
    }

    @Override
    public void setWebsocketContextImplementationClass(Class<? extends WebsocketContext<?>> websocketContextImplementationClass) {
        this.websocketContextImplementationClass = websocketContextImplementationClass;
    }

    protected Class<? extends RequestContext<?>> getRequestContextInterface() {
        if (this.requestContextInterface == null) {
            Class temp;
            Key<RequestContext<?>> key = Key.get(this.getRequestContextImplementationClass());
            TypeLiteral<RequestContext> requestContextTypeLiteral = key.getTypeLiteral().getSupertype(RequestContext.class);
            this.requestContextInterface = temp = (Class)((ParameterizedType)requestContextTypeLiteral.getType()).getActualTypeArguments()[0];
        }
        return this.requestContextInterface;
    }

    protected Type getWebsocketContextInterface() {
        if (this.websocketContextInterface == null) {
            Class temp;
            Key<WebsocketContext<?>> key = Key.get(this.getWebsocketContextImplementationClass());
            TypeLiteral<WebsocketContext> websocketContextTypeLiteral = key.getTypeLiteral().getSupertype(WebsocketContext.class);
            this.websocketContextInterface = temp = (Class)((ParameterizedType)websocketContextTypeLiteral.getType()).getActualTypeArguments()[0];
        }
        return this.websocketContextInterface;
    }

    protected <T> Key<T> parameterizeWithRequestContext(Class<T> clazz) {
        return Key.get(Types.newParameterizedType(clazz, this.getRequestContextInterface()));
    }

    protected <T> Key<T> parameterizeWithWebsocketContext(Class<T> clazz) {
        return Key.get(Types.newParameterizedType(clazz, this.getWebsocketContextInterface()));
    }

    protected <T> Key<T> parameterizeWithContextInterfaces(Class<T> clazz) {
        return Key.get(Types.newParameterizedType(clazz, this.getRequestContextInterface(), this.getWebsocketContextInterface()));
    }

    @Override
    protected void install(Module module) {
        if (module instanceof SpincastContextTypesInterested) {
            ((SpincastContextTypesInterested)((Object)module)).setRequestContextImplementationClass(this.getRequestContextImplementationClass());
            ((SpincastContextTypesInterested)((Object)module)).setWebsocketContextImplementationClass(this.getWebsocketContextImplementationClass());
        }
        super.install(module);
    }

    @Override
    protected abstract void configure();
}

