/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.website.controllers.demos;

import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.flash.FlashMessageFactory;
import org.spincast.core.json.JsonArray;
import org.spincast.core.json.JsonManager;
import org.spincast.core.json.JsonObject;
import org.spincast.core.request.Form;
import org.spincast.core.response.AlertLevel;
import org.spincast.core.validation.ValidationFactory;
import org.spincast.core.validation.ValidationSet;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;
import org.spincast.website.exchange.AppRequestContext;

public class DemoHtmlFormsDynamicFieldsController {
    protected final Logger logger = LoggerFactory.getLogger(DemoHtmlFormsDynamicFieldsController.class);
    private final FlashMessageFactory flashMessageFactory;
    private final JsonManager jsonManager;
    private final ValidationFactory validationFactory;

    @Inject
    public DemoHtmlFormsDynamicFieldsController(FlashMessageFactory flashMessageFactory, JsonManager jsonManager, ValidationFactory validationFactory) {
        this.flashMessageFactory = flashMessageFactory;
        this.jsonManager = jsonManager;
        this.validationFactory = validationFactory;
    }

    protected FlashMessageFactory getFlashMessageFactory() {
        return this.flashMessageFactory;
    }

    protected JsonManager getJsonManager() {
        return this.jsonManager;
    }

    protected ValidationFactory getValidationFactory() {
        return this.validationFactory;
    }

    public void dynamicFields(AppRequestContext context) {
        JsonObject form = context.response().getModel().getJsonObject("demoForm");
        if (form == null) {
            form = context.json().create();
            context.response().getModel().set("demoForm", form);
            JsonArray users = context.json().createArray();
            form.set("users", users);
            JsonObject firstUser = this.createFirstUser();
            users.add(firstUser);
        }
        context.response().sendTemplateHtml("/templates/demos/htmlForms/dynamic.html");
    }

    protected JsonObject createFirstUser() {
        JsonObject firstUser = this.getJsonManager().create();
        firstUser.set("name", "Stromgol");
        firstUser.set("city", "Amos");
        JsonArray firstUserTags = this.getJsonManager().createArray();
        firstUserTags.add("myTag1");
        firstUserTags.add("myTag2");
        firstUserTags.add("myTag3");
        firstUser.set("tags", firstUserTags);
        return firstUser;
    }

    public void dynamicFieldsSubmit(AppRequestContext context) {
        Integer addTagToUserPos;
        Form form = context.request().getFormOrCreate("demoForm");
        context.response().addForm(form);
        boolean actionDone = false;
        if (context.request().getFormBodyAsJsonObject().contains("addUserBtn")) {
            actionDone = true;
            JsonArray users = form.getJsonArrayOrEmpty("users");
            JsonObject newUser = context.json().create();
            newUser.set("name", "");
            newUser.set("city", "");
            users.add(newUser);
            JsonArray newUserTags = context.json().createArray();
            newUserTags.add("");
            newUser.set("tags", newUserTags);
        }
        if (!actionDone && (addTagToUserPos = this.getUserToAddTagTo(context)) != null) {
            actionDone = true;
            JsonObject user = form.getJsonObject("users[" + addTagToUserPos + "]");
            if (user != null) {
                JsonArray tags = user.getJsonArray("tags");
                if (tags == null) {
                    tags = context.json().createArray();
                    user.set("tags", tags);
                }
                tags.add("");
            }
        }
        if (!actionDone) {
            if (form.getJsonArrayOrEmpty("users").size() > 0) {
                this.validateForm(form);
            } else {
                context.response().addAlert(AlertLevel.WARNING, "No users to validate!");
            }
        }
        this.dynamicFields(context);
    }

    protected Integer getUserToAddTagTo(AppRequestContext context) {
        Integer userPositionToAddTagTo = null;
        for (Map.Entry formDatas : context.request().getFormBodyAsJsonObject()) {
            String key = (String)formDatas.getKey();
            if (key == null || !key.startsWith("addTag_")) continue;
            try {
                userPositionToAddTagTo = Integer.parseInt(key.substring("addTag_".length()));
                break;
            }
            catch (Exception exception) {
            }
        }
        return userPositionToAddTagTo;
    }

    protected void validateForm(Form form) {
        form.trimAll();
        JsonArray users = form.getJsonArrayOrEmpty("users");
        for (int i = 0; i < users.size(); ++i) {
            JsonObject user = users.getJsonObject(i);
            ValidationSet userValidation = this.validateUser(user);
            form.mergeValidationSet("users[" + i + "].", userValidation);
        }
    }

    protected ValidationSet validateUser(JsonObject user) {
        JsonArray tags;
        String city;
        ValidationSet userValidation = this.getValidationFactory().createValidationSet();
        String name = user.getString("name");
        if (StringUtils.isBlank(name)) {
            userValidation.addError("name", "name_empty", "The name can't be empty");
        }
        if (userValidation.isValid("name") && name.length() < 3) {
            userValidation.addError("name", "name_minLength", "The name must be at least 3 characters.");
        }
        if (StringUtils.isBlank(city = user.getString("city"))) {
            userValidation.addError("city", "city_empty", "The city can't be empty");
        }
        if (userValidation.isValid("city") && city.length() < 4) {
            userValidation.addError("city", "city_minLength", "The city must be at least 3 characters.");
        }
        if ((tags = user.getJsonArray("tags")).size() < 1) {
            userValidation.addError("tags", "tags_minSize", "At least one tag is required.");
        }
        if (userValidation.isValid("tags")) {
            HashSet<String> tagsSet = new HashSet<String>();
            boolean atLeastOneTagError = false;
            for (int i = 0; i < tags.size(); ++i) {
                String tag = tags.getString(i);
                String tagLowercase = tag.toLowerCase();
                String tagValidationKey = "tags[" + i + "]";
                if (StringUtils.isBlank(tag)) {
                    userValidation.addError(tagValidationKey, "tag_empty", "A tag can't be empty");
                }
                if (userValidation.isValid(tagValidationKey) && tag.length() < 3) {
                    userValidation.addError(tagValidationKey, "tag_minLength", "A tag must be at least 3 characters.");
                }
                if (userValidation.isValid(tagValidationKey) && tag.length() > 10) {
                    userValidation.addError(tagValidationKey, "tag_maxLength", "A tag must be max 10 characters long.");
                }
                if (userValidation.isValid(tagValidationKey) && tagsSet.contains(tagLowercase)) {
                    userValidation.addError(tagValidationKey, "tag_duplicate", "This tag already exists.");
                }
                tagsSet.add(tagLowercase);
                atLeastOneTagError = atLeastOneTagError || userValidation.isError(tagValidationKey);
            }
            if (atLeastOneTagError) {
                userValidation.addError("tags", "tags_someInvalid", "At least one tag is invalid.");
            }
        }
        return userValidation;
    }
}

