/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.assistedinject;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.inject.ConfigurationException;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.Message;
import java.util.Collections;
import java.util.Map;

class BindingCollector {
    private final Map<Key<?>, TypeLiteral<?>> bindings = Maps.newHashMap();

    BindingCollector() {
    }

    public BindingCollector addBinding(Key<?> key, TypeLiteral<?> target) {
        if (this.bindings.containsKey(key)) {
            String string = String.valueOf(String.valueOf(key));
            throw new ConfigurationException(ImmutableSet.of(new Message(new StringBuilder(45 + string.length()).append("Only one implementation can be specified for ").append(string).toString())));
        }
        this.bindings.put(key, target);
        return this;
    }

    public Map<Key<?>, TypeLiteral<?>> getBindings() {
        return Collections.unmodifiableMap(this.bindings);
    }

    public int hashCode() {
        return this.bindings.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof BindingCollector && this.bindings.equals(((BindingCollector)obj).bindings);
    }
}

