/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.website.controllers.demos;

import com.google.inject.Inject;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.flash.FlashMessageLevel;
import org.spincast.core.json.JsonArray;
import org.spincast.core.json.JsonManager;
import org.spincast.core.request.Form;
import org.spincast.core.request.FormFactory;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;
import org.spincast.website.exchange.AppRequestContext;

public class DemoHtmlFormsMultipleFieldsController {
    protected final Logger logger = LoggerFactory.getLogger(DemoHtmlFormsMultipleFieldsController.class);
    private final FormFactory formFactory;
    private final JsonManager jsonManager;

    @Inject
    public DemoHtmlFormsMultipleFieldsController(FormFactory formFactory, JsonManager jsonManager) {
        this.formFactory = formFactory;
        this.jsonManager = jsonManager;
    }

    protected FormFactory getFormFactory() {
        return this.formFactory;
    }

    protected JsonManager getJsonManager() {
        return this.jsonManager;
    }

    public void multipleFields(AppRequestContext context) {
        context.response().sendTemplateHtml("/templates/demos/htmlForms/multiple.html");
    }

    public void multipleFieldsSubmit(AppRequestContext context) {
        Form form = context.request().getFormOrCreate("demoForm");
        context.response().addForm(form);
        this.validateForm(form);
        if (!form.isValid() || "stay".equals(form.getString("action"))) {
            this.multipleFields(context);
        } else {
            context.response().redirect(FlashMessageLevel.SUCCESS, "The form has been processed successfully.");
        }
    }

    protected void validateForm(Form form) {
        String drink;
        String action;
        JsonArray tags;
        form.trimAll();
        String email = form.getString("email");
        if (StringUtils.isBlank(email)) {
            form.addError("email", "email_empty", "The email is required");
        }
        if (form.isValid("email") && !form.validators().isEmailValid(email)) {
            form.addError("email", "email_invalid", "The email is invalid");
        }
        String emailAgain = form.getString("emailAgain");
        if (StringUtils.isBlank(email)) {
            form.addError("emailAgain", "emailAgain_empty", "Please enter the email again");
        }
        if (form.isValid("emailAgain") && !emailAgain.equals(email)) {
            form.addError("emailAgain", "emailAgain_mustMatch", "Must match the first email field.");
        }
        if ((tags = form.getJsonArray("tags")).size() < 1) {
            form.addError("tags", "tags_minSize", "Please specify the tags.");
        }
        if (form.isValid("tags")) {
            boolean atLeastOneTagError = false;
            for (int i = 0; i < tags.size(); ++i) {
                String tag = tags.getString(i);
                String tagValidationKey = "tags[" + i + "]";
                if (StringUtils.isBlank(tag)) {
                    form.addError(tagValidationKey, "tag_empty", "Please specify the tag.");
                }
                atLeastOneTagError = atLeastOneTagError || form.isError(tagValidationKey);
            }
            if (atLeastOneTagError) {
                form.addError("tags", "tags_someInvalid", "Some tags are invalid.");
            }
        }
        if ("error".equals(action = form.getString("action"))) {
            form.addError("action", "action_invalid", "This option is not valid!");
        }
        if ("warning".equals(action)) {
            form.addWarning("action", "action_warning", "This option is a warning...");
        }
        if (StringUtils.isBlank(drink = form.getString("drink"))) {
            form.addError("drink", "drink_empty", "Please choose a drink!");
        }
        if (form.isValid("drink") && "beer".equals(drink) && form.isWarning("action")) {
            form.addError("drink", "beer_and_warning_action", "'Beer' is invalid if the 'Action on submit' field is a Warning!");
        }
        ArrayList<Integer> validNumbers = new ArrayList<Integer>();
        JsonArray numbers = form.getJsonArrayOrEmpty("numbers");
        for (int i = 0; i < numbers.size(); ++i) {
            Integer num = numbers.getInteger(i);
            if (num == null) continue;
            validNumbers.add(num);
        }
        if (validNumbers.size() != 2) {
            form.addError("numbers", "numbers_nbrRequired", "Please select exactly 2 numbers.");
        } else if (((Integer)validNumbers.get(0) + (Integer)validNumbers.get(1)) % 2 != 0) {
            form.addError("numbers", "ODD_OR_EVEN", "Both numbers must be odd or both even.");
        }
        JsonArray musicStyles = form.getJsonArray("musicStyles");
        boolean acceptTos = form.getBoolean("acceptTos", false);
        if (!acceptTos) {
            form.addError("acceptTos", "acceptTos_false", "You need to check this");
        }
    }
}

