/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.website.controllers.demos;

import com.google.inject.Inject;
import java.io.File;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.flash.FlashMessage;
import org.spincast.core.flash.FlashMessageFactory;
import org.spincast.core.flash.FlashMessageLevel;
import org.spincast.core.json.JsonObject;
import org.spincast.core.request.Form;
import org.spincast.core.server.UploadedFile;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.shaded.org.apache.commons.codec.binary.Base64;
import org.spincast.shaded.org.apache.commons.io.FileUtils;
import org.spincast.website.exchange.AppRequestContext;

public class DemoHtmlFormsFileUploadController {
    protected final Logger logger = LoggerFactory.getLogger(DemoHtmlFormsFileUploadController.class);
    private final FlashMessageFactory flashMessageFactory;

    @Inject
    public DemoHtmlFormsFileUploadController(FlashMessageFactory flashMessageFactory) {
        this.flashMessageFactory = flashMessageFactory;
    }

    protected FlashMessageFactory getFlashMessageFactory() {
        return this.flashMessageFactory;
    }

    public void fileUpload(AppRequestContext context) {
        FlashMessage flashMessage = context.request().getFlashMessage();
        if (flashMessage != null) {
            String uploadFileBase64ImageSrc = flashMessage.getVariables().getString("uploadFileBase64ImageSrc");
            if (uploadFileBase64ImageSrc == null) {
                this.logger.error("The uploadFileBase64ImageSrc was expected...");
            } else {
                context.response().getModel().set("uploadFileBase64ImageSrc", uploadFileBase64ImageSrc);
            }
        }
        this.sendTemplate(context);
    }

    protected void sendTemplate(AppRequestContext context) {
        context.response().sendTemplateHtml("/templates/demos/htmlForms/fileUpload.html");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileUploadSubmit(AppRequestContext context) {
        File file;
        long length;
        Form form = context.request().getFormWithRootKey("demoForm");
        context.response().addForm(form);
        UploadedFile uploadedFile = context.request().getUploadedFileFirst("demoForm.fileToUpload");
        if (uploadedFile == null) {
            form.addError("fileToUpload", "file_missing", "Please select a file to upload.");
        }
        if ((length = (file = uploadedFile.getFile()).length()) == 0L) {
            form.addError("fileToUpload", "file_empty", "The file is empty.");
        } else if (length / 1024L > 200L) {
            form.addError("fileToUpload", "file_too_big", "The file must be 200KB or less. It was " + length / 1024L + "KB.");
        }
        if (form.isValid("fileToUpload")) {
            try {
                ImageIO.read(file).toString();
            }
            catch (Exception e) {
                form.addError("fileToUpload", "fileToUpload_notValidImage", "The file must be a valid image of type PNG, JPEG, GIF or BMP.");
            }
        }
        if (!form.isValid()) {
            this.fileUpload(context);
        } else {
            ImageInputStream iis = null;
            JsonObject variables = context.json().create();
            try {
                iis = ImageIO.createImageInputStream(file);
                Iterator<ImageReader> iter = ImageIO.getImageReaders(iis);
                if (iter.hasNext()) {
                    String base64Str = Base64.encodeBase64String(FileUtils.readFileToByteArray(file));
                    String formatName = iter.next().getFormatName();
                    String uploadFileBase64ImageSrc = "data:image/" + formatName + ";charset=utf-8;base64," + base64Str;
                    variables.set("uploadFileBase64ImageSrc", uploadFileBase64ImageSrc);
                }
            }
            catch (Exception ex) {
                this.logger.error("Error converting the image to base 64.", ex);
            }
            finally {
                SpincastStatics.closeQuietly(iis);
            }
            context.response().redirect(this.getFlashMessageFactory().create(FlashMessageLevel.SUCCESS, "The file was uploaded successfully!", variables));
        }
    }
}

