/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.guice;

import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.DefaultBindingTargetVisitor;
import com.google.inject.spi.DefaultElementVisitor;
import com.google.inject.spi.Element;
import com.google.inject.spi.Elements;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.spi.UntargettedBinding;
import com.google.inject.util.Modules;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.guice.SpincastGuiceModuleBase;
import org.spincast.core.utils.SpincastStatics;

public class GuiceModuleUtils {
    protected static final Logger logger = LoggerFactory.getLogger(GuiceModuleUtils.class);
    private Module module;
    private List<Element> elements;

    public GuiceModuleUtils(Module module) {
        Objects.requireNonNull(module, "The module can't be NULL");
        this.module = module;
    }

    public GuiceModuleUtils(Set<Module> modules) {
        this(Modules.combine(modules));
    }

    public GuiceModuleUtils(Module ... modules) {
        this(Modules.combine(modules));
    }

    protected Module getModule() {
        return this.module;
    }

    protected List<Element> getElements() {
        if (this.elements == null) {
            this.elements = Elements.getElements(this.module);
        }
        return this.elements;
    }

    public boolean isKeyBound(Class<?> clazz) {
        return this.isKeyBound(Key.get(clazz));
    }

    public boolean isKeyBound(final Key<?> keyToCheck) {
        final boolean[] keyFound = new boolean[]{false};
        for (Element element : this.getElements()) {
            if (keyFound[0]) break;
            element.acceptVisitor(new DefaultElementVisitor<Void>(){

                @Override
                public <T> Void visit(Binding<T> binding) {
                    Key<T> key = binding.getKey();
                    if (key.equals(keyToCheck)) {
                        keyFound[0] = true;
                    }
                    return null;
                }
            });
        }
        return keyFound[0];
    }

    public <T> Class<? extends T> getBindingTarget(Key<T> specificKey) {
        Objects.requireNonNull(specificKey, "The key can't be NULL");
        Set<Class<T>> boundClasses = this.getBoundClasses(null, specificKey);
        if (boundClasses == null || boundClasses.size() == 0) {
            return null;
        }
        return boundClasses.iterator().next();
    }

    public <T> Class<? extends T> getBindingTarget(Class<T> specificClass) {
        return this.getBindingTarget(Key.get(specificClass));
    }

    public <T> Set<Class<? extends T>> getBoundClassesExtending(Class<? extends T> parentType) {
        Objects.requireNonNull(parentType, "The parent type can't be NULL");
        return this.getBoundClasses(parentType, null);
    }

    protected <T> Set<Class<? extends T>> getBoundClasses(final Class<? extends T> parentType, final Key<?> specificKey) {
        final HashSet<Class<? extends T>> bindings = new HashSet<Class<? extends T>>();
        for (Element element : this.getElements()) {
            element.acceptVisitor(new DefaultElementVisitor<Void>(){

                @Override
                public <B> Void visit(Binding<B> binding) {
                    binding.acceptTargetVisitor(new DefaultBindingTargetVisitor<B, Void>(){

                        @Override
                        public Void visit(InstanceBinding<? extends B> instanceBinding) {
                            Key key = instanceBinding.getKey();
                            Object instance = instanceBinding.getInstance();
                            if (instance instanceof Class) {
                                Class bindingClass = (Class)instance;
                                if (specificKey != null) {
                                    if (specificKey.equals(key)) {
                                        Class temp = bindingClass;
                                        bindings.add(temp);
                                    }
                                } else if (parentType.isAssignableFrom(bindingClass)) {
                                    Class temp = bindingClass;
                                    bindings.add(temp);
                                }
                            }
                            return null;
                        }

                        @Override
                        public Void visit(UntargettedBinding<? extends B> untargettedBinding) {
                            Key key = untargettedBinding.getKey();
                            Class keyClass = key.getTypeLiteral().getRawType();
                            if (specificKey != null) {
                                if (specificKey.equals(key)) {
                                    Class temp = keyClass;
                                    bindings.add(temp);
                                }
                            } else if (parentType.isAssignableFrom(keyClass)) {
                                Class temp = keyClass;
                                bindings.add(temp);
                            }
                            return null;
                        }

                        @Override
                        public Void visit(LinkedKeyBinding<? extends B> linkedKeyBinding) {
                            Key bindingKey = linkedKeyBinding.getKey();
                            Class bindingKeyClass = bindingKey.getTypeLiteral().getRawType();
                            Key linkedKey = linkedKeyBinding.getLinkedKey();
                            Class linkedKeyClass = linkedKey.getTypeLiteral().getRawType();
                            if (specificKey != null) {
                                if (specificKey.equals(bindingKey)) {
                                    Class temp = linkedKeyClass;
                                    bindings.add(temp);
                                }
                            } else if (parentType.isAssignableFrom(bindingKeyClass)) {
                                Class temp = linkedKeyClass;
                                bindings.add(temp);
                            }
                            return null;
                        }
                    });
                    return null;
                }
            });
        }
        return bindings;
    }

    public static <T> SpincastGuiceModuleBase createInterceptorModule(final Class<T> toIntercept, final Class<? extends T> implementationClass) {
        Objects.requireNonNull(toIntercept, "The Class to intercept can't be NULL");
        Objects.requireNonNull(implementationClass, "The implementation class can't be NULL");
        final HashMap<String, Method> toInterceptMethodsMap = new HashMap<String, Method>();
        Set<Method> toInterceptMethods = SpincastStatics.getAllMethods(implementationClass);
        for (Method toInterceptMethod : toInterceptMethods) {
            toInterceptMethodsMap.put(toInterceptMethod.getName(), toInterceptMethod);
        }
        return new SpincastGuiceModuleBase(){

            @Override
            protected void configure() {
                MethodInterceptor interceptor = new MethodInterceptor(){
                    @Inject
                    protected Provider<Injector> injector;
                    private T implementation;

                    public T getImplementation() {
                        if (this.implementation == null) {
                            this.implementation = this.injector.get().getInstance(implementationClass);
                        }
                        return this.implementation;
                    }

                    @Override
                    public Object invoke(MethodInvocation invocation) throws Throwable {
                        Method method = invocation.getMethod();
                        if (!toInterceptMethodsMap.containsKey(method.getName())) {
                            return invocation.proceed();
                        }
                        Method toInterceptMethod = (Method)toInterceptMethodsMap.get(method.getName());
                        toInterceptMethod.setAccessible(true);
                        try {
                            return toInterceptMethod.invoke(this.getImplementation(), invocation.getArguments());
                        }
                        catch (Exception ex) {
                            logger.error("invocation error", ex);
                            throw SpincastStatics.runtimize(ex);
                        }
                    }
                };
                this.requestInjection(interceptor);
                AbstractMatcher<Class> matcher = new AbstractMatcher<Class>(){
                    Matcher<Class> matcherToIntercept;
                    Matcher<Class> matcherImpl;
                    {
                        this.matcherToIntercept = Matchers.subclassesOf(toIntercept);
                        this.matcherImpl = Matchers.subclassesOf(implementationClass);
                    }

                    @Override
                    public boolean matches(Class t) {
                        return this.matcherToIntercept.matches(t) && !this.matcherImpl.matches(t);
                    }
                };
                this.bindInterceptor(matcher, Matchers.any(), interceptor);
            }
        };
    }

    public static Module removeBindings(Module module, final Set<Key<?>> keysToRemove) {
        if (keysToRemove == null || keysToRemove.size() == 0) {
            return module;
        }
        ArrayList<Element> elements = new ArrayList<Element>(Elements.getElements(module));
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            Element element = (Element)i.next();
            boolean remove = element.acceptVisitor(new DefaultElementVisitor<Boolean>(){

                @Override
                public <T> Boolean visit(Binding<T> binding) {
                    return keysToRemove.contains(binding.getKey());
                }

                @Override
                public Boolean visitOther(Element other) {
                    return false;
                }
            });
            if (!remove) continue;
            i.remove();
        }
        Module newModule = Elements.getModule(elements);
        return newModule;
    }
}

