/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.response;

import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.cookies.Cookie;
import org.spincast.core.cookies.CookieFactory;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.exchange.ResponseRequestContextAddon;
import org.spincast.core.json.JsonArray;
import org.spincast.core.json.JsonManager;
import org.spincast.core.json.JsonObject;
import org.spincast.core.request.Form;
import org.spincast.core.response.Alert;
import org.spincast.core.response.AlertDefault;
import org.spincast.core.response.AlertLevel;
import org.spincast.core.routing.ETagFactory;
import org.spincast.core.server.Server;
import org.spincast.core.session.FlashMessage;
import org.spincast.core.session.FlashMessageFactory;
import org.spincast.core.session.FlashMessageLevel;
import org.spincast.core.session.FlashMessagesHolder;
import org.spincast.core.utils.Bool;
import org.spincast.core.utils.ContentTypeDefaults;
import org.spincast.core.utils.GzipOption;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.utils.SpincastUtils;
import org.spincast.core.xml.XmlManager;
import org.spincast.shaded.org.apache.commons.io.IOUtils;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;
import org.spincast.shaded.org.apache.commons.lang3.time.DateUtils;
import org.spincast.shaded.org.apache.http.client.utils.URIBuilder;

public class SpincastResponseRequestContextAddon<R extends RequestContext<?>>
implements ResponseRequestContextAddon<R> {
    protected final Logger logger = LoggerFactory.getLogger(SpincastResponseRequestContextAddon.class);
    protected static final boolean IS_RESPONSE_CHARACTERS_BASED_BY_DEFAULT = false;
    private final R requestContext;
    private final Server server;
    private final JsonManager jsonManager;
    private final XmlManager xmlManager;
    private final SpincastConfig spincastConfig;
    private final SpincastUtils spincastUtils;
    private final ETagFactory etagFactory;
    private final FlashMessagesHolder flashMessagesHolder;
    private final FlashMessageFactory flashMessageFactory;
    private final CookieFactory cookieFactory;
    private String responseContentType = null;
    private int responseStatusCode = 200;
    private final ByteArrayOutputStream byteArrayOutputStreamIn = new ByteArrayOutputStream(256);
    private final ByteArrayOutputStream byteArrayOutputStreamOut = new ByteArrayOutputStream(256);
    private GZIPOutputStream gzipOutputStream = null;
    private Bool isShouldGzip = null;
    private String charactersCharsetName = "UTF-8";
    private boolean isResponseCharactersBased = false;
    private boolean requestSizeValidated = false;
    private Map<String, List<String>> headers;
    private GzipOption gzipOption = GzipOption.DEFAULT;
    private Map<String, Cookie> cookies;
    private JsonObject responseModel;

    @Inject
    public SpincastResponseRequestContextAddon(R requestContext, Server server, JsonManager jsonManager, XmlManager xmlManager, SpincastConfig spincastConfig, SpincastUtils spincastUtils, ETagFactory etagFactory, FlashMessagesHolder flashMessagesHolder, FlashMessageFactory flashMessageFactory, CookieFactory cookieFactory) {
        this.requestContext = requestContext;
        this.server = server;
        this.jsonManager = jsonManager;
        this.xmlManager = xmlManager;
        this.spincastConfig = spincastConfig;
        this.spincastUtils = spincastUtils;
        this.etagFactory = etagFactory;
        this.flashMessagesHolder = flashMessagesHolder;
        this.flashMessageFactory = flashMessageFactory;
        this.cookieFactory = cookieFactory;
    }

    protected R getRequestContext() {
        return this.requestContext;
    }

    protected Server getServer() {
        return this.server;
    }

    protected Object getExchange() {
        return this.getRequestContext().exchange();
    }

    protected JsonManager getJsonManager() {
        return this.jsonManager;
    }

    protected XmlManager getXmlManager() {
        return this.xmlManager;
    }

    protected SpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected SpincastUtils getSpincastUtils() {
        return this.spincastUtils;
    }

    protected ETagFactory getEtagFactory() {
        return this.etagFactory;
    }

    protected FlashMessagesHolder getFlashMessagesHolder() {
        return this.flashMessagesHolder;
    }

    protected FlashMessageFactory getFlashMessageFactory() {
        return this.flashMessageFactory;
    }

    protected CookieFactory getCookieFactory() {
        return this.cookieFactory;
    }

    protected ByteArrayOutputStream getBuffer() {
        return this.byteArrayOutputStreamIn;
    }

    protected ByteArrayOutputStream getOut() {
        return this.byteArrayOutputStreamOut;
    }

    @Override
    public JsonObject getModel() {
        if (this.responseModel == null) {
            this.responseModel = this.getJsonManager().create();
        }
        return this.responseModel;
    }

    public GZIPOutputStream getGzipBuffer() {
        try {
            if (this.gzipOutputStream == null) {
                this.gzipOutputStream = new GZIPOutputStream((OutputStream)this.getOut(), true);
            }
            return this.gzipOutputStream;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    protected boolean isRequestSizeValidated() {
        return this.requestSizeValidated;
    }

    protected void setRequestSizeValidated(boolean requestSizeValidated) {
        this.requestSizeValidated = requestSizeValidated;
    }

    @Override
    public ResponseRequestContextAddon<R> setGzipOption(GzipOption gzipOption) {
        if (gzipOption == null) {
            gzipOption = GzipOption.DEFAULT;
        }
        if (this.isHeadersSent() && gzipOption != this.getGzipOption()) {
            this.logger.warn("The headers are sent, you can't change the gzip options.");
            return this;
        }
        this.gzipOption = gzipOption;
        return this;
    }

    @Override
    public GzipOption getGzipOption() {
        return this.gzipOption;
    }

    @Override
    public int getStatusCode() {
        return this.responseStatusCode;
    }

    @Override
    public ResponseRequestContextAddon<R> setStatusCode(int responseStatusCode) {
        if (this.isHeadersSent()) {
            if (responseStatusCode != this.getStatusCode()) {
                this.logger.warn("Response headers already sent, the http status code can't be changed...");
            }
        } else {
            this.responseStatusCode = responseStatusCode;
        }
        return this;
    }

    @Override
    public String getContentType() {
        return this.responseContentType;
    }

    @Override
    public ResponseRequestContextAddon<R> setContentType(String responseContentType) {
        if (this.isHeadersSent()) {
            if (responseContentType != null && !responseContentType.equals(this.getContentType())) {
                this.logger.warn("Response headers already sent, the content-type can't be changed...");
            }
        } else {
            GzipOption gzipOption;
            if ((responseContentType != null && !responseContentType.equals(this.getContentType()) || responseContentType == null && this.getContentType() != null) && (gzipOption = this.getGzipOption()) == GzipOption.DEFAULT) {
                this.isShouldGzip = null;
            }
            this.responseContentType = responseContentType;
        }
        return this;
    }

    protected boolean isResponseCharactersBased() {
        return this.isResponseCharactersBased;
    }

    @Override
    public boolean isClosed() {
        return this.getServer().isResponseClosed(this.getExchange());
    }

    @Override
    public void redirect() {
        this.redirect("", false, null);
    }

    @Override
    public void redirect(FlashMessage flashMessage) {
        this.redirect("", false, flashMessage);
    }

    @Override
    public void redirect(FlashMessageLevel flashMessageType, String flashMessageText) {
        this.redirect(flashMessageType, flashMessageText, null);
    }

    @Override
    public void redirect(FlashMessageLevel flashMessageType, String flashMessageText, JsonObject flashMessageVariables) {
        this.redirect(this.getFlashMessageFactory().create(flashMessageType, flashMessageText, flashMessageVariables));
    }

    @Override
    public void redirect(String newUrl) {
        this.redirect(newUrl, false, null);
    }

    @Override
    public void redirect(String newUrl, FlashMessage flashMessage) {
        this.redirect(newUrl, false, flashMessage);
    }

    @Override
    public void redirect(String newUrl, FlashMessageLevel flashMessageType, String flashMessageText) {
        this.redirect(newUrl, flashMessageType, flashMessageText, null);
    }

    @Override
    public void redirect(String newUrl, FlashMessageLevel flashMessageType, String flashMessageText, JsonObject flashMessageVariables) {
        this.redirect(newUrl, this.getFlashMessageFactory().create(flashMessageType, flashMessageText, flashMessageVariables));
    }

    @Override
    public void redirect(String newUrl, boolean permanently) {
        this.redirect(newUrl, permanently, null);
    }

    @Override
    public void redirect(String newUrl, boolean permanently, FlashMessage flashMessage) {
        if (permanently) {
            this.redirect(newUrl, 301, flashMessage);
        } else {
            this.redirect(newUrl, 302, flashMessage);
        }
    }

    @Override
    public void redirect(String newUrl, boolean permanently, FlashMessageLevel flashMessageType, String flashMessageText) {
        this.redirect(newUrl, permanently, this.getFlashMessageFactory().create(flashMessageType, flashMessageText));
    }

    @Override
    public void redirect(String newUrl, boolean permanently, FlashMessageLevel flashMessageType, String flashMessageText, JsonObject flashMessageVariables) {
        this.redirect(newUrl, permanently, this.getFlashMessageFactory().create(flashMessageType, flashMessageText, flashMessageVariables));
    }

    @Override
    public void redirect(String newUrl, int specific3xxCode) {
        this.redirect(newUrl, specific3xxCode, null);
    }

    @Override
    public void redirect(String newUrl, int specific3xxCode, FlashMessageLevel flashMessageType, String flashMessageText) {
        this.redirect(newUrl, specific3xxCode, this.getFlashMessageFactory().create(flashMessageType, flashMessageText));
    }

    @Override
    public void redirect(String newUrl, int specific3xxCode, FlashMessageLevel flashMessageType, String flashMessageText, JsonObject flashMessageVariables) {
        this.redirect(newUrl, specific3xxCode, this.getFlashMessageFactory().create(flashMessageType, flashMessageText, flashMessageVariables));
    }

    @Override
    public void redirect(String newUrl, int specific3xxCode, FlashMessage flashMessage) {
        try {
            if (this.isHeadersSent()) {
                throw new RuntimeException("Can't set redirect, the headers are already sent.");
            }
            this.setStatusCode(specific3xxCode);
            if (StringUtils.isBlank(newUrl)) {
                newUrl = this.getRequestContext().request().getFullUrlOriginal();
            } else if ((newUrl = newUrl.trim()).startsWith("//")) {
                newUrl = this.getServer().getRequestScheme(this.getExchange()) + ":" + newUrl;
            }
            URI uri = new URI(newUrl);
            if (!uri.isAbsolute()) {
                URI currentUri = new URI(this.getRequestContext().request().getFullUrl());
                String anchor = null;
                if (uri.getFragment() != null) {
                    anchor = uri.getFragment();
                }
                String queryString = null;
                if (uri.getQuery() != null) {
                    queryString = uri.getQuery();
                }
                String path = uri.getPath();
                if (newUrl.startsWith("#") || newUrl.startsWith("?")) {
                    path = currentUri.getPath();
                } else if (!newUrl.startsWith("/")) {
                    String currentPath = currentUri.getPath();
                    int lastSlashPos = (currentPath = StringUtils.strip(currentPath, "/")).lastIndexOf("/");
                    path = lastSlashPos < 0 ? "/" + path : "/" + currentPath.substring(0, lastSlashPos) + "/" + path;
                }
                uri = new URI(currentUri.getScheme(), currentUri.getUserInfo(), currentUri.getHost(), currentUri.getPort(), path, queryString, anchor);
                newUrl = uri.toString();
            }
            if (flashMessage != null) {
                newUrl = this.saveFlashMessage(newUrl, flashMessage);
            }
            this.setHeader("Location", newUrl);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    protected String saveFlashMessage(String url, FlashMessage flashMessage) {
        if (flashMessage == null) {
            return url;
        }
        String flashMessageId = this.getFlashMessagesHolder().saveFlashMessage(flashMessage);
        if (this.getRequestContext().request().isCookiesEnabledValidated()) {
            this.getRequestContext().response().addCookieSession(this.getSpincastConfig().getCookieNameFlashMessage(), flashMessageId);
            return url;
        }
        try {
            URIBuilder builder = new URIBuilder(url);
            builder.setParameter(this.getSpincastConfig().getQueryParamFlashMessageId(), flashMessageId);
            return builder.build().toString();
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    @Override
    public void sendBytes(byte[] bytes) {
        this.sendBytes(bytes, null, false);
    }

    @Override
    public void sendBytes(byte[] bytes, String contentType) {
        this.sendBytes(bytes, contentType, false);
    }

    @Override
    public void sendBytes(byte[] bytes, String contentType, boolean flush) {
        this.send(bytes, contentType, flush);
    }

    protected void send(byte[] bytes, String contentType, boolean flush) {
        if (this.isClosed()) {
            this.logger.debug("The response is closed, nothing more can be sent!");
            return;
        }
        if (this.isHeadersSent()) {
            if (contentType != null && !contentType.equals(this.getContentType())) {
                this.logger.warn("Response headers are already sent, the content-type won't be changed...");
            }
        } else if (contentType != null) {
            if (this.getContentType() != null && !contentType.equals(this.getContentType())) {
                this.logger.warn("The content-type is changed from " + this.getContentType() + " to " + contentType);
            }
            this.setContentType(contentType);
        }
        if (bytes != null) {
            try {
                this.getBuffer().write(bytes);
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize(ex);
            }
        }
        if (flush) {
            this.flush();
        }
    }

    @Override
    public void sendCharacters(String content, String contentType) {
        this.sendCharacters(content, contentType, false);
    }

    @Override
    public void sendCharacters(String content, String contentType, boolean flush) {
        try {
            this.isResponseCharactersBased = true;
            byte[] bytes = null;
            if (content != null) {
                bytes = content.getBytes(this.getCharactersCharsetName());
            }
            this.send(bytes, contentType, flush);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    @Override
    public String getCharactersCharsetName() {
        return this.charactersCharsetName;
    }

    @Override
    public ResponseRequestContextAddon<R> setCharactersCharsetName(String charactersCharsetName) {
        Objects.requireNonNull(charactersCharsetName, "charactersCharsetName can't be NULL");
        if (this.isHeadersSent() && !charactersCharsetName.equalsIgnoreCase(this.getCharactersCharsetName())) {
            this.logger.warn("Some data have already been send, it may not be a good idea to change the Charset now.");
        }
        this.charactersCharsetName = charactersCharsetName;
        return this;
    }

    @Override
    public void sendPlainText(String string) {
        this.sendPlainText(string, false);
    }

    @Override
    public void sendPlainText(String string, boolean flush) {
        this.sendCharacters(string, ContentTypeDefaults.TEXT.getMainVariationWithUtf8Charset(), flush);
    }

    @Override
    public void sendHtml(String html) {
        this.sendHtml(html, false);
    }

    @Override
    public void sendHtml(String string, boolean flush) {
        this.sendCharacters(string, ContentTypeDefaults.HTML.getMainVariationWithUtf8Charset(), flush);
    }

    @Override
    public void sendParseHtml(String html) {
        this.sendParse(html, ContentTypeDefaults.HTML.getMainVariationWithUtf8Charset(), false);
    }

    @Override
    public void sendParseHtml(String html, boolean flush) {
        this.sendParse(html, ContentTypeDefaults.HTML.getMainVariationWithUtf8Charset(), flush);
    }

    @Override
    public void sendParse(String content, String contentType) {
        this.sendParse(content, contentType, false);
    }

    @Override
    public void sendParse(String content, String contentType, boolean flush) {
        if (StringUtils.isBlank(contentType)) {
            this.logger.warn("The Content-Type was not specified : 'text/html' will be used");
            contentType = ContentTypeDefaults.HTML.getMainVariationWithUtf8Charset();
        }
        if (content == null) {
            content = "";
        }
        String evaluated = this.getRequestContext().templating().evaluate(content, this.getModel());
        this.sendCharacters(evaluated, contentType, flush);
    }

    @Override
    public void sendTemplateHtml(String templatePath) {
        this.sendTemplateHtml(templatePath, true, false);
    }

    @Override
    public void sendTemplateHtml(String templatePath, boolean isClasspathPath) {
        this.sendTemplateHtml(templatePath, isClasspathPath, false);
    }

    @Override
    public void sendTemplateHtml(String templatePath, boolean isClasspathPath, boolean flush) {
        this.sendTemplate(templatePath, isClasspathPath, ContentTypeDefaults.HTML.getMainVariationWithUtf8Charset(), flush);
    }

    @Override
    public void sendTemplate(String templatePath, String contentType) {
        this.sendTemplate(templatePath, true, contentType, false);
    }

    @Override
    public void sendTemplate(String templatePath, String contentType, boolean flush) {
        this.sendTemplate(templatePath, true, contentType, flush);
    }

    @Override
    public void sendTemplate(String templatePath, boolean isClasspathPath, String contentType) {
        this.sendTemplate(templatePath, isClasspathPath, contentType, false);
    }

    @Override
    public void sendTemplate(String templatePath, boolean isClasspathPath, String contentType, boolean flush) {
        if (StringUtils.isBlank(contentType) && (contentType = this.getSpincastUtils().getMimeTypeFromPath(templatePath)) == null) {
            this.logger.warn("The Content-Type was not specified and can't be determined from the template path '" + templatePath + "': 'text/html' will be used");
            contentType = ContentTypeDefaults.HTML.getMainVariationWithUtf8Charset();
        }
        String evaluated = this.getRequestContext().templating().fromTemplate(templatePath, isClasspathPath, this.getModel());
        this.sendCharacters(evaluated, contentType, flush);
    }

    @Override
    public void sendJson() {
        this.sendJson(false);
    }

    @Override
    public void sendJson(boolean flush) {
        this.addAlertsToModel();
        String json = this.getJsonManager().toJsonString(this.getModel());
        this.sendCharacters(json, ContentTypeDefaults.JSON.getMainVariationWithUtf8Charset(), flush);
    }

    @Override
    public void sendJson(String jsonString) {
        this.sendJson(jsonString, false);
    }

    @Override
    public void sendJson(String jsonString, boolean flush) {
        this.sendCharacters(jsonString, ContentTypeDefaults.JSON.getMainVariationWithUtf8Charset(), flush);
    }

    @Override
    public void sendJson(Object obj) {
        this.sendJson(obj, false);
    }

    @Override
    public void sendJson(Object obj, boolean flush) {
        if (obj instanceof String) {
            this.sendJson((String)obj);
            return;
        }
        String json = this.getJsonManager().toJsonString(obj);
        this.sendCharacters(json, ContentTypeDefaults.JSON.getMainVariationWithUtf8Charset(), flush);
    }

    @Override
    public void sendXml() {
        this.sendXml(false);
    }

    @Override
    public void sendXml(boolean flush) {
        this.addAlertsToModel();
        String xml = this.getXmlManager().toXml(this.getModel());
        this.sendCharacters(xml, ContentTypeDefaults.XML.getMainVariationWithUtf8Charset(), flush);
    }

    @Override
    public void sendXml(String xml) {
        this.sendXml(xml, false);
    }

    @Override
    public void sendXml(String xml, boolean flush) {
        this.sendCharacters(xml, ContentTypeDefaults.XML.getMainVariationWithUtf8Charset(), flush);
    }

    @Override
    public void sendXml(Object obj) {
        this.sendXml(obj, false);
    }

    @Override
    public void sendXml(Object obj, boolean flush) {
        if (obj instanceof String) {
            this.sendXml((String)obj);
            return;
        }
        String xml = this.getXmlManager().toXml(obj);
        this.sendCharacters(xml, ContentTypeDefaults.XML.getMainVariationWithUtf8Charset(), flush);
    }

    protected void addAlertsToModel() {
        Map<String, Object> map;
        List alerts;
        if (this.isAddAlertsToModel() && (alerts = (List)(map = this.getRequestContext().templating().getSpincastReservedMap()).get("alerts")) != null && alerts.size() > 0) {
            JsonObject model = this.getModel();
            String spincastModelObjKey = this.getSpincastConfig().getSpincastModelRootVariableName();
            JsonObject spincastModelObj = model.getJsonObjectOrEmpty(spincastModelObjKey);
            model.put(spincastModelObjKey, spincastModelObj);
            JsonArray alertsArray = spincastModelObj.getJsonArrayOrEmpty("alerts");
            spincastModelObj.put("alerts", alertsArray);
            for (Alert alert : alerts) {
                alertsArray.add(alert);
            }
        }
    }

    protected boolean isAddAlertsToModel() {
        return true;
    }

    @Override
    public ResponseRequestContextAddon<R> resetBuffer() {
        try {
            this.getBuffer().reset();
            if (!this.isHeadersSent()) {
                this.isResponseCharactersBased = false;
            }
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
        return this;
    }

    @Override
    public ResponseRequestContextAddon<R> resetEverything() {
        return this.resetEverything(true);
    }

    @Override
    public ResponseRequestContextAddon<R> resetEverything(boolean resetCookies) {
        this.resetBuffer();
        if (this.isHeadersSent()) {
            this.logger.warn("Response headers are already sent, the cookies, headers and status code won't be reset...");
        } else {
            if (resetCookies) {
                this.getCookiesAdded().clear();
            }
            this.getHeaders().clear();
            this.setContentType(null);
            this.setStatusCode(200);
        }
        return this;
    }

    @Override
    public byte[] getUnsentBytes() {
        return this.getBuffer().toByteArray();
    }

    @Override
    public String getUnsentCharacters() {
        return this.getUnsentCharacters("UTF-8");
    }

    @Override
    public String getUnsentCharacters(String encoding) {
        try {
            byte[] unsentBytes = this.getUnsentBytes();
            return new String(unsentBytes, encoding);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    @Override
    public ResponseRequestContextAddon<R> removeHeader(String name) {
        if (this.isHeadersSent()) {
            this.logger.warn("Response headers are already sent, can't change them...");
            return this;
        }
        this.getHeaders().remove(name);
        return this;
    }

    @Override
    public ResponseRequestContextAddon<R> setHeader(String name, String value) {
        if (this.isHeadersSent()) {
            this.logger.warn("Response headers are already sent, can't change them...");
            return this;
        }
        if (value == null) {
            this.removeHeader(name);
            return this;
        }
        this.setHeader(name, Arrays.asList(value));
        return this;
    }

    @Override
    public ResponseRequestContextAddon<R> setHeader(String name, List<String> values) {
        if (this.isHeadersSent()) {
            this.logger.warn("Response headers are already sent, can't change them...");
            return this;
        }
        if (values == null) {
            this.removeHeader(name);
            return this;
        }
        this.getHeaders().put(name, values);
        return this;
    }

    @Override
    public ResponseRequestContextAddon<R> addHeaderValue(String name, String value) {
        if (this.isHeadersSent()) {
            this.logger.warn("Response headers are already sent, can't change them...");
            return this;
        }
        if (value == null) {
            return this;
        }
        this.addHeaderValues(name, Arrays.asList(value));
        return this;
    }

    @Override
    public ResponseRequestContextAddon<R> addHeaderValues(String name, List<String> values) {
        if (this.isHeadersSent()) {
            this.logger.warn("Response headers are already sent, can't change them...");
            return this;
        }
        if (values == null) {
            return this;
        }
        List<String> currentValues = this.getHeaders().get(name);
        if (currentValues == null) {
            currentValues = new ArrayList<String>();
            this.getHeaders().put(name, currentValues);
        }
        currentValues.addAll(values);
        return this;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        if (this.headers == null) {
            Map<String, List<String>> headersFromServer = this.getServer().getResponseHeaders(this.getExchange());
            TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            if (headersFromServer != null) {
                treeMap.putAll(headersFromServer);
            }
            this.headers = treeMap;
        }
        return this.headers;
    }

    @Override
    public List<String> getHeader(String name) {
        if (StringUtils.isBlank(name)) {
            return new LinkedList<String>();
        }
        List<String> values = this.getHeaders().get(name);
        if (values == null) {
            values = new LinkedList<String>();
        }
        return values;
    }

    @Override
    public String getHeaderFirst(String name) {
        List<String> values = this.getHeader(name);
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    @Override
    public boolean isHeadersSent() {
        return this.getServer().isResponseHeadersSent(this.getExchange());
    }

    protected void setIsShouldGzip(boolean isShouldGzip) {
        GzipOption gzipOption = this.getGzipOption();
        if (gzipOption != GzipOption.DEFAULT) {
            this.logger.warn("Can't turn on/off the gzip feature since the GzipOption is " + (Object)((Object)gzipOption));
            return;
        }
        try {
            if (this.isHeadersSent()) {
                if (this.isShouldGzip != null && this.isShouldGzip.getBoolean() != isShouldGzip) {
                    this.logger.warn("Can't turn on/off the gzip feature since headers are already sent.");
                }
                return;
            }
            if (this.isShouldGzip != null && this.isShouldGzip.getBoolean() && !isShouldGzip) {
                this.byteArrayOutputStreamIn.reset();
                this.getGzipBuffer().close();
                ByteArrayOutputStream buffer = this.getBuffer();
                if (buffer.size() > 0) {
                    GZIPInputStream gzipInputStream = new GZIPInputStream(new ByteArrayInputStream(buffer.toByteArray()));
                    byte[] ungzipedBytes = IOUtils.toByteArray(gzipInputStream);
                    this.byteArrayOutputStreamIn.write(ungzipedBytes);
                }
                this.gzipOutputStream = null;
            }
            this.isShouldGzip = Bool.from(isShouldGzip);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    protected boolean isShouldGzip() {
        GzipOption gzipOption = this.getGzipOption();
        if (gzipOption == GzipOption.FORCE) {
            return true;
        }
        if (gzipOption == GzipOption.DISABLE) {
            return false;
        }
        if (gzipOption != GzipOption.DEFAULT) {
            throw new RuntimeException("Unimplemented : " + (Object)((Object)gzipOption));
        }
        if (this.isShouldGzip == null) {
            String responseContentType;
            boolean hasGzipAcceptHeader = false;
            List<String> acceptEncodings = this.getRequestContext().request().getHeader("Accept-Encoding");
            if (acceptEncodings != null) {
                for (String acceptEncoding : acceptEncodings) {
                    if (acceptEncoding == null || !acceptEncoding.contains("gzip")) continue;
                    hasGzipAcceptHeader = true;
                    break;
                }
            }
            if ((responseContentType = this.getContentType()) == null) {
                String path = this.getRequestContext().request().getRequestPath();
                responseContentType = this.getSpincastUtils().getMimeTypeFromPath(path);
            }
            if (responseContentType != null) {
                if (!this.getSpincastUtils().isContentTypeToSkipGziping(responseContentType)) {
                    if (!hasGzipAcceptHeader) {
                        this.logger.debug("No gzip 'Accept-Encoding' header, we won't gzip the response.");
                        this.setIsShouldGzip(false);
                    } else {
                        this.setIsShouldGzip(true);
                    }
                }
            } else {
                this.setIsShouldGzip(false);
            }
        }
        if (this.isShouldGzip == null) {
            return false;
        }
        return this.isShouldGzip.getBoolean();
    }

    @Override
    public void end() {
        this.flush(true);
    }

    @Override
    public void flush() {
        this.flush(false);
    }

    @Override
    public void flush(boolean close) {
        try {
            byte[] bytesToFlush;
            if (this.isClosed()) {
                return;
            }
            if (!this.isRequestSizeValidated() && !this.isHeadersSent()) {
                this.setRequestSizeValidated(true);
                boolean requestSizeOk = this.getServer().forceRequestSizeValidation(this.getExchange());
                if (!requestSizeOk) {
                    this.resetEverything();
                    this.setStatusCode(413);
                }
            }
            ByteArrayOutputStream buffer = this.getBuffer();
            if (!this.isHeadersSent()) {
                this.getServer().setResponseStatusCode(this.getExchange(), this.getStatusCode());
                String responseContentType = this.getContentType();
                if (responseContentType == null) {
                    String mimeType = this.getSpincastUtils().getMimeTypeFromPath(this.getRequestContext().request().getRequestPath());
                    responseContentType = mimeType != null ? mimeType : (this.isResponseCharactersBased() || buffer.size() == 0 ? ContentTypeDefaults.TEXT.getMainVariationWithUtf8Charset() : ContentTypeDefaults.BINARY.getMainVariation());
                    this.setContentType(responseContentType);
                }
                this.setHeader("Content-Type", responseContentType);
                this.getServer().setResponseStatusCode(this.getExchange(), this.getStatusCode());
                if (close && !this.isShouldGzip()) {
                    this.setHeader("Content-Length", "" + buffer.size());
                }
                if (this.getSpincastConfig().isEnableCookiesValidator()) {
                    this.addCookie(this.createCookiesValidatorCookie());
                }
                this.getServer().addCookies(this.getExchange(), this.getCookiesAdded());
                if (this.isShouldGzip()) {
                    this.setHeader("Content-Encoding", "gzip");
                    this.setHeader("Transfer-Encoding", "chunked");
                }
                this.getServer().setResponseHeaders(this.getExchange(), this.getHeaders());
            }
            if (this.isShouldGzip()) {
                this.getGzipBuffer().write(buffer.toByteArray());
                this.getGzipBuffer().flush();
                if (close) {
                    this.getGzipBuffer().close();
                }
                bytesToFlush = this.getOut().toByteArray();
                this.getOut().reset();
            } else {
                bytesToFlush = buffer.toByteArray();
            }
            buffer.reset();
            this.getServer().flushBytes(this.getExchange(), bytesToFlush, close);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    private Cookie createCookiesValidatorCookie() {
        Cookie cookie = this.createCookie(this.getSpincastConfig().getCookiesValidatorCookieName());
        cookie.setValue("1");
        cookie.setExpiresUsingMaxAge(31536000);
        return cookie;
    }

    @Override
    public ResponseRequestContextAddon<R> setCacheSeconds(int cacheSeconds) {
        return this.setCacheSeconds(cacheSeconds, false);
    }

    @Override
    public ResponseRequestContextAddon<R> setCacheSeconds(int cacheSeconds, boolean isPrivateCache) {
        if (cacheSeconds <= 0) {
            this.logger.warn("A number of seconds below 1 doesn't send any cache headers: " + cacheSeconds);
            return this;
        }
        if (this.isHeadersSent()) {
            this.logger.error("The headers are sent, you can't add cache headers.");
            return this;
        }
        String cacheControl = "max-age=" + cacheSeconds;
        cacheControl = isPrivateCache ? "private, " + cacheControl : "public, " + cacheControl;
        this.setHeader("Cache-Control", cacheControl);
        return this;
    }

    @Override
    public void setModel(JsonObject model) {
        this.responseModel = model;
    }

    @Override
    public void addAlert(AlertLevel alertType, String alertText) {
        Map<String, Object> spincastMap = this.getRequestContext().templating().getSpincastReservedMap();
        ArrayList<Alert> alerts = (ArrayList<Alert>)spincastMap.get("alerts");
        if (alerts == null) {
            alerts = new ArrayList<Alert>();
            spincastMap.put("alerts", alerts);
        }
        alerts.add(this.createAlert(alertType, alertText));
    }

    protected Alert createAlert(AlertLevel alertType, String alertText) {
        return new AlertDefault(alertType, alertText);
    }

    @Override
    public Map<String, Cookie> getCookiesAdded() {
        if (this.cookies == null) {
            this.cookies = new HashMap<String, Cookie>();
        }
        return this.cookies;
    }

    @Override
    public Cookie getCookieAdded(String name) {
        return this.getCookiesAdded().get(name);
    }

    @Override
    public void addCookie(Cookie cookie) {
        boolean valid = this.validateCookie(cookie);
        if (!valid) {
            return;
        }
        this.getCookiesAdded().put(cookie.getName(), cookie);
    }

    @Override
    public void addCookieSession(String name, String value) {
        Cookie cookie = this.getCookieFactory().createCookie(name, value);
        this.addCookie(cookie);
    }

    @Override
    public void addCookieSession(String name, String value, boolean httpOnly) {
        Cookie cookie = this.getCookieFactory().createCookie(name, value);
        cookie.setHttpOnly(httpOnly);
        this.addCookie(cookie);
    }

    @Override
    public void addCookie10years(String name, String value) {
        this.addCookie(name, value, 315360000);
    }

    @Override
    public void addCookie(String name, String value, int nbrSecondsToLive) {
        Cookie cookie = this.getCookieFactory().createCookie(name, value);
        cookie.setExpiresUsingMaxAge(nbrSecondsToLive);
        this.addCookie(cookie);
    }

    @Override
    public void addCookie(String name, String value, int nbrSecondsToLive, boolean httpOnly) {
        Cookie cookie = this.getCookieFactory().createCookie(name, value);
        cookie.setExpiresUsingMaxAge(nbrSecondsToLive);
        cookie.setHttpOnly(httpOnly);
        this.addCookie(cookie);
    }

    @Override
    public void addCookie(String name, String value, String path, String domain, Date expires, boolean secure, boolean httpOnly, boolean discard, int version) {
        Cookie cookie = this.getCookieFactory().createCookie(name, value, path, domain, expires, secure, httpOnly, discard, version);
        this.addCookie(cookie);
    }

    protected boolean validateCookie(Cookie cookie) {
        Objects.requireNonNull(cookie, "Can't add a NULL cookie");
        String name = cookie.getName();
        if (StringUtils.isBlank(name)) {
            throw new RuntimeException("A cookie can't have an empty name");
        }
        return true;
    }

    @Override
    public void deleteCookie(String name) {
        if (name == null) {
            return;
        }
        Cookie cookie = this.createCookie(name);
        cookie.setExpires(DateUtils.addYears(new Date(), -1));
        this.addCookie(cookie);
    }

    @Override
    public void deleteAllCookiesUserHas() {
        this.getCookiesAdded().clear();
        for (String cookieName : this.getRequestContext().request().getCookies().keySet()) {
            this.deleteCookie(cookieName);
        }
    }

    @Override
    public Cookie createCookie(String name) {
        return this.getCookieFactory().createCookie(name);
    }

    @Override
    public void addForm(Form form) {
        this.addForm(form, this.getSpincastConfig().getValidationElementDefaultName());
    }

    @Override
    public void addForm(Form form, String validationElementName) {
        this.getModel().put(form.getFormName(), form);
        Object validationElementObj = this.getModel().getObject(validationElementName);
        if (validationElementObj == null) {
            validationElementObj = this.getJsonManager().create();
            this.getModel().put(validationElementName, validationElementObj);
        } else if (!(validationElementObj instanceof JsonObject)) {
            throw new RuntimeException("The '" + validationElementName + "' element already exists on the response's model but is not a JsonObject! It can't be used as the validation element : " + validationElementObj);
        }
        JsonObject validationElement = (JsonObject)validationElementObj;
        form.setValidationObject(validationElement);
    }
}

