/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.config;

import com.google.inject.Inject;
import java.io.File;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.shaded.org.apache.commons.io.FileUtils;

public class SpincastInit {
    private final SpincastConfig spincastConfig;

    @Inject
    public SpincastInit(SpincastConfig spincastConfig) {
        this.spincastConfig = spincastConfig;
    }

    @Inject
    public void init() {
        this.writableDirsCheck();
    }

    protected SpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected void writableDirsCheck() {
        try {
            File writableRootDir = this.getSpincastConfig().getWritableRootDir();
            if (!writableRootDir.isDirectory() || !writableRootDir.canWrite()) {
                throw new RuntimeException("A writable directory is required. Invalid : " + writableRootDir.getAbsolutePath());
            }
            File tempDir = this.getSpincastConfig().getTempDir();
            if (!tempDir.isDirectory()) {
                boolean result = tempDir.mkdirs();
                if (!result) {
                    throw new RuntimeException("Unable to create the temp writable folder : " + tempDir.getAbsolutePath());
                }
            } else {
                FileUtils.cleanDirectory(tempDir);
            }
            if (!tempDir.canWrite()) {
                throw new RuntimeException("A writable temp directory is required. Invalid : " + tempDir.getAbsolutePath());
            }
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }
}

