/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.website.controllers.demos;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.json.JsonObject;
import org.spincast.core.session.FlashMessageLevel;
import org.spincast.core.validation.JsonObjectValidationSet;
import org.spincast.core.validation.ValidationBuilderCore;
import org.spincast.core.validation.ValidationSet;
import org.spincast.website.exchange.AppRequestContext;

public class DemoHtmlFormsSingleFieldController {
    protected final Logger logger = LoggerFactory.getLogger(DemoHtmlFormsSingleFieldController.class);

    protected void sendTemplate(AppRequestContext context) {
        context.response().sendTemplateHtml("/templates/demos/htmlForms/single.html");
    }

    public void singleField(AppRequestContext context) {
        this.sendTemplate(context);
    }

    public void singleFieldSubmit(AppRequestContext context) {
        JsonObject form = context.request().getFormData().getJsonObject("demoForm");
        ValidationSet validationResult = this.validateForm(form).prefixValidationKeys("demoForm.");
        boolean process = true;
        if (!validationResult.isValid() || validationResult.getMessages().size() > 0 || "stay@example.com".equals(form.getString("email"))) {
            process = false;
        }
        if (!process) {
            context.response().getModel().put("demoForm", form);
            context.response().getModel().put("validation", validationResult);
            this.sendTemplate(context);
        } else {
            context.response().redirect(FlashMessageLevel.SUCCESS, "The form has been processed successfully.");
        }
    }

    protected ValidationSet validateForm(JsonObject form) {
        JsonObjectValidationSet validationSet = form.validationSet();
        ValidationSet lastResult = ((ValidationBuilderCore)validationSet.validationNotBlank().jsonPath("email").failMessageText("The email is required")).validate();
        if (!validationSet.hasMessages()) {
            lastResult = validationSet.validationEmail().jsonPath("email").validate();
        }
        if (!validationSet.hasMessages()) {
            lastResult = ((ValidationBuilderCore)((ValidationBuilderCore)validationSet.validationMinLength(8).jsonPath("email").treatErrorAsWarning()).failMessageText("This is valid but seems quite short for an email.")).validate();
        }
        if (!validationSet.hasMessages()) {
            String email = form.getString("email");
            if ("success@example.com".equalsIgnoreCase(email)) {
                lastResult = validationSet.addSuccess("email", "successEmail", "This is a success message");
            } else if ("all@example.com".equalsIgnoreCase(email)) {
                lastResult = validationSet.addSuccess("email", "successEmail", "This is a success message");
                lastResult = validationSet.addWarning("email", "warningEmail", "This is a warning message");
                lastResult = validationSet.addError("email", "errorEmail", "This is an error message");
            }
        }
        return validationSet;
    }
}

