/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.validation;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import javax.annotation.Nullable;
import org.spincast.core.config.SpincastDictionary;
import org.spincast.core.json.JsonArray;
import org.spincast.core.json.JsonManager;
import org.spincast.core.validation.SimpleValidator;
import org.spincast.core.validation.ValidationBuilderArray;
import org.spincast.core.validation.ValidationBuilderCoreBaseDefault;
import org.spincast.core.validation.ValidationFactory;
import org.spincast.core.validation.ValidationLevel;
import org.spincast.core.validation.ValidationMessage;
import org.spincast.core.validation.ValidationSet;

public class ValidationBuilderArrayDefault
extends ValidationBuilderCoreBaseDefault<ValidationBuilderArray>
implements ValidationBuilderArray {
    private boolean arrayItselfAddSuccessMessage = false;
    private boolean arrayItselfAddFailMessage = false;
    private String arrayItselfAddSuccessMessageValidationKey;
    private String arrayItselfAddFailMessageValidationKey;
    private String arrayItselfCustomFailMessageText;
    private String arrayItselfCustomSuccessMessageText;
    private final boolean elementWasNotAnArray;

    @AssistedInject
    public ValidationBuilderArrayDefault(@Assisted ValidationSet validationSet, @Assisted SimpleValidator validator, @Assisted String validationKey, @Assisted @Nullable JsonArray array, ValidationFactory validationFactory, SpincastDictionary spincastDictionary, JsonManager jsonManager) {
        this(validationSet, validator, validationKey, array, false, validationFactory, spincastDictionary, jsonManager);
    }

    @AssistedInject
    public ValidationBuilderArrayDefault(@Assisted ValidationSet validationSet, @Assisted SimpleValidator validator, @Assisted String validationKey, @Assisted @Nullable JsonArray array, @Assisted boolean elementWasNotAnArray, ValidationFactory validationFactory, SpincastDictionary spincastDictionary, JsonManager jsonManager) {
        super(validationSet, validator, validationKey, array, validationFactory, spincastDictionary, jsonManager);
        this.elementWasNotAnArray = elementWasNotAnArray;
    }

    protected boolean isElementWasNotAnArray() {
        return this.elementWasNotAnArray;
    }

    protected String getArrayItselfCustomErrorMessageText() {
        return this.arrayItselfCustomFailMessageText;
    }

    protected String getArrayItselfAddSuccessMessageValidationKey() {
        return this.arrayItselfAddSuccessMessageValidationKey;
    }

    protected String getArrayItselfAddFailMessageValidationKey() {
        return this.arrayItselfAddFailMessageValidationKey;
    }

    @Override
    public ValidationBuilderArray arrayItselfAddSuccessMessage() {
        return this.arrayItselfAddSuccessMessage(this.getValidationKey(), null);
    }

    @Override
    public ValidationBuilderArray arrayItselfAddSuccessMessage(String customSuccessMessageText) {
        return this.arrayItselfAddSuccessMessage(this.getValidationKey(), customSuccessMessageText);
    }

    @Override
    public ValidationBuilderArray arrayItselfAddSuccessMessage(String validationKey, String customSuccessMessageText) {
        this.arrayItselfAddSuccessMessageValidationKey = validationKey;
        this.arrayItselfAddSuccessMessage = true;
        this.arrayItselfCustomSuccessMessageText = customSuccessMessageText;
        return this;
    }

    @Override
    public ValidationBuilderArray arrayItselfAddFailMessage() {
        return this.arrayItselfAddFailMessage(this.getValidationKey(), null);
    }

    @Override
    public ValidationBuilderArray arrayItselfAddFailMessage(String customSuccessMessageText) {
        return this.arrayItselfAddFailMessage(this.getValidationKey(), customSuccessMessageText);
    }

    @Override
    public ValidationBuilderArray arrayItselfAddFailMessage(String validationKey, String customFailMessageText) {
        this.arrayItselfAddFailMessageValidationKey = validationKey;
        this.arrayItselfAddFailMessage = true;
        this.arrayItselfCustomFailMessageText = customFailMessageText;
        return this;
    }

    protected boolean isArrayItselfAddSuccessMessage() {
        return this.arrayItselfAddSuccessMessage;
    }

    protected boolean isArrayItselfAddFailMessage() {
        return this.arrayItselfAddFailMessage;
    }

    protected String getArrayItselfCustomSuccessMessageText() {
        return this.arrayItselfCustomSuccessMessageText;
    }

    protected String getArrayItselfCustomFailMessageText() {
        return this.arrayItselfCustomFailMessageText;
    }

    protected String getArrayItselfDefaultSuccessMessageText() {
        return this.getSpincastDictionary().validation_array_itself_success_message_default_text();
    }

    protected String getArrayItselfDefaultWarningMessageText() {
        return this.getSpincastDictionary().validation_array_itself_warning_message_default_text();
    }

    protected String getArrayItselfDefaultErrorMessageText() {
        return this.getSpincastDictionary().validation_array_itself_error_message_default_text();
    }

    protected String getNotArrayDefaultErrorMessageText() {
        return this.getSpincastDictionary().validation_not_an_array_error_message_default_text();
    }

    @Override
    public ValidationSet validate(ValidationLevel onlyIfNoMessageAtThisLevelOrHigherYet) {
        if (this.isElementWasNotAnArray()) {
            String message = this.getArrayItselfCustomErrorMessageText() != null ? this.getArrayItselfCustomErrorMessageText() : this.getNotArrayDefaultErrorMessageText();
            ValidationMessage notArrayMessage = this.getValidationFactory().createMessage(ValidationLevel.ERROR, "VALIDATION_TYPE_NOT_AN_ARRAY", message);
            if (this.getValidationSet() != null) {
                this.getValidationSet().addMessage(this.getValidationKey(), notArrayMessage);
            }
            return this.getValidationFactory().createValidationSet(this.getValidationKey(), notArrayMessage);
        }
        JsonArray array = (JsonArray)this.getElementToValidate();
        if (array == null) {
            array = this.getJsonManager().createArray();
        }
        ValidationSet finalResult = this.getValidationFactory().createValidationSet();
        int pos = 0;
        for (Object element : array) {
            ValidationSet result = this.validateElement(this.getValidationKey() + "[" + pos++ + "]", element, onlyIfNoMessageAtThisLevelOrHigherYet);
            finalResult.mergeValidationSet(result);
        }
        if (finalResult.isSuccess()) {
            if (this.isArrayItselfAddSuccessMessage()) {
                String message = this.getArrayItselfCustomSuccessMessageText() != null ? this.getArrayItselfCustomSuccessMessageText() : this.getArrayItselfDefaultSuccessMessageText();
                String code = this.getCode() != null ? this.getCode() : this.getSimpleValidator().getCode();
                ValidationMessage arrayMessage = this.getValidationFactory().createMessage(ValidationLevel.SUCCESS, code, message);
                this.getValidationSet().addMessage(this.getArrayItselfAddSuccessMessageValidationKey(), arrayMessage);
                finalResult.addMessage(this.getArrayItselfAddSuccessMessageValidationKey(), arrayMessage);
            }
        } else if (this.isArrayItselfAddFailMessage()) {
            ValidationLevel level = finalResult.isWarning() ? ValidationLevel.WARNING : ValidationLevel.ERROR;
            String message = this.getArrayItselfCustomErrorMessageText();
            if (message == null) {
                message = this.isTreatErrorAsWarning() ? this.getArrayItselfDefaultWarningMessageText() : this.getArrayItselfDefaultErrorMessageText();
            }
            String code = this.getCode() != null ? this.getCode() : this.getSimpleValidator().getCode();
            ValidationMessage arrayMessage = this.getValidationFactory().createMessage(level, code, message);
            this.getValidationSet().addMessage(this.getArrayItselfAddFailMessageValidationKey(), arrayMessage);
            finalResult.addMessage(this.getArrayItselfAddFailMessageValidationKey(), arrayMessage);
        }
        return finalResult;
    }
}

