/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.website.controllers.demos;

import com.google.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.json.JsonArray;
import org.spincast.core.json.JsonManager;
import org.spincast.core.json.JsonObject;
import org.spincast.core.session.FlashMessageLevel;
import org.spincast.core.validation.JsonObjectValidationSet;
import org.spincast.core.validation.ValidationBuilderArray;
import org.spincast.core.validation.ValidationBuilderCore;
import org.spincast.core.validation.ValidationFactory;
import org.spincast.core.validation.ValidationSet;
import org.spincast.website.exchange.AppRequestContext;

public class DemoHtmlFormsMultipleFieldsController {
    protected final Logger logger = LoggerFactory.getLogger(DemoHtmlFormsMultipleFieldsController.class);
    private final ValidationFactory validationFactory;
    private final JsonManager jsonManager;

    @Inject
    public DemoHtmlFormsMultipleFieldsController(ValidationFactory validationFactory, JsonManager jsonManager) {
        this.validationFactory = validationFactory;
        this.jsonManager = jsonManager;
    }

    protected ValidationFactory getValidationFactory() {
        return this.validationFactory;
    }

    protected JsonManager getJsonManager() {
        return this.jsonManager;
    }

    protected void sendTemplate(AppRequestContext context) {
        context.response().sendTemplateHtml("/templates/demos/htmlForms/multiple.html");
    }

    public void multipleFields(AppRequestContext context) {
        this.sendTemplate(context);
    }

    public void multipleFieldsSubmit(AppRequestContext context) {
        JsonObject form = context.request().getFormData().getJsonObject("demoForm").clone(true);
        ValidationSet validationResult = this.validateForm(form).prefixValidationKeys("demoForm.");
        if (!validationResult.isValid() || "stay".equals(form.getString("action"))) {
            context.response().getModel().put("demoForm", form);
            context.response().getModel().put("validation", validationResult);
            this.sendTemplate(context);
        } else {
            context.response().redirect(FlashMessageLevel.SUCCESS, "The form has been processed successfully.");
        }
    }

    protected ValidationSet validateForm(JsonObject form) {
        JsonObjectValidationSet validationSet = form.validationSet();
        form.trimAll();
        ValidationSet lastResult = ((ValidationBuilderCore)validationSet.validationNotBlank().jsonPath("email").failMessageText("Please enter the email")).validate();
        if (lastResult.isValid()) {
            ((ValidationBuilderCore)validationSet.validationEmail().jsonPath("email").failMessageText("Please enter a valid email")).validate();
        }
        if ((lastResult = ((ValidationBuilderCore)validationSet.validationNotBlank().jsonPath("emailAgain").failMessageText("Please enter the email again")).validate()).isValid()) {
            lastResult = ((ValidationBuilderCore)validationSet.validationEquivalent(form.getString("email")).jsonPath("emailAgain").failMessageText("Must match the first email field.")).validate();
        }
        lastResult = ((ValidationBuilderArray)validationSet.validationNotBlank().jsonPathAll("tags").failMessageText("Please specify the tag.")).arrayItselfAddFailMessage("Some tags are invalid.").validate();
        lastResult = ((ValidationBuilderCore)validationSet.validationNotEquivalent("error").jsonPath("action").failMessageText("This option is not valid!")).validate();
        lastResult = ((ValidationBuilderCore)((ValidationBuilderCore)validationSet.validationNotEquivalent("warning").jsonPath("action").treatErrorAsWarning()).failMessageText("This option is a warning...")).validate();
        lastResult = ((ValidationBuilderCore)validationSet.validationNotBlank().jsonPath("drink").failMessageText("Please choose a drink!")).validate();
        if (lastResult.isSuccess() && "beer".equals(form.getString("drink")) && validationSet.isWarning("action")) {
            validationSet.addError("drink", "BEER_AND_WARNING_ACTION", "'Beer' is invalid if the 'Action on submit' field is a Warning!");
        }
        if ((lastResult = ((ValidationBuilderCore)validationSet.validationSize(2, true).jsonPath("numbers").failMessageText("Please select exactly 2 numbers.")).validate()).isSuccess()) {
            JsonArray numbers = form.getJsonArray("numbers");
            Boolean num1Even = null;
            for (int i = 0; i < numbers.size(); ++i) {
                boolean num2Even;
                Integer num = numbers.getInteger(i);
                if (num == null) continue;
                if (num1Even == null) {
                    num1Even = num % 2 == 0;
                    continue;
                }
                boolean bl = num2Even = num % 2 == 0;
                if (num1Even.equals(num2Even)) continue;
                validationSet.addError("numbers", "ODD_OR_EVEN", "Both numbers must be odd or both even.");
                break;
            }
        }
        JsonArray musicStyles = form.getJsonArray("musicStyles");
        lastResult = ((ValidationBuilderCore)validationSet.validationEquivalent(true).jsonPath("acceptTos").failMessageText("You need to check this")).validate();
        return validationSet;
    }
}

