/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.website;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.guice.MainArgs;
import org.spincast.core.utils.SpincastUtils;
import org.spincast.plugins.configpropsfile.SpincastConfigPropsFileBased;
import org.spincast.plugins.configpropsfile.SpincastConfigPropsFilePluginConfig;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;
import org.spincast.shaded.org.apache.commons.lang3.tuple.Pair;
import org.spincast.website.AppConfig;

public class AppConfigDefault
extends SpincastConfigPropsFileBased
implements AppConfig {
    protected final Logger logger = LoggerFactory.getLogger(AppConfigDefault.class);
    public static final String APP_PROPERTIES_KEY_SERVER_SCHEME_HOST_PORT = "app.server.scheme_host_port";
    public static final String APP_PROPERTIES_KEY_ADMIN_CREDENTIAL_KEYS = "app.admin.admin_credentials_keys";
    private List<Pair<String, String>> adminUsernamesPasswords;

    @Inject
    public AppConfigDefault(SpincastUtils spincastUtils, @MainArgs @Nullable String[] mainArgs, @Nullable SpincastConfigPropsFilePluginConfig pluginConfig) {
        super(spincastUtils, mainArgs, pluginConfig);
    }

    @Override
    public int getHttpServerPort() {
        return this.getConfigInteger(this.getConfigKeyHttpServerPort(), 44420);
    }

    @Override
    public String getPublicServerSchemeHostPort() {
        return this.getConfig(APP_PROPERTIES_KEY_SERVER_SCHEME_HOST_PORT, "http://localhost:" + this.getHttpServerPort());
    }

    @Override
    public int getNbrNewsEntriesOnNewsPage() {
        return 5;
    }

    @Override
    public int getNbrNewsEntriesPerFeedRequest() {
        return 25;
    }

    @Override
    public List<Pair<String, String>> getAdminUsernamesPasswords() {
        if (this.adminUsernamesPasswords == null) {
            ArrayList<Pair<String, String>> usernamesPasswords = new ArrayList<Pair<String, String>>();
            String credentialKeysStr = this.getConfig(APP_PROPERTIES_KEY_ADMIN_CREDENTIAL_KEYS, "");
            if (!StringUtils.isBlank(credentialKeysStr)) {
                String[] credentialKeys;
                for (String credentialKey : credentialKeys = credentialKeysStr.split(",")) {
                    String userPassStr;
                    if (StringUtils.isBlank(credentialKey) || StringUtils.isBlank(userPassStr = this.getConfig(credentialKey = credentialKey.trim()))) continue;
                    int commaPos = userPassStr.indexOf(",");
                    if (commaPos < 0) {
                        throw new RuntimeException("Invalid configuration in the .properties file. A admin credential entry doesn't contain a comma: " + credentialKey);
                    }
                    String userName = userPassStr.substring(0, commaPos).trim();
                    if (StringUtils.isBlank(userName)) {
                        throw new RuntimeException("Invalid configuration in the .properties file. A empty suername is not valid for key: " + credentialKey);
                    }
                    String password = userPassStr.substring(commaPos + 1).trim();
                    if (StringUtils.isBlank(password)) {
                        throw new RuntimeException("Invalid configuration in the .properties file. A empty password is not valid for user: " + userName);
                    }
                    Pair<String, String> userPassPair = Pair.of(userName, password);
                    usernamesPasswords.add(userPassPair);
                }
            } else if (this.isDebugEnabled() && this.getPublicServerSchemeHostPort().startsWith("http://localhost:")) {
                Pair<String, String> userPassPair = Pair.of("admin", "admin");
                usernamesPasswords.add(userPassPair);
            }
            this.adminUsernamesPasswords = usernamesPasswords;
        }
        return this.adminUsernamesPasswords;
    }
}

