/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.configpropsfile;

import com.google.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.guice.MainArgs;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.utils.SpincastUtils;
import org.spincast.plugins.config.SpincastConfigDefault;
import org.spincast.plugins.configpropsfile.FreeKeyConfig;
import org.spincast.plugins.configpropsfile.SpincastConfigPropsFilePluginConfig;
import org.spincast.shaded.org.apache.commons.io.IOUtils;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class SpincastConfigPropsFileBased
extends SpincastConfigDefault
implements SpincastConfig,
FreeKeyConfig {
    protected final Logger logger = LoggerFactory.getLogger(SpincastConfigPropsFileBased.class);
    public static final String APP_PROPERTIES_KEY_ENVIRONMENT_NAME = "spincast.environment.name";
    public static final String APP_PROPERTIES_KEY_ENVIRONMENT_IS_DEBUG = "spincast.environment.isDebug";
    public static final String APP_PROPERTIES_KEY_SERVER_HOST = "spincast.server.host";
    public static final String APP_PROPERTIES_KEY_HTTP_SERVER_PORT = "spincast.httpServer.port";
    public static final String APP_PROPERTIES_KEY_HTTPS_SERVER_PORT = "spincast.httpsServer.port";
    public static final String APP_PROPERTIES_KEY_HTTPS_SERVER_KEYSTORE_PATH = "spincast.httpsServer.keystore.path";
    public static final String APP_PROPERTIES_KEY_HTTPS_SERVER_KEYSTORE_TYPE = "spincast.httpsServer.keystore.type";
    public static final String APP_PROPERTIES_KEY_HTTPS_SERVER_KEYSTORE_STOREPASS = "spincast.httpsServer.keystore.storepass";
    public static final String APP_PROPERTIES_KEY_HTTPS_SERVER_KEYSTORE_KEYPASS = "spincast.httpsServer.keystore.keypass";
    private final SpincastUtils spincastUtils;
    private final String[] mainArgs;
    private final SpincastConfigPropsFilePluginConfig pluginConfig;
    private boolean specificAppPropertiesFilePathInited = false;
    private String specificAppPropertiesFilePath;
    private Properties appProperties;
    private boolean appPropertiesLoaded = false;
    private String foundPropertiesFilePath;
    private String publicServerSchemeHostPort;

    @Inject
    public SpincastConfigPropsFileBased(SpincastUtils spincastUtils, @MainArgs @Nullable String[] mainArgs, SpincastConfigPropsFilePluginConfig pluginConfig) {
        this.spincastUtils = spincastUtils;
        if (mainArgs == null) {
            mainArgs = new String[]{};
        }
        this.mainArgs = mainArgs;
        this.pluginConfig = pluginConfig;
    }

    protected SpincastConfigPropsFilePluginConfig getPluginConfig() {
        return this.pluginConfig;
    }

    protected SpincastUtils getSpincastUtils() {
        return this.spincastUtils;
    }

    protected String[] getMainArgs() {
        return this.mainArgs;
    }

    protected String getSpecificAppPropertiesFilePath() {
        if (!this.specificAppPropertiesFilePathInited) {
            this.specificAppPropertiesFilePathInited = true;
            this.specificAppPropertiesFilePath = this.lookForPropsFileSpecificPath();
        }
        return this.specificAppPropertiesFilePath;
    }

    protected String lookForPropsFileSpecificPath() {
        if (this.getPluginConfig().getSpecificPathMainArgsPosition() > 0) {
            int argPos = this.getPluginConfig().getSpecificPathMainArgsPosition();
            String[] mainArgs = this.getMainArgs();
            if (mainArgs != null && mainArgs.length >= argPos) {
                String filePath = mainArgs[argPos - 1];
                this.logger.info("Main argument #" + argPos + " found to be used as the configuration file path: " + filePath);
                return filePath;
            }
            this.logger.info("The path to the configuration file to use was not found as a main argument, we'll use another strategy.");
        }
        return null;
    }

    protected String getFoundPropertiesFilePath() {
        return this.foundPropertiesFilePath;
    }

    protected String getConfigKeyEnvironmentName() {
        return APP_PROPERTIES_KEY_ENVIRONMENT_NAME;
    }

    protected String getConfigKeyEnvironmentIsDebug() {
        return APP_PROPERTIES_KEY_ENVIRONMENT_IS_DEBUG;
    }

    protected String getConfigKeyServerHost() {
        return APP_PROPERTIES_KEY_SERVER_HOST;
    }

    protected String getConfigKeyHttpServerPort() {
        return APP_PROPERTIES_KEY_HTTP_SERVER_PORT;
    }

    protected String getConfigKeyHttpsServerPort() {
        return APP_PROPERTIES_KEY_HTTPS_SERVER_PORT;
    }

    protected String getConfigKeyHttpsServerKeystorePath() {
        return APP_PROPERTIES_KEY_HTTPS_SERVER_KEYSTORE_PATH;
    }

    protected String getConfigKeyHttpsServerKeystoreType() {
        return APP_PROPERTIES_KEY_HTTPS_SERVER_KEYSTORE_TYPE;
    }

    protected String getConfigKeyHttpsServerKeystoreStorePass() {
        return APP_PROPERTIES_KEY_HTTPS_SERVER_KEYSTORE_STOREPASS;
    }

    protected String getConfigKeyHttpsServerKeystoreKeyPass() {
        return APP_PROPERTIES_KEY_HTTPS_SERVER_KEYSTORE_KEYPASS;
    }

    protected Properties getAppProperties() {
        block12: {
            if (!this.appPropertiesLoaded) {
                this.appPropertiesLoaded = true;
                try {
                    this.appProperties = new Properties();
                    String specificPath = this.getSpecificAppPropertiesFilePath();
                    if (!StringUtils.isBlank(specificPath)) {
                        if (!new File(specificPath).isFile()) {
                            throw new RuntimeException("Specified environment specific configuration file not found: " + specificPath);
                        }
                        this.logger.info("Using environment specified configuration file : " + specificPath);
                        this.foundPropertiesFilePath = specificPath;
                        FileInputStream stream = new FileInputStream(specificPath);
                        try {
                            this.appProperties.load(stream);
                            break block12;
                        }
                        finally {
                            IOUtils.closeQuietly(stream);
                        }
                    }
                    File jarDir = this.getSpincastUtils().getAppJarDirectory();
                    if (jarDir != null) {
                        File appConfigFile = new File(jarDir.getAbsolutePath() + "/" + this.getPluginConfig().getNextToJarConfigFileName());
                        if (!appConfigFile.isFile()) {
                            this.logger.warn("No environment specific configuration file found. Default configurations will be used! Was looking for : " + appConfigFile.getAbsolutePath());
                        } else {
                            this.logger.info("Environment specific configuration file found : " + appConfigFile.getAbsolutePath());
                            this.foundPropertiesFilePath = appConfigFile.getAbsolutePath();
                            this.appProperties.load(new FileInputStream(appConfigFile));
                        }
                    } else {
                        this.logger.info("Running from an IDE, default configurations will be used!");
                    }
                }
                catch (Exception ex) {
                    throw SpincastStatics.runtimize(ex);
                }
            }
        }
        return this.appProperties;
    }

    @Override
    public String getConfig(String key) {
        return (String)this.getConfig(key, null, false);
    }

    @Override
    public String getConfig(String key, String defaultValue) {
        return (String)this.getConfig(key, defaultValue, true);
    }

    @Override
    public Boolean getConfigBoolean(String key) {
        Object value = this.getConfig(key, null, false);
        return Boolean.parseBoolean(value.toString());
    }

    @Override
    public Boolean getConfigBoolean(String key, Boolean defaultValue) {
        Object value = this.getConfig(key, defaultValue, true);
        if (value instanceof Boolean) {
            return (boolean)((Boolean)value);
        }
        return Boolean.parseBoolean(value.toString());
    }

    @Override
    public Integer getConfigInteger(String key) {
        Object value = this.getConfig(key, null, false);
        return Integer.parseInt(value.toString());
    }

    @Override
    public Integer getConfigInteger(String key, Integer defaultValue) {
        Object value = this.getConfig(key, defaultValue, true);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return Integer.parseInt(value.toString());
    }

    protected Object getConfig(String key, Object defaultValue, boolean useDefaultValue) {
        String value = this.getAppProperties().getProperty(key);
        if (value == null) {
            if (useDefaultValue) {
                return defaultValue;
            }
            String msg = "Configuration '" + key + "' not found and no default value provided.";
            if (this.getFoundPropertiesFilePath() != null) {
                msg = msg + " Properties file: " + this.getFoundPropertiesFilePath();
            }
            throw new RuntimeException(msg);
        }
        return value;
    }

    @Override
    public String getEnvironmentName() {
        return this.getConfig(this.getConfigKeyEnvironmentName(), super.getEnvironmentName());
    }

    @Override
    public boolean isDebugEnabled() {
        return this.getConfigBoolean(this.getConfigKeyEnvironmentIsDebug(), super.isDebugEnabled());
    }

    @Override
    public String getServerHost() {
        return this.getConfig(this.getConfigKeyServerHost(), super.getServerHost());
    }

    @Override
    public int getHttpServerPort() {
        return this.getConfigInteger(this.getConfigKeyHttpServerPort(), super.getHttpServerPort());
    }

    @Override
    public int getHttpsServerPort() {
        return this.getConfigInteger(this.getConfigKeyHttpsServerPort(), super.getHttpsServerPort());
    }

    @Override
    public String getHttpsKeyStorePath() {
        return this.getConfig(this.getConfigKeyHttpsServerKeystorePath(), super.getHttpsKeyStorePath());
    }

    @Override
    public String getHttpsKeyStoreType() {
        return this.getConfig(this.getConfigKeyHttpsServerKeystoreType(), super.getHttpsKeyStoreType());
    }

    @Override
    public String getHttpsKeyStoreStorePass() {
        return this.getConfig(this.getConfigKeyHttpsServerKeystoreStorePass(), super.getHttpsKeyStoreStorePass());
    }

    @Override
    public String getHttpsKeyStoreKeypass() {
        return this.getConfig(this.getConfigKeyHttpsServerKeystoreKeyPass(), super.getHttpsKeyStoreStorePass());
    }

    @Override
    public String getPublicServerSchemeHostPort() {
        if (this.publicServerSchemeHostPort == null) {
            StringBuilder builder = new StringBuilder();
            if (this.getHttpsServerPort() > -1) {
                builder.append("https://").append(this.getServerHost());
                int port = this.getHttpsServerPort();
                if (port != 443) {
                    builder.append(":").append(port);
                }
            } else {
                builder.append("http://").append(this.getServerHost());
                int port = this.getHttpsServerPort();
                if (port != 80) {
                    builder.append(":").append(port);
                }
            }
            this.publicServerSchemeHostPort = builder.toString();
        }
        return this.publicServerSchemeHostPort;
    }

    @Override
    public String getQueryParamFlashMessageId() {
        return "flash";
    }
}

