/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.routing;

import com.google.inject.Inject;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.routing.Router;
import org.spincast.core.websocket.WebsocketContext;

public class DefaultRouteParamAliasesBinder<R extends RequestContext<?>, W extends WebsocketContext<?>> {
    @Inject
    protected void init(SpincastConfig spincastConfig, Router<R, W> router) {
        boolean insensitive = !spincastConfig.isRoutesCaseSensitive();
        this.bindAlphaAlias(insensitive, router);
        this.bindNumericAlias(insensitive, router);
        this.bindAlphaNumericAlias(insensitive, router);
        this.bindAlphaPlusAlias(insensitive, router);
        this.bindNumericPlusAlias(insensitive, router);
        this.bindAlphaNumericPlusAlias(insensitive, router);
    }

    public String getAlphaAliasKey() {
        return "A";
    }

    protected void bindAlphaAlias(boolean insensitive, Router<R, W> router) {
        router.addRouteParamPatternAlias(this.getAlphaAliasKey(), (insensitive ? "(?i)" : "") + "[a-z]+");
    }

    public String geNumericAliasKey() {
        return "N";
    }

    protected void bindNumericAlias(boolean insensitive, Router<R, W> router) {
        router.addRouteParamPatternAlias(this.geNumericAliasKey(), "[0-9]+");
    }

    public String getAlphaPlusAliasKey() {
        return "A+";
    }

    protected void bindAlphaPlusAlias(boolean insensitive, Router<R, W> router) {
        router.addRouteParamPatternAlias(this.getAlphaPlusAliasKey(), (insensitive ? "(?i)" : "") + "[-_a-z]+");
    }

    public String geNumericPlusAliasKey() {
        return "N+";
    }

    protected void bindNumericPlusAlias(boolean insensitive, Router<R, W> router) {
        router.addRouteParamPatternAlias(this.geNumericPlusAliasKey(), "[-_0-9]+");
    }

    public String getAlphaNumericAliasKey() {
        return "AN";
    }

    protected void bindAlphaNumericAlias(boolean insensitive, Router<R, W> router) {
        router.addRouteParamPatternAlias(this.getAlphaNumericAliasKey(), (insensitive ? "(?i)" : "") + "[a-z0-9]+");
    }

    public String getAlphaNumericPlusAliasKey() {
        return "AN+";
    }

    protected void bindAlphaNumericPlusAlias(boolean insensitive, Router<R, W> router) {
        router.addRouteParamPatternAlias(this.getAlphaNumericPlusAliasKey(), (insensitive ? "(?i)" : "") + "[-_a-z0-9]+");
    }
}

