/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy.mod_cluster;

import io.undertow.UndertowLogger;
import io.undertow.client.UndertowClient;
import io.undertow.connector.ByteBufferPool;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.cache.LRUCache;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.mod_cluster.Balancer;
import io.undertow.server.handlers.proxy.mod_cluster.Context;
import io.undertow.server.handlers.proxy.mod_cluster.ModCluster;
import io.undertow.server.handlers.proxy.mod_cluster.ModClusterController;
import io.undertow.server.handlers.proxy.mod_cluster.ModClusterProxyClient;
import io.undertow.server.handlers.proxy.mod_cluster.ModClusterProxyTarget;
import io.undertow.server.handlers.proxy.mod_cluster.ModClusterStatus;
import io.undertow.server.handlers.proxy.mod_cluster.Node;
import io.undertow.server.handlers.proxy.mod_cluster.NodeConfig;
import io.undertow.server.handlers.proxy.mod_cluster.NodeHealthChecker;
import io.undertow.server.handlers.proxy.mod_cluster.NodeStatus;
import io.undertow.server.handlers.proxy.mod_cluster.VirtualHost;
import io.undertow.util.CopyOnWriteMap;
import io.undertow.util.Headers;
import io.undertow.util.PathMatcher;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.xnio.OptionMap;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.ssl.XnioSsl;

class ModClusterContainer
implements ModClusterController {
    private final ConcurrentMap<String, Balancer> balancers = new CopyOnWriteMap<String, Balancer>();
    private final ConcurrentMap<String, Node> nodes = new CopyOnWriteMap<String, Node>();
    private final ConcurrentMap<String, VirtualHost> hosts = new CopyOnWriteMap<String, VirtualHost>();
    private final LRUCache<String, String> failoverDomains = new LRUCache(100, 300000);
    private final ConcurrentMap<XnioIoThread, HealthCheckTask> healthChecks = new CopyOnWriteMap<XnioIoThread, HealthCheckTask>();
    private final UpdateLoadTask updateLoadTask = new UpdateLoadTask();
    private final XnioSsl xnioSsl;
    private final UndertowClient client;
    private final ProxyClient proxyClient;
    private final ModCluster modCluster;
    private final NodeHealthChecker healthChecker;
    private final long removeBrokenNodesThreshold;
    private final OptionMap clientOptions;

    ModClusterContainer(ModCluster modCluster, XnioSsl xnioSsl, UndertowClient client, OptionMap clientOptions) {
        this.xnioSsl = xnioSsl;
        this.client = client;
        this.modCluster = modCluster;
        this.clientOptions = clientOptions;
        this.healthChecker = modCluster.getHealthChecker();
        this.proxyClient = new ModClusterProxyClient(null, this);
        this.removeBrokenNodesThreshold = ModClusterContainer.removeThreshold(modCluster.getHealthCheckInterval(), modCluster.getRemoveBrokenNodes());
    }

    String getServerID() {
        return this.modCluster.getServerID();
    }

    UndertowClient getClient() {
        return this.client;
    }

    XnioSsl getXnioSsl() {
        return this.xnioSsl;
    }

    public ProxyClient getProxyClient() {
        return this.proxyClient;
    }

    Collection<Balancer> getBalancers() {
        return Collections.unmodifiableCollection(this.balancers.values());
    }

    Collection<Node> getNodes() {
        return Collections.unmodifiableCollection(this.nodes.values());
    }

    Node getNode(String jvmRoute) {
        return (Node)this.nodes.get(jvmRoute);
    }

    public ModClusterProxyTarget findTarget(HttpServerExchange exchange) {
        PathMatcher.PathMatch<VirtualHost.HostEntry> entry = this.mapVirtualHost(exchange);
        if (entry == null) {
            return null;
        }
        for (Balancer balancer : this.balancers.values()) {
            String id;
            String jvmRoute;
            String jvmRoute2;
            Map<String, Cookie> cookies = exchange.getRequestCookies();
            if (!balancer.isStickySession()) continue;
            if (cookies.containsKey(balancer.getStickySessionCookie()) && (jvmRoute2 = ModClusterContainer.getJVMRoute(cookies.get(balancer.getStickySessionCookie()).getValue())) != null) {
                return new ModClusterProxyTarget.ExistingSessionTarget(jvmRoute2, entry.getValue(), this, balancer.isStickySessionForce());
            }
            if (!exchange.getPathParameters().containsKey(balancer.getStickySessionPath()) || (jvmRoute = ModClusterContainer.getJVMRoute(id = exchange.getPathParameters().get(balancer.getStickySessionPath()).getFirst())) == null) continue;
            return new ModClusterProxyTarget.ExistingSessionTarget(jvmRoute, entry.getValue(), this, balancer.isStickySessionForce());
        }
        return new ModClusterProxyTarget.BasicTarget(entry.getValue(), this);
    }

    public synchronized boolean addNode(NodeConfig config, Balancer.BalancerBuilder balancerConfig, XnioIoThread ioThread, ByteBufferPool bufferPool) {
        String balancerRef;
        Balancer balancer;
        String jvmRoute = config.getJvmRoute();
        Node existing = (Node)this.nodes.get(jvmRoute);
        if (existing != null) {
            if (config.getConnectionURI().equals(existing.getNodeConfig().getConnectionURI())) {
                existing.resetState();
                return true;
            }
            existing.markRemoved();
            this.removeNode(existing);
            if (!existing.isInErrorState()) {
                return false;
            }
        }
        if ((balancer = (Balancer)this.balancers.get(balancerRef = config.getBalancer())) == null) {
            balancer = balancerConfig.build();
            this.balancers.put(balancerRef, balancer);
        }
        Node node = new Node(config, balancer, ioThread, bufferPool, this);
        this.nodes.put(jvmRoute, node);
        this.scheduleHealthCheck(node, ioThread);
        if (this.updateLoadTask.cancelKey == null) {
            this.updateLoadTask.cancelKey = ioThread.executeAtInterval(this.updateLoadTask, this.modCluster.getHealthCheckInterval(), TimeUnit.MILLISECONDS);
        }
        this.failoverDomains.remove(node.getJvmRoute());
        UndertowLogger.ROOT_LOGGER.registeringNode(jvmRoute, config.getConnectionURI());
        return true;
    }

    public synchronized boolean enableNode(String jvmRoute) {
        Node node = (Node)this.nodes.get(jvmRoute);
        if (node != null) {
            for (Context context : node.getContexts()) {
                context.enable();
            }
            return true;
        }
        return false;
    }

    public synchronized boolean disableNode(String jvmRoute) {
        Node node = (Node)this.nodes.get(jvmRoute);
        if (node != null) {
            for (Context context : node.getContexts()) {
                context.disable();
            }
            return true;
        }
        return false;
    }

    public synchronized boolean stopNode(String jvmRoute) {
        Node node = (Node)this.nodes.get(jvmRoute);
        if (node != null) {
            for (Context context : node.getContexts()) {
                context.stop();
            }
            return true;
        }
        return false;
    }

    public synchronized Node removeNode(String jvmRoute) {
        Node node = (Node)this.nodes.get(jvmRoute);
        if (node != null) {
            this.removeNode(node);
        }
        return node;
    }

    protected void removeNode(Node node) {
        this.removeNode(node, false);
    }

    protected synchronized void removeNode(Node node, boolean onlyInError) {
        if (onlyInError && !node.isInErrorState()) {
            return;
        }
        String jvmRoute = node.getJvmRoute();
        node.markRemoved();
        if (this.nodes.remove(jvmRoute, node)) {
            UndertowLogger.ROOT_LOGGER.removingNode(jvmRoute);
            node.markRemoved();
            this.removeHealthCheck(node, node.getIoThread());
            for (Context context : node.getContexts()) {
                this.removeContext(context.getPath(), node, context.getVirtualHosts());
            }
            String domain = node.getNodeConfig().getDomain();
            if (domain != null) {
                this.failoverDomains.add(node.getJvmRoute(), domain);
            }
            String balancerName = node.getBalancer().getName();
            for (Node other : this.nodes.values()) {
                if (!other.getBalancer().getName().equals(balancerName)) continue;
                return;
            }
            this.balancers.remove(balancerName);
        }
        if (this.nodes.size() == 0) {
            this.updateLoadTask.cancelKey.remove();
            this.updateLoadTask.cancelKey = null;
        }
    }

    public synchronized boolean enableContext(String contextPath, String jvmRoute, List<String> aliases) {
        Node node = (Node)this.nodes.get(jvmRoute);
        if (node != null) {
            Context context = node.getContext(contextPath, aliases);
            if (context == null) {
                context = node.registerContext(contextPath, aliases);
                UndertowLogger.ROOT_LOGGER.registeringContext(contextPath, jvmRoute);
                UndertowLogger.ROOT_LOGGER.registeringContext(contextPath, jvmRoute, aliases);
                for (String alias : aliases) {
                    VirtualHost virtualHost = (VirtualHost)this.hosts.get(alias);
                    if (virtualHost == null) {
                        virtualHost = new VirtualHost();
                        this.hosts.put(alias, virtualHost);
                    }
                    virtualHost.registerContext(contextPath, jvmRoute, context);
                }
            }
            context.enable();
            return true;
        }
        return false;
    }

    public synchronized boolean disableContext(String contextPath, String jvmRoute, List<String> aliases) {
        Node node = (Node)this.nodes.get(jvmRoute);
        if (node != null) {
            node.disableContext(contextPath, aliases);
            return true;
        }
        return false;
    }

    synchronized int stopContext(String contextPath, String jvmRoute, List<String> aliases) {
        Node node = (Node)this.nodes.get(jvmRoute);
        if (node != null) {
            return node.stopContext(contextPath, aliases);
        }
        return -1;
    }

    synchronized boolean removeContext(String contextPath, String jvmRoute, List<String> aliases) {
        Node node = (Node)this.nodes.get(jvmRoute);
        if (node != null) {
            return this.removeContext(contextPath, node, aliases);
        }
        return false;
    }

    public synchronized boolean removeContext(String contextPath, Node node, List<String> aliases) {
        if (node == null) {
            return false;
        }
        String jvmRoute = node.getJvmRoute();
        UndertowLogger.ROOT_LOGGER.unregisteringContext(contextPath, jvmRoute);
        Context context = node.removeContext(contextPath, aliases);
        if (context == null) {
            return false;
        }
        context.stop();
        for (String alias : context.getVirtualHosts()) {
            VirtualHost virtualHost = (VirtualHost)this.hosts.get(alias);
            if (virtualHost == null) continue;
            virtualHost.removeContext(contextPath, jvmRoute, context);
            if (!virtualHost.isEmpty()) continue;
            this.hosts.remove(alias);
        }
        return true;
    }

    Context findNewNode(VirtualHost.HostEntry entry) {
        return ModClusterContainer.electNode(entry.getContexts(), false, null);
    }

    Context findFailoverNode(VirtualHost.HostEntry entry, String domain, String jvmRoute, boolean forceStickySession) {
        Context context;
        String failOverDomain = null;
        if (domain == null) {
            Node node = (Node)this.nodes.get(jvmRoute);
            if (node != null) {
                failOverDomain = node.getNodeConfig().getDomain();
            }
            if (failOverDomain == null) {
                failOverDomain = this.failoverDomains.get(jvmRoute);
            }
        } else {
            failOverDomain = domain;
        }
        Collection<Context> contexts = entry.getContexts();
        if (failOverDomain != null && (context = ModClusterContainer.electNode(contexts, true, failOverDomain)) != null) {
            return context;
        }
        if (forceStickySession) {
            return null;
        }
        return ModClusterContainer.electNode(contexts, false, null);
    }

    private PathMatcher.PathMatch<VirtualHost.HostEntry> mapVirtualHost(HttpServerExchange exchange) {
        String context = exchange.getRelativePath();
        if (this.modCluster.isUseAlias()) {
            String hostName = exchange.getRequestHeaders().getFirst(Headers.HOST);
            if (hostName != null) {
                VirtualHost host;
                int i = hostName.indexOf(":");
                if (i > 0) {
                    host = (VirtualHost)this.hosts.get(hostName.substring(0, i));
                    if (host == null) {
                        host = (VirtualHost)this.hosts.get(hostName);
                    }
                } else {
                    host = (VirtualHost)this.hosts.get(hostName);
                }
                if (host == null) {
                    return null;
                }
                PathMatcher.PathMatch<VirtualHost.HostEntry> result = host.match(context);
                if (result.getValue() == null) {
                    return null;
                }
                return result;
            }
        } else {
            for (Map.Entry host : this.hosts.entrySet()) {
                PathMatcher.PathMatch<VirtualHost.HostEntry> result = ((VirtualHost)host.getValue()).match(context);
                if (result.getValue() == null) continue;
                return result;
            }
        }
        return null;
    }

    OptionMap getClientOptions() {
        return this.clientOptions;
    }

    static String getJVMRoute(String sessionId) {
        int index = sessionId.indexOf(46);
        if (index == -1) {
            return null;
        }
        return sessionId.substring(index + 1);
    }

    static Context electNode(Iterable<Context> contexts, boolean existingSession, String domain) {
        Context elected = null;
        Node candidate = null;
        boolean candidateHotStandby = false;
        for (Context context : contexts) {
            if (!context.checkAvailable(existingSession)) continue;
            Node node = context.getNode();
            boolean hotStandby = node.isHotStandby();
            if (domain != null && !domain.equals(node.getNodeConfig().getDomain())) continue;
            if (candidate != null) {
                int lbStatus2;
                int lbStatus1;
                if (candidateHotStandby) {
                    if (hotStandby) {
                        if (candidate.getElectedDiff() <= node.getElectedDiff()) continue;
                        candidate = node;
                        elected = context;
                        continue;
                    }
                    candidate = node;
                    elected = context;
                    candidateHotStandby = hotStandby;
                    continue;
                }
                if (hotStandby || (lbStatus1 = candidate.getLoadStatus()) <= (lbStatus2 = node.getLoadStatus())) continue;
                candidate = node;
                elected = context;
                candidateHotStandby = false;
                continue;
            }
            candidate = node;
            elected = context;
            candidateHotStandby = hotStandby;
        }
        if (candidate != null) {
            candidate.elected();
        }
        return elected;
    }

    void scheduleHealthCheck(Node node, XnioIoThread ioThread) {
        assert (Thread.holdsLock(this));
        HealthCheckTask task = (HealthCheckTask)this.healthChecks.get(ioThread);
        if (task == null) {
            task = new HealthCheckTask(this.removeBrokenNodesThreshold, this.healthChecker);
            this.healthChecks.put(ioThread, task);
            task.cancelKey = ioThread.executeAtInterval(task, this.modCluster.getHealthCheckInterval(), TimeUnit.MILLISECONDS);
        }
        task.nodes.add(node);
    }

    void removeHealthCheck(Node node, XnioIoThread ioThread) {
        assert (Thread.holdsLock(this));
        HealthCheckTask task = (HealthCheckTask)this.healthChecks.get(ioThread);
        if (task == null) {
            return;
        }
        task.nodes.remove(node);
        if (task.nodes.size() == 0) {
            this.healthChecks.remove(ioThread);
            task.cancelKey.remove();
        }
    }

    static long removeThreshold(long healthChecks, long removeBrokenNodes) {
        if (healthChecks > 0L && removeBrokenNodes > 0L) {
            long threshold = removeBrokenNodes / healthChecks;
            if (threshold > 1000L) {
                return 1000L;
            }
            if (threshold < 1L) {
                return 1L;
            }
            return threshold;
        }
        return -1L;
    }

    @Override
    public ModClusterStatus getStatus() {
        ArrayList<BalancerImpl> balancers = new ArrayList<BalancerImpl>();
        for (Map.Entry bentry : this.balancers.entrySet()) {
            ArrayList<NodeImpl> nodes = new ArrayList<NodeImpl>();
            for (Node node : this.getNodes()) {
                if (!node.getBalancer().getName().equals(bentry.getKey())) continue;
                ArrayList<ContextImpl> contexts = new ArrayList<ContextImpl>();
                for (Context i : node.getContexts()) {
                    contexts.add(new ContextImpl(i));
                }
                nodes.add(new NodeImpl(node, contexts));
            }
            balancers.add(new BalancerImpl((Balancer)bentry.getValue(), nodes));
        }
        return new ModClusterStatusImpl(balancers);
    }

    private class ContextImpl
    implements ModClusterStatus.Context {
        private final Context context;

        private ContextImpl(Context context) {
            this.context = context;
        }

        @Override
        public String getName() {
            return this.context.getPath();
        }

        @Override
        public boolean isEnabled() {
            return this.context.isEnabled();
        }

        @Override
        public boolean isStopped() {
            return this.context.isStopped();
        }

        @Override
        public int getRequests() {
            return this.context.getActiveRequests();
        }

        @Override
        public void enable() {
            this.context.enable();
        }

        @Override
        public void disable() {
            this.context.disable();
        }

        @Override
        public void stop() {
            this.context.stop();
        }
    }

    private class NodeImpl
    implements ModClusterStatus.Node {
        private final Node node;
        private final List<ModClusterStatus.Context> contexts;

        private NodeImpl(Node node, List<ModClusterStatus.Context> contexts) {
            this.node = node;
            this.contexts = contexts;
        }

        @Override
        public String getName() {
            return this.node.getJvmRoute();
        }

        @Override
        public URI getUri() {
            return this.node.getConnectionPool().getUri();
        }

        @Override
        public List<ModClusterStatus.Context> getContexts() {
            return Collections.unmodifiableList(this.contexts);
        }

        @Override
        public ModClusterStatus.Context getContext(String name) {
            for (ModClusterStatus.Context i : this.contexts) {
                if (!i.getName().equals(name)) continue;
                return i;
            }
            return null;
        }

        @Override
        public int getLoad() {
            return this.node.getLoad();
        }

        @Override
        public NodeStatus getStatus() {
            return this.node.getStatus();
        }

        @Override
        public int getOpenConnections() {
            return this.node.getConnectionPool().getOpenConnections();
        }

        @Override
        public long getTransferred() {
            return this.node.getConnectionPool().getClientStatistics().getWritten();
        }

        @Override
        public long getRead() {
            return this.node.getConnectionPool().getClientStatistics().getRead();
        }

        @Override
        public int getElected() {
            return this.node.getElected();
        }

        @Override
        public int getCacheConnections() {
            return this.node.getNodeConfig().getCacheConnections();
        }

        @Override
        public String getJvmRoute() {
            return this.node.getNodeConfig().getJvmRoute();
        }

        @Override
        public String getDomain() {
            return this.node.getNodeConfig().getDomain();
        }

        @Override
        public int getFlushWait() {
            return this.node.getNodeConfig().getFlushwait();
        }

        @Override
        public int getMaxConnections() {
            return this.node.getNodeConfig().getMaxConnections();
        }

        @Override
        public int getPing() {
            return this.node.getNodeConfig().getPing();
        }

        @Override
        public int getRequestQueueSize() {
            return this.node.getNodeConfig().getRequestQueueSize();
        }

        @Override
        public int getTimeout() {
            return this.node.getNodeConfig().getTimeout();
        }

        @Override
        public long getTtl() {
            return this.node.getNodeConfig().getTtl();
        }

        @Override
        public boolean isFlushPackets() {
            return this.node.getNodeConfig().isFlushPackets();
        }

        @Override
        public boolean isQueueNewRequests() {
            return this.node.getNodeConfig().isQueueNewRequests();
        }

        @Override
        public List<String> getAliases() {
            ArrayList<String> ret = new ArrayList<String>();
            for (Node.VHostMapping host : this.node.getVHosts()) {
                ret.addAll(host.getAliases());
            }
            return ret;
        }

        @Override
        public void resetStatistics() {
            this.node.getConnectionPool().getClientStatistics().reset();
        }
    }

    private class BalancerImpl
    implements ModClusterStatus.LoadBalancer {
        private final Balancer balancer;
        private final List<ModClusterStatus.Node> nodes;

        private BalancerImpl(Balancer balancer, List<ModClusterStatus.Node> nodes) {
            this.balancer = balancer;
            this.nodes = nodes;
        }

        @Override
        public String getName() {
            return this.balancer.getName();
        }

        @Override
        public List<ModClusterStatus.Node> getNodes() {
            return this.nodes;
        }

        @Override
        public ModClusterStatus.Node getNode(String name) {
            for (ModClusterStatus.Node i : this.nodes) {
                if (!i.getName().equals(name)) continue;
                return i;
            }
            return null;
        }

        @Override
        public boolean isStickySession() {
            return this.balancer.isStickySession();
        }

        @Override
        public String getStickySessionCookie() {
            return this.balancer.getStickySessionCookie();
        }

        @Override
        public String getStickySessionPath() {
            return null;
        }

        @Override
        public boolean isStickySessionRemove() {
            return this.balancer.isStickySessionRemove();
        }

        @Override
        public boolean isStickySessionForce() {
            return this.balancer.isStickySessionForce();
        }

        @Override
        public int getWaitWorker() {
            return this.balancer.getWaitWorker();
        }

        @Override
        public int getMaxAttempts() {
            return this.balancer.getMaxattempts();
        }
    }

    private class ModClusterStatusImpl
    implements ModClusterStatus {
        private final List<ModClusterStatus.LoadBalancer> balancers;

        private ModClusterStatusImpl(List<ModClusterStatus.LoadBalancer> balancers) {
            this.balancers = balancers;
        }

        @Override
        public List<ModClusterStatus.LoadBalancer> getLoadBalancers() {
            return this.balancers;
        }

        @Override
        public ModClusterStatus.LoadBalancer getLoadBalancer(String name) {
            for (ModClusterStatus.LoadBalancer b : this.balancers) {
                if (!b.getName().equals(name)) continue;
                return b;
            }
            return null;
        }
    }

    class UpdateLoadTask
    implements Runnable {
        private volatile XnioExecutor.Key cancelKey;

        UpdateLoadTask() {
        }

        @Override
        public void run() {
            for (Node node : ModClusterContainer.this.nodes.values()) {
                node.resetLbStatus();
            }
        }
    }

    static class HealthCheckTask
    implements Runnable {
        private final long threshold;
        private final NodeHealthChecker healthChecker;
        private final ArrayList<Node> nodes = new ArrayList();
        private volatile XnioExecutor.Key cancelKey;

        HealthCheckTask(long threshold, NodeHealthChecker healthChecker) {
            this.threshold = threshold;
            this.healthChecker = healthChecker;
        }

        @Override
        public void run() {
            for (Node node : this.nodes) {
                node.checkHealth(this.threshold, this.healthChecker);
            }
        }
    }
}

