/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.website;

import com.google.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.guice.MainArgs;
import org.spincast.core.utils.ISpincastUtils;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.config.SpincastConfig;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;
import org.spincast.website.IAppConfig;

public class AppConfig
extends SpincastConfig
implements IAppConfig {
    protected final Logger logger = LoggerFactory.getLogger(AppConfig.class);
    public static final String APP_PROPERTIES_FILE_NAME = "app.properties";
    public static final String APP_PROPERTIES_KEY_ENVIRONMENT_NAME = "environment.name";
    public static final String APP_PROPERTIES_KEY_ENVIRONMENT_IS_DEBUG = "environment.isDebug";
    public static final String APP_PROPERTIES_KEY_SERVER_HOST = "server.host";
    public static final String APP_PROPERTIES_KEY_HTTP_SERVER_PORT = "httpServer.port";
    public static final String APP_PROPERTIES_KEY_HTTPS_SERVER_PORT = "httpsServer.port";
    public static final String APP_PROPERTIES_KEY_HTTPS_SERVER_KEYSTORE_PATH = "httpsServer.keystore.path";
    public static final String APP_PROPERTIES_KEY_HTTPS_SERVER_KEYSTORE_TYPE = "httpsServer.keystore.type";
    public static final String APP_PROPERTIES_KEY_HTTPS_SERVER_KEYSTORE_STOREPASS = "httpsServer.keystore.storepass";
    public static final String APP_PROPERTIES_KEY_HTTPS_SERVER_KEYSTORE_KEYPASS = "httpsServer.keystore.keypass";
    private final String specificAppPropertiesFilePath;
    private final ISpincastUtils spincastUtils;
    private Properties appProperties;

    @Inject
    public AppConfig(ISpincastUtils spincastUtils, @MainArgs @Nullable String[] mainArgs) {
        this.spincastUtils = spincastUtils;
        this.specificAppPropertiesFilePath = mainArgs != null && mainArgs.length > 0 ? mainArgs[0] : null;
    }

    protected ISpincastUtils getSpincastUtils() {
        return this.spincastUtils;
    }

    protected Properties getAppProperties() {
        if (this.appProperties == null) {
            try {
                this.appProperties = new Properties();
                if (!StringUtils.isBlank(this.specificAppPropertiesFilePath)) {
                    this.logger.info("Using specified configuration file : " + this.specificAppPropertiesFilePath);
                    this.appProperties.load(new FileInputStream(this.specificAppPropertiesFilePath));
                } else {
                    File jarDir = this.getSpincastUtils().getAppJarDirectory();
                    if (jarDir != null) {
                        File appConfigFile = new File(jarDir.getAbsolutePath() + "/" + APP_PROPERTIES_FILE_NAME);
                        if (!appConfigFile.isFile()) {
                            this.logger.warn("No environment specific configuration file found. Default configurations will be used! Was looking for : " + appConfigFile.getAbsolutePath());
                        } else {
                            this.logger.info("Environment specific configuration file found : " + appConfigFile.getAbsolutePath());
                            this.appProperties.load(new FileInputStream(appConfigFile));
                        }
                    } else {
                        this.logger.info("Running from an IDE, default configurations will be used!");
                    }
                }
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize(ex);
            }
        }
        return this.appProperties;
    }

    @Override
    public String getEnvironmentName() {
        String value = this.getAppProperties().getProperty(APP_PROPERTIES_KEY_ENVIRONMENT_NAME);
        if (value != null) {
            return value;
        }
        return super.getEnvironmentName();
    }

    @Override
    public boolean isDebugEnabled() {
        String value = this.getAppProperties().getProperty(APP_PROPERTIES_KEY_ENVIRONMENT_IS_DEBUG);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return super.isDebugEnabled();
    }

    @Override
    public String getServerHost() {
        String value = this.getAppProperties().getProperty(APP_PROPERTIES_KEY_SERVER_HOST);
        if (value != null) {
            return value;
        }
        return super.getServerHost();
    }

    @Override
    public int getHttpServerPort() {
        String value = this.getAppProperties().getProperty(APP_PROPERTIES_KEY_HTTP_SERVER_PORT);
        if (value != null) {
            return Integer.valueOf(value);
        }
        return 44420;
    }

    @Override
    public int getHttpsServerPort() {
        String value = this.getAppProperties().getProperty(APP_PROPERTIES_KEY_HTTPS_SERVER_PORT);
        if (value != null) {
            return Integer.valueOf(value);
        }
        return super.getHttpsServerPort();
    }

    @Override
    public String getHttpsKeyStorePath() {
        String value = this.getAppProperties().getProperty(APP_PROPERTIES_KEY_HTTPS_SERVER_KEYSTORE_PATH);
        if (value != null) {
            return value;
        }
        return super.getHttpsKeyStorePath();
    }

    @Override
    public String getHttpsKeyStoreType() {
        String value = this.getAppProperties().getProperty(APP_PROPERTIES_KEY_HTTPS_SERVER_KEYSTORE_TYPE);
        if (value != null) {
            return value;
        }
        return super.getHttpsKeyStoreType();
    }

    @Override
    public String getHttpsKeyStoreStorePass() {
        String value = this.getAppProperties().getProperty(APP_PROPERTIES_KEY_HTTPS_SERVER_KEYSTORE_STOREPASS);
        if (value != null) {
            return value;
        }
        return super.getHttpsKeyStoreStorePass();
    }

    @Override
    public String getHttpsKeyStoreKeypass() {
        String value = this.getAppProperties().getProperty(APP_PROPERTIES_KEY_HTTPS_SERVER_KEYSTORE_KEYPASS);
        if (value != null) {
            return value;
        }
        return super.getHttpsKeyStoreStorePass();
    }
}

