/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.testing.core;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.File;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.spincast.core.config.ISpincastConfig;
import org.spincast.shaded.org.apache.commons.io.FileUtils;
import org.spincast.testing.utils.IBeforeAfterClassMethodsProvider;
import org.spincast.testing.utils.OneInstancePerClassJUnitRunner;

@RunWith(value=OneInstancePerClassJUnitRunner.class)
public abstract class SpincastGuiceBasedTestBase
implements IBeforeAfterClassMethodsProvider {
    private Injector guice;
    private File testingWritableDir;
    private ISpincastConfig spincastConfig;

    @Override
    public void beforeClass() {
        this.guice = this.createInjector();
        Assert.assertNotNull(this.guice);
        this.guice.injectMembers(this);
        this.deleteTempDir();
    }

    @Override
    public void afterClass() {
    }

    @Inject
    protected void setSpincastConfig(ISpincastConfig spincastConfig) {
        this.spincastConfig = spincastConfig;
    }

    protected ISpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected Injector getInjector() {
        return this.guice;
    }

    protected void deleteTempDir() {
        FileUtils.deleteQuietly(this.getTestingWritableDir());
    }

    protected File getTestingWritableDir() {
        if (this.testingWritableDir == null) {
            this.testingWritableDir = new File(this.getSpincastConfig().getSpincastWritableDir().getAbsolutePath() + "/testing");
            if (!this.testingWritableDir.isDirectory()) {
                boolean mkdirs = this.testingWritableDir.mkdirs();
                Assert.assertTrue(mkdirs);
            }
        }
        return this.testingWritableDir;
    }

    protected String createTestingFilePath(String relativePath) {
        return this.getTestingWritableDir().getAbsolutePath() + "/" + relativePath;
    }

    protected abstract Injector createInjector();
}

