/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.routing;

import com.google.inject.Inject;
import org.spincast.core.config.ISpincastConfig;
import org.spincast.core.exchange.IRequestContext;
import org.spincast.core.routing.IRouter;

public class DefaultRouteParamAliasesBinder<R extends IRequestContext<?>> {
    @Inject
    protected void init(ISpincastConfig spincastConfig, IRouter<R> router) {
        boolean insensitive = !spincastConfig.isRoutesCaseSensitive();
        this.bindAlphaAlias(insensitive, router);
        this.bindNumericAlias(insensitive, router);
        this.bindAlphaNumericAlias(insensitive, router);
        this.bindAlphaPlusAlias(insensitive, router);
        this.bindNumericPlusAlias(insensitive, router);
        this.bindAlphaNumericPlusAlias(insensitive, router);
    }

    public String getAlphaAliasKey() {
        return "A";
    }

    protected void bindAlphaAlias(boolean insensitive, IRouter<R> router) {
        router.addRouteParamPatternAlias(this.getAlphaAliasKey(), (insensitive ? "(?i)" : "") + "[a-z]+");
    }

    public String geNumericAliasKey() {
        return "N";
    }

    protected void bindNumericAlias(boolean insensitive, IRouter<R> router) {
        router.addRouteParamPatternAlias(this.geNumericAliasKey(), "[0-9]+");
    }

    public String getAlphaPlusAliasKey() {
        return "A+";
    }

    protected void bindAlphaPlusAlias(boolean insensitive, IRouter<R> router) {
        router.addRouteParamPatternAlias(this.getAlphaPlusAliasKey(), (insensitive ? "(?i)" : "") + "[-_a-z]+");
    }

    public String geNumericPlusAliasKey() {
        return "N+";
    }

    protected void bindNumericPlusAlias(boolean insensitive, IRouter<R> router) {
        router.addRouteParamPatternAlias(this.geNumericPlusAliasKey(), "[-_0-9]+");
    }

    public String getAlphaNumericAliasKey() {
        return "AN";
    }

    protected void bindAlphaNumericAlias(boolean insensitive, IRouter<R> router) {
        router.addRouteParamPatternAlias(this.getAlphaNumericAliasKey(), (insensitive ? "(?i)" : "") + "[a-z0-9]+");
    }

    public String getAlphaNumericPlusAliasKey() {
        return "AN+";
    }

    protected void bindAlphaNumericPlusAlias(boolean insensitive, IRouter<R> router) {
        router.addRouteParamPatternAlias(this.getAlphaNumericPlusAliasKey(), (insensitive ? "(?i)" : "") + "[-_a-z0-9]+");
    }
}

