/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.json;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.spincast.core.json.IJsonArray;

public interface IJsonObject
extends Iterable<Map.Entry<String, Object>> {
    public void put(String var1, Object var2);

    public void remove(String var1);

    public void removeAll();

    public Object get(String var1) throws KeyNotFoundException;

    public Object get(String var1, Object var2);

    public IJsonObject getJsonObject(String var1) throws KeyNotFoundException;

    public IJsonObject getJsonObject(String var1, IJsonObject var2);

    public IJsonArray getJsonArray(String var1) throws KeyNotFoundException;

    public IJsonArray getJsonArray(String var1, IJsonArray var2);

    public String getString(String var1) throws KeyNotFoundException;

    public String getString(String var1, String var2);

    public Integer getInteger(String var1) throws KeyNotFoundException;

    public Integer getInteger(String var1, Integer var2);

    public Long getLong(String var1) throws KeyNotFoundException;

    public Long getLong(String var1, Long var2);

    public Float getFloat(String var1) throws KeyNotFoundException;

    public Float getFloat(String var1, Float var2);

    public Double getDouble(String var1) throws KeyNotFoundException;

    public Double getDouble(String var1, Double var2);

    public Boolean getBoolean(String var1) throws KeyNotFoundException;

    public Boolean getBoolean(String var1, Boolean var2);

    public BigDecimal getBigDecimal(String var1) throws KeyNotFoundException;

    public BigDecimal getBigDecimal(String var1, BigDecimal var2);

    public byte[] getBytesFromBase64String(String var1) throws KeyNotFoundException;

    public byte[] getBytesFromBase64String(String var1, byte[] var2);

    public Date getDate(String var1) throws KeyNotFoundException;

    public Date getDate(String var1, Date var2);

    public String toJsonString();

    public String toJsonString(boolean var1);

    public Map<String, Object> getUnderlyingMap();

    public static class KeyNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final String key;

        public KeyNotFoundException(String key) {
            super("Key not found : " + key);
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

