/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite.loggingevent;

import ch.qos.logback.core.spi.DeferredProcessingAware;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import net.logstash.logback.composite.AbstractJsonProvider;
import net.logstash.logback.composite.JsonFactoryAware;

public class GlobalCustomFieldsJsonProvider<Event extends DeferredProcessingAware>
extends AbstractJsonProvider<Event>
implements JsonFactoryAware {
    private String customFields;
    private JsonNode customFieldsNode;
    private JsonFactory jsonFactory;

    @Override
    public void writeTo(JsonGenerator generator, Event event) throws IOException {
        this.writeFieldsOfNode(generator, this.customFieldsNode);
    }

    private void writeFieldsOfNode(JsonGenerator generator, JsonNode node) throws IOException {
        if (node != null) {
            Iterator<Map.Entry<String, JsonNode>> fields = node.fields();
            while (fields.hasNext()) {
                Map.Entry<String, JsonNode> field = fields.next();
                generator.writeFieldName(field.getKey());
                generator.writeTree(field.getValue());
            }
        }
    }

    @Override
    public void start() {
        this.initializeCustomFields();
        super.start();
    }

    private void initializeCustomFields() {
        if (this.customFields != null && this.jsonFactory != null) {
            try {
                this.customFieldsNode = (JsonNode)this.jsonFactory.createParser(this.customFields).readValueAsTree();
            }
            catch (IOException e) {
                this.addError("Failed to parse custom fields [" + this.customFields + "]", e);
            }
        }
    }

    public void setCustomFields(String customFields) {
        this.customFields = customFields;
        if (this.isStarted()) {
            this.initializeCustomFields();
        }
    }

    public String getCustomFields() {
        return this.customFields;
    }

    public JsonNode getCustomFieldsNode() {
        return this.customFieldsNode;
    }

    public void setCustomFieldsNode(JsonNode customFields) {
        this.customFieldsNode = customFields;
    }

    @Override
    public void setJsonFactory(JsonFactory jsonFactory) {
        this.jsonFactory = jsonFactory;
    }
}

