/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.website.maven;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.File;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.OS;
import org.spincast.core.guice.MainArgs;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.defaults.guice.SpincastDefaultGuiceModule;
import org.spincast.shaded.org.apache.commons.io.FileUtils;
import org.spincast.website.maven.SpincastMavenScriptBase;

public class SpincastMavenPreparePackageRelease
extends SpincastMavenScriptBase {
    private File javadocSourceGenerationDir;

    public static void main(String[] args) {
        Injector guice = Guice.createInjector(new SpincastDefaultGuiceModule(args));
        SpincastMavenPreparePackageRelease script = guice.getInstance(SpincastMavenPreparePackageRelease.class);
        script.start();
    }

    @Inject
    public SpincastMavenPreparePackageRelease(@MainArgs String[] mainArgs) {
        super(mainArgs);
    }

    protected File getJavadocSourceGenerationDir() {
        if (this.javadocSourceGenerationDir == null) {
            this.javadocSourceGenerationDir = new File(this.getProjectBaseDir().getAbsolutePath() + "/../target/site/apidocs");
        }
        return this.javadocSourceGenerationDir;
    }

    protected void start() {
        this.log("Starting the aggregated Javadoc generation using a custom Spincast script...");
        this.generateAggregatedJavadoc();
        this.copyJavadocsToWebsite();
    }

    protected void generateAggregatedJavadoc() {
        try {
            File mvnBin;
            this.log("Generating Aggregated Javadoc...");
            FileUtils.deleteDirectory(this.getJavadocSourceGenerationDir());
            String mavenHome = this.getMavenInstallatinRoot().getCanonicalPath();
            String executable = "mvn";
            if (OS.isFamilyWindows()) {
                executable = new File(mavenHome, "/bin/mvn.cmd").exists() ? "mvn.cmd" : "mvn.bat";
            }
            if (!(mvnBin = new File(mavenHome + "/bin/" + executable)).isFile()) {
                this.sendException("Maven executable not found: " + mvnBin.getCanonicalPath());
            }
            File frameworkBaseDir = new File(this.getProjectBaseDir().getAbsolutePath() + "/..");
            CommandLine cmdLine = new CommandLine(mvnBin.getCanonicalPath());
            cmdLine.addArgument("-f");
            cmdLine.addArgument(frameworkBaseDir.getCanonicalPath() + "/pom.xml");
            cmdLine.addArgument("javadoc:aggregate@aggregated-javadoc");
            cmdLine.addArgument("-P");
            cmdLine.addArgument("aggregatedJavadoc");
            this.log("Command launched to generate the aggregated Javadoc: " + cmdLine);
            DefaultExecutor executor = new DefaultExecutor();
            executor.setExitValue(0);
            ExecuteWatchdog watchdog = new ExecuteWatchdog(180000L);
            executor.setWatchdog(watchdog);
            int n = executor.execute(cmdLine);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    protected void copyJavadocsToWebsite() {
        try {
            File javadocSourceDir = this.getJavadocSourceGenerationDir();
            if (!javadocSourceDir.isDirectory()) {
                this.sendException("The Javadoc source directory was not found: " + javadocSourceDir.getCanonicalPath());
            }
            File javadocTargetDir = new File(this.getProjectBuildOutputDir().getCanonicalPath() + "/public/javadoc");
            FileUtils.deleteDirectory(javadocTargetDir);
            FileUtils.copyDirectory(javadocSourceDir, javadocTargetDir);
            this.log("Javadoc copied to the build output dir: " + javadocTargetDir.getAbsolutePath());
            javadocTargetDir = new File(this.getProjectBaseDir().getCanonicalPath() + "/src/main/resources/public/javadoc");
            FileUtils.deleteDirectory(javadocTargetDir);
            FileUtils.copyDirectory(javadocSourceDir, javadocTargetDir);
            this.log("Javadoc copied to the website source dir: " + javadocTargetDir.getAbsolutePath());
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }
}

