/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.website.maven;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.File;
import org.spincast.core.guice.MainArgs;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.utils.SpincastUtils;
import org.spincast.defaults.guice.SpincastDefaultGuiceModule;
import org.spincast.shaded.org.apache.commons.io.FileUtils;
import org.spincast.website.maven.SpincastMavenScriptBase;

public class SpincastMavenPreparePackage
extends SpincastMavenScriptBase {
    private final SpincastUtils spincastUtils;
    private String projectVersion;

    public static void main(String[] args) {
        Injector guice = Guice.createInjector(new SpincastDefaultGuiceModule(args));
        SpincastMavenPreparePackage script = guice.getInstance(SpincastMavenPreparePackage.class);
        script.start();
    }

    @Inject
    public SpincastMavenPreparePackage(@MainArgs String[] mainArgs, SpincastUtils spincastUtils) {
        super(mainArgs);
        this.spincastUtils = spincastUtils;
    }

    protected SpincastUtils getSpincastUtils() {
        return this.spincastUtils;
    }

    protected String getProjectVersion() {
        if (this.projectVersion == null) {
            if (this.getMainArgs().length < 2) {
                this.sendException("The " + SpincastMavenPreparePackage.class.getName() + " class expect the version of the project " + "to be passed as the second parameter: <argument>${project.version}</argument>");
            }
            this.projectVersion = this.getMainArgs()[1].trim();
        }
        return this.projectVersion;
    }

    @Override
    protected void init() {
        super.init();
        this.getProjectVersion();
    }

    protected void start() {
        this.log("Starting 'prepare-package' phase Spincast script.");
        this.addQuickStartToWebsite();
    }

    protected void addQuickStartToWebsite() {
        try {
            this.log("Start adding the Quick Start to the website.");
            this.log("Replacing content in the Quick Start's pom.xml...");
            File targetDir = new File(this.getProjectBuildDir().getAbsolutePath() + "/spincast-quickstart");
            File quickStartProjectRoot = new File(this.getProjectBaseDir().getAbsolutePath() + "/../spincast-quickstart");
            FileUtils.copyDirectory(new File(quickStartProjectRoot.getAbsolutePath() + "/src"), new File(targetDir.getAbsolutePath() + "/src"));
            FileUtils.copyDirectory(new File(quickStartProjectRoot.getAbsolutePath() + "/varia"), new File(targetDir.getAbsolutePath() + "/varia"));
            File pomTarget = new File(targetDir.getAbsolutePath() + "/pom.xml");
            FileUtils.copyFile(new File(quickStartProjectRoot.getAbsolutePath() + "/pom.xml"), pomTarget);
            String pomContent = FileUtils.readFileToString(pomTarget, "UTF-8");
            String projectVersion = this.getProjectVersion();
            pomContent = pomContent.replace("${project.version}", projectVersion);
            String cleanCoords = "<groupId>org.spincast</groupId>\n    <artifactId>spincast-quickstart</artifactId>\n    <version>1.0.0-SNAPSHOT</version>";
            pomContent = pomContent.replaceAll("(?s)<!-- SPINCAST_COORDINATES -->.*<!-- /SPINCAST_COORDINATES -->", cleanCoords);
            String snapshotRepo = "";
            if (projectVersion.endsWith("-SNAPSHOT")) {
                snapshotRepo = "$1";
            }
            pomContent = pomContent.replaceAll("(?s)<!-- SPINCAST_SNAPSHOTS_REPO -->(.*)<!-- /SPINCAST_SNAPSHOTS_REPO -->", snapshotRepo);
            FileUtils.writeStringToFile(pomTarget, pomContent, "UTF-8");
            File targetZipFile = new File(this.getProjectBuildOutputDir().getAbsolutePath() + "/public/quickstart/spincast-quick-start.zip");
            this.getSpincastUtils().zipDirectory(targetDir, targetZipFile, true);
            FileUtils.copyFile(targetZipFile, new File(this.getProjectBaseDir().getAbsolutePath() + "/src/main/resources/public/quickstart/spincast-quick-start.zip"));
            this.log("Quick Start .zip file generated and added to the website.");
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }
}

