/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.website.guice;

import com.google.inject.Key;
import com.google.inject.Scopes;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.exchange.RequestContext;
import org.spincast.defaults.guice.SpincastDefaultGuiceModule;
import org.spincast.plugins.configpropsfile.SpincastConfigPropsFileBasedConfig;
import org.spincast.plugins.configpropsfile.SpincastConfigPropsFilePluginGuiceModule;
import org.spincast.plugins.pebble.SpincastPebbleTemplatingEngineConfig;
import org.spincast.plugins.routing.SpincastRoutingPluginGuiceModule;
import org.spincast.website.App;
import org.spincast.website.AppConfig;
import org.spincast.website.AppConfigDefault;
import org.spincast.website.AppConfigPropsFileBasedConfig;
import org.spincast.website.AppPebbleTemplatingEngineConfig;
import org.spincast.website.HttpAuthInit;
import org.spincast.website.controllers.ErrorController;
import org.spincast.website.controllers.FeedController;
import org.spincast.website.controllers.MainPagesController;
import org.spincast.website.controllers.WebsocketsDemoEchoAllController;
import org.spincast.website.exchange.AppRequestContextDefault;
import org.spincast.website.exchange.AppRouter;
import org.spincast.website.exchange.AppRouterDefault;
import org.spincast.website.pebble.AppPebbleExtension;
import org.spincast.website.repositories.NewsRepository;
import org.spincast.website.repositories.TemplateFilesRepository;
import org.spincast.website.services.NewsService;
import org.spincast.website.services.NewsServiceDefault;

public class AppModule
extends SpincastDefaultGuiceModule {
    public AppModule(String[] mainArgs) {
        super(mainArgs);
    }

    @Override
    protected void configure() {
        super.configure();
        this.bind(App.class).in(Scopes.SINGLETON);
        this.bind(HttpAuthInit.class).asEagerSingleton();
        this.bind(SpincastConfigPropsFileBasedConfig.class).to(AppConfigPropsFileBasedConfig.class).in(Scopes.SINGLETON);
        this.bind(AppPebbleExtension.class).in(Scopes.SINGLETON);
        this.bind(SpincastPebbleTemplatingEngineConfig.class).to(AppPebbleTemplatingEngineConfig.class).in(Scopes.SINGLETON);
        this.bind(AppConfigDefault.class).in(Scopes.SINGLETON);
        this.bind(AppConfig.class).to(AppConfigDefault.class).in(Scopes.SINGLETON);
        this.bind(MainPagesController.class).in(Scopes.SINGLETON);
        this.bind(ErrorController.class).in(Scopes.SINGLETON);
        this.bind(FeedController.class).in(Scopes.SINGLETON);
        this.bind(WebsocketsDemoEchoAllController.class).asEagerSingleton();
        this.bind(NewsService.class).to(NewsServiceDefault.class).in(Scopes.SINGLETON);
        this.bind(NewsRepository.class).to(TemplateFilesRepository.class).in(Scopes.SINGLETON);
        this.bind(AppRouterDefault.class).in(Scopes.SINGLETON);
        this.bind(AppRouter.class).to(AppRouterDefault.class).in(Scopes.SINGLETON);
    }

    @Override
    protected void bindConfigPlugin() {
        this.install(new SpincastConfigPropsFilePluginGuiceModule(this.getRequestContextType(), this.getWebsocketContextType()){

            @Override
            protected Class<? extends SpincastConfig> getSpincastConfigImplClass() {
                return AppConfigDefault.class;
            }
        });
    }

    @Override
    protected Class<? extends RequestContext<?>> getRequestContextImplementationClass() {
        return AppRequestContextDefault.class;
    }

    @Override
    protected void bindRoutingPlugin() {
        this.install(new SpincastRoutingPluginGuiceModule(this.getRequestContextType(), this.getWebsocketContextType()){

            @Override
            protected Key<?> getRouterImplementationKey() {
                return Key.get(AppRouterDefault.class);
            }
        });
    }
}

