/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.website;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.filters.SpincastFilters;
import org.spincast.core.server.Server;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.website.AppConfig;
import org.spincast.website.controllers.AdminController;
import org.spincast.website.controllers.ErrorController;
import org.spincast.website.controllers.FeedController;
import org.spincast.website.controllers.MainPagesController;
import org.spincast.website.controllers.WebsocketsDemoEchoAllController;
import org.spincast.website.controllers.demos.DemoFormAuthController;
import org.spincast.website.controllers.demos.DemoHtmlFormsDynamicFieldsController;
import org.spincast.website.controllers.demos.DemoHtmlFormsFileUploadController;
import org.spincast.website.controllers.demos.DemoHtmlFormsMultipleFieldsController;
import org.spincast.website.controllers.demos.DemoHtmlFormsSingleFieldController;
import org.spincast.website.controllers.demos.DemosTutorialsController;
import org.spincast.website.exchange.AppRequestContext;
import org.spincast.website.exchange.AppRouter;
import org.spincast.website.guice.AppModule;

public class App {
    protected final Logger logger = LoggerFactory.getLogger(App.class);
    private final Server server;
    private final AppConfig appConfig;
    private final AppRouter router;
    private final MainPagesController appController;
    private final ErrorController errorController;
    private final FeedController feedController;
    private final AdminController adminController;
    private final DemosTutorialsController demosTutorialsControllerController;
    private final DemoFormAuthController demoFormAuthController;
    private final DemoHtmlFormsSingleFieldController demoHtmlFormsSingleFieldController;
    private final DemoHtmlFormsMultipleFieldsController demoHtmlFormsMultipleFieldsController;
    private final DemoHtmlFormsDynamicFieldsController demoHtmlFormsDynamicFieldsController;
    private final DemoHtmlFormsFileUploadController demoHtmlFormsFileUploadController;
    private final SpincastFilters<AppRequestContext> spincastFilters;
    private final WebsocketsDemoEchoAllController websocketsDemoEchoAllController;

    public static void main(String[] args) {
        App.createApp(args, null);
    }

    public static Injector createApp(String[] args, Module overridingModule) {
        if (args == null) {
            args = new String[]{};
        }
        Injector guice = null;
        guice = overridingModule != null ? Guice.createInjector(Modules.override(App.getAppModules(args)).with(overridingModule)) : Guice.createInjector(App.getAppModules(args));
        App website = guice.getInstance(App.class);
        website.start();
        return guice;
    }

    protected static List<? extends Module> getAppModules(String[] args) {
        return Lists.newArrayList(new AppModule(args));
    }

    @Inject
    public App(Server server, AppConfig config, AppRouter router, MainPagesController appController, ErrorController errorController, FeedController feedController, AdminController adminController, DemosTutorialsController demosTutorialsControllerController, DemoFormAuthController demoFormAuthController, DemoHtmlFormsSingleFieldController demoHtmlFormsSingleFieldController, DemoHtmlFormsMultipleFieldsController demoHtmlFormsMultipleFieldsController, DemoHtmlFormsDynamicFieldsController demoHtmlFormsDynamicFieldsController, SpincastFilters<AppRequestContext> spincastFilters, WebsocketsDemoEchoAllController websocketsDemoEchoAllController, DemoHtmlFormsFileUploadController demoHtmlFormsFileUploadController) {
        this.server = server;
        this.appConfig = config;
        this.router = router;
        this.appController = appController;
        this.errorController = errorController;
        this.feedController = feedController;
        this.adminController = adminController;
        this.demosTutorialsControllerController = demosTutorialsControllerController;
        this.demoFormAuthController = demoFormAuthController;
        this.demoHtmlFormsSingleFieldController = demoHtmlFormsSingleFieldController;
        this.demoHtmlFormsMultipleFieldsController = demoHtmlFormsMultipleFieldsController;
        this.demoHtmlFormsDynamicFieldsController = demoHtmlFormsDynamicFieldsController;
        this.spincastFilters = spincastFilters;
        this.websocketsDemoEchoAllController = websocketsDemoEchoAllController;
        this.demoHtmlFormsFileUploadController = demoHtmlFormsFileUploadController;
    }

    protected Server getServer() {
        return this.server;
    }

    protected AppConfig getConfig() {
        return this.appConfig;
    }

    protected AppRouter getRouter() {
        return this.router;
    }

    protected MainPagesController getAppController() {
        return this.appController;
    }

    protected ErrorController getErrorController() {
        return this.errorController;
    }

    protected FeedController getFeedController() {
        return this.feedController;
    }

    protected AdminController getAdminController() {
        return this.adminController;
    }

    protected DemosTutorialsController getDemosTutorialsController() {
        return this.demosTutorialsControllerController;
    }

    protected DemoFormAuthController getDemoFormAuthController() {
        return this.demoFormAuthController;
    }

    protected DemoHtmlFormsSingleFieldController getDemoHtmlFormsSingleFieldController() {
        return this.demoHtmlFormsSingleFieldController;
    }

    protected DemoHtmlFormsMultipleFieldsController getDemoHtmlFormsMultipleFieldsController() {
        return this.demoHtmlFormsMultipleFieldsController;
    }

    protected DemoHtmlFormsDynamicFieldsController getDemoHtmlFormsDynamicFieldsController() {
        return this.demoHtmlFormsDynamicFieldsController;
    }

    protected SpincastFilters<AppRequestContext> getSpincastFilters() {
        return this.spincastFilters;
    }

    protected WebsocketsDemoEchoAllController getWebsocketsDemoEchoAllController() {
        return this.websocketsDemoEchoAllController;
    }

    protected DemoHtmlFormsFileUploadController getDemoHtmlFormsFileUploadController() {
        return this.demoHtmlFormsFileUploadController;
    }

    public void start() {
        this.configureLogback();
        this.addRoutes();
        this.getServer().start();
        this.displayStartedMessage();
    }

    protected void configureLogback() {
        try {
            InputStream logbackFileIn;
            String logbackFilePath = "conf/logback.prod.xml";
            if (this.getConfig().isDebugEnabled()) {
                logbackFilePath = "conf/logback.debug.xml";
            }
            if ((logbackFileIn = this.getClass().getClassLoader().getResourceAsStream(logbackFilePath)) == null) {
                throw new RuntimeException("Logback file not found on the classpath : " + logbackFilePath);
            }
            LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext(context);
            context.reset();
            configurator.doConfigure(logbackFileIn);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    protected void displayStartedMessage() {
        System.out.println();
        System.out.println("====================================================");
        if (this.getConfig().getHttpServerPort() > 0) {
            System.out.println("Spincast HTTP website started on port " + this.getConfig().getHttpServerPort());
        }
        if (this.getConfig().getHttpsServerPort() > 0) {
            System.out.println("Spincast HTTPS website started on port " + this.getConfig().getHttpsServerPort());
        }
        System.out.println("Environment : " + this.getConfig().getEnvironmentName());
        System.out.println("Debug enabled? " + this.getConfig().isDebugEnabled());
        System.out.println("====================================================");
        System.out.println();
    }

    protected void addRoutes() {
        AppRouter router = this.getRouter();
        MainPagesController appCtl = this.getAppController();
        DemosTutorialsController demoCtl = this.getDemosTutorialsController();
        router.dir("/public").classpath("/public").save();
        router.file("/favicon.ico").classpath("/public/favicon.ico").save();
        router.file("/robots.txt").classpath("/public/robots.txt").save();
        router.file("/humans.txt").classpath("/public/humans.txt").save();
        router.file("/browserconfig.xml").classpath("/public/browserconfig.xml").save();
        router.file("/apple-touch-icon.png").classpath("/public/apple-touch-icon.png").save();
        router.file("/tile-wide.png").classpath("/public/tile-wide.png").save();
        router.file("/tile.png").classpath("/public/tile.png").save();
        router.before().save(this.getSpincastFilters()::addSecurityHeaders);
        router.notFound(this.getErrorController()::notFoundHandler);
        router.exception(this.getErrorController()::exceptionHandler);
        router.file("/rss").pathRelative("/feed/rss.xml").save(this.getFeedController()::rss);
        router.httpAuth("/admin", "admin");
        router.GET("/admin").noCache().save(this.getAdminController()::index);
        router.GET("/admin/news").save(this.getAdminController()::news);
        router.file("/").pathRelative("/pages/index.html").save(appCtl::index);
        router.file("/presentation").pathRelative("/pages/presentation.html").save(appCtl::presentation);
        router.GET("/news").save(appCtl::news);
        router.file("/news/${newsId:<N>}").pathRelative("/pages/news/${newsId:<N>}.html").save(appCtl::newsEntry);
        router.file("/documentation").pathRelative("/pages/documentation.html").save(appCtl::documentation);
        router.file("/download").pathRelative("/pages/download.html").save(appCtl::download);
        router.file("/plugins").pathRelative("/pages/plugins.html").save(appCtl::plugins);
        router.file("/plugins/${pluginName}").pathRelative("/pages/plugins/${pluginName}.html").save(appCtl::plugin);
        router.file("/community").pathRelative("/pages/community.html").save(appCtl::community);
        router.file("/about").pathRelative("/pages/about.html").save(appCtl::about);
        router.file("/more").pathRelative("/pages/more.html").save(appCtl::about);
        router.redirect("/demos-tutorials").temporarily().to("/demos-tutorials/hello-world");
        router.file("/demos-tutorials/hello-world").pathRelative("/pages/demos-tutorials/hello-world.html").save(demoCtl::helloWorld);
        router.file("/demos-tutorials/full-website").pathRelative("/pages/demos-tutorials/full-website.html").save(demoCtl::fullWebsite);
        router.file("/demos-tutorials/todo-list").pathRelative("/pages/demos-tutorials/todo-list.html").save(demoCtl::todoList);
        router.file("/demos-tutorials/http-authentication").pathRelative("/pages/demos-tutorials/http-authentication.html").save(demoCtl::httpAuthentication);
        router.httpAuth("/demos-tutorials/http-authentication/protected", "protected example");
        router.redirect("/protected_example").to("/demos-tutorials/http-authentication/protected");
        router.file("/demos-tutorials/http-authentication/protected").pathRelative("/pages/demos-tutorials/http-authentication/protected.html").save(demoCtl::httpAuthenticationProtectedPage);
        router.file("/demos-tutorials/websockets").pathRelative("/pages/demos-tutorials/websockets.html").save(demoCtl::webSockets);
        router.websocket("/demos-tutorials/websockets/echo-all-endpoint").save(this.getWebsocketsDemoEchoAllController());
        router.redirect("/showcase/websockets/echo-all").to("/demos-tutorials/websockets");
        router.redirect("/showcase/websockets/echo-all-endpoint").to("/demos-tutorials/websockets/echo-all-endpoint");
        router.redirect("/demos-tutorials/html-forms").to("/demos-tutorials/html-forms/single-field");
        router.GET("/demos-tutorials/html-forms/single-field").save(this.getDemoHtmlFormsSingleFieldController()::singleField);
        router.POST("/demos-tutorials/html-forms/single-field").save(this.getDemoHtmlFormsSingleFieldController()::singleFieldSubmit);
        router.GET("/demos-tutorials/html-forms/multiple-fields").save(this.getDemoHtmlFormsMultipleFieldsController()::multipleFields);
        router.POST("/demos-tutorials/html-forms/multiple-fields").save(this.getDemoHtmlFormsMultipleFieldsController()::multipleFieldsSubmit);
        router.GET("/demos-tutorials/html-forms/dynamic-fields").save(this.getDemoHtmlFormsDynamicFieldsController()::dynamicFields);
        router.POST("/demos-tutorials/html-forms/dynamic-fields").save(this.getDemoHtmlFormsDynamicFieldsController()::dynamicFieldsSubmit);
        router.GET("/demos-tutorials/html-forms/file-upload").save(this.getDemoHtmlFormsFileUploadController()::fileUpload);
        router.POST("/demos-tutorials/html-forms/file-upload").save(this.getDemoHtmlFormsFileUploadController()::fileUploadSubmit);
    }
}

