/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.filters;

import com.google.common.collect.Sets;
import java.io.File;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.cookies.ICookie;
import org.spincast.core.exceptions.SkipRemainingHandlersException;
import org.spincast.core.exchange.IRequestContext;
import org.spincast.core.filters.ISpincastFilters;
import org.spincast.core.routing.HttpMethod;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.shaded.org.apache.commons.io.FileUtils;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class SpincastFilters<R extends IRequestContext<?>>
implements ISpincastFilters<R> {
    protected final Logger logger = LoggerFactory.getLogger(SpincastFilters.class);

    @Override
    public void saveGeneratedResource(R context, String pathForGeneratedResource) {
        try {
            File resourceFile = new File(pathForGeneratedResource);
            if (resourceFile.exists()) {
                this.logger.info("The resource already exists. We don't save it here.");
                return;
            }
            if (200 != context.response().getStatusCode()) {
                this.logger.info("Nothing will be saved since the response code is not 200");
                return;
            }
            if (context.response().isHeadersSent()) {
                this.logger.warn("Headers sent, we can't save a copy of the generated resource! You will have to make sure that you save the generated resource by yourself, otherwise, a new version will be generated for each request!");
                return;
            }
            byte[] unsentBytes = context.response().getUnsentBytes();
            FileUtils.writeByteArrayToFile(resourceFile, unsentBytes);
        }
        catch (Exception ex) {
            this.logger.error("Unable to save the generated resource '" + pathForGeneratedResource + "' :\n" + SpincastStatics.getStackTrace(ex));
        }
    }

    @Override
    public void addSecurityHeaders(R context) {
        context.response().addHeaderValue("X-Frame-Options", "SAMEORIGIN");
        context.response().addHeaderValue("x-content-type-options", "nosniff");
    }

    @Override
    public void cors(R context) {
        this.cors(context, Sets.newHashSet("*"), null, Sets.newHashSet("*"), true, Sets.newHashSet(HttpMethod.values()), this.getCorsDefaultMaxAgeInSeconds());
    }

    @Override
    public void cors(R context, Set<String> allowedOrigins) {
        this.cors(context, allowedOrigins, null, Sets.newHashSet("*"), true, Sets.newHashSet(HttpMethod.values()), this.getCorsDefaultMaxAgeInSeconds());
    }

    @Override
    public void cors(R context, Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead) {
        this.cors(context, allowedOrigins, extraHeadersAllowedToBeRead, Sets.newHashSet("*"), true, Sets.newHashSet(HttpMethod.values()), this.getCorsDefaultMaxAgeInSeconds());
    }

    @Override
    public void cors(R context, Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead, Set<String> extraHeadersAllowedToBeSent) {
        this.cors(context, allowedOrigins, extraHeadersAllowedToBeRead, extraHeadersAllowedToBeSent, true, Sets.newHashSet(HttpMethod.values()), this.getCorsDefaultMaxAgeInSeconds());
    }

    @Override
    public void cors(R context, Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead, Set<String> extraHeadersAllowedToBeSent, boolean allowCookies) {
        this.cors(context, allowedOrigins, extraHeadersAllowedToBeRead, extraHeadersAllowedToBeSent, allowCookies, Sets.newHashSet(HttpMethod.values()), this.getCorsDefaultMaxAgeInSeconds());
    }

    @Override
    public void cors(R context, Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead, Set<String> extraHeadersAllowedToBeSent, boolean allowCookies, Set<HttpMethod> allowedMethods) {
        this.cors(context, allowedOrigins, extraHeadersAllowedToBeRead, extraHeadersAllowedToBeSent, allowCookies, allowedMethods, this.getCorsDefaultMaxAgeInSeconds());
    }

    @Override
    public void cors(R context, Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead, Set<String> extraHeadersAllowedToBeSent, boolean allowCookies, Set<HttpMethod> allowedMethods, int maxAgeInSeconds) {
        boolean bl;
        boolean bl2;
        String origin = context.request().getHeaderFirst("Origin");
        if (origin == null) {
            return;
        }
        String host = context.request().getHeaderFirst("Host");
        if (host != null) {
            try {
                String originHost = new URI(origin).getHost();
                if (host.equals(originHost)) {
                    return;
                }
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize(ex);
            }
        }
        if (context.response().isHeadersSent()) {
            String message = "Headers already sent: if this is a cors request, it will fail. The request URL is: " + context.request().getFullUrl();
            if (context.request().getHeaderFirst("Access-Control-Request-Method") != null) {
                this.logger.error(message);
            } else {
                this.logger.info(message);
            }
            return;
        }
        HashSet<String> allowedOriginsLowercased = new HashSet<String>();
        if (allowedOrigins == null) {
            allowedOrigins = new HashSet<String>();
        }
        for (String string : allowedOrigins) {
            if (string == null) continue;
            allowedOriginsLowercased.add(string.toLowerCase().trim());
        }
        HashSet<String> extraHeadersAllowedToBeReadLowercased = new HashSet<String>();
        if (extraHeadersAllowedToBeRead == null) {
            extraHeadersAllowedToBeRead = new HashSet<String>();
        }
        for (String string : extraHeadersAllowedToBeRead) {
            if (string == null) continue;
            extraHeadersAllowedToBeReadLowercased.add(string.toLowerCase().trim());
        }
        HashSet<String> hashSet = new HashSet<String>();
        if (extraHeadersAllowedToBeSent == null) {
            extraHeadersAllowedToBeSent = new HashSet<String>();
        }
        for (String extraHeaderAllowedToBeSent : extraHeadersAllowedToBeSent) {
            if (extraHeaderAllowedToBeSent == null) continue;
            hashSet.add(extraHeaderAllowedToBeSent.toLowerCase().trim());
        }
        if (allowedMethods == null) {
            allowedMethods = new HashSet<HttpMethod>();
        }
        allowedMethods.add(HttpMethod.OPTIONS);
        if (!this.isCorsOriginValid(context, allowedOriginsLowercased)) {
            this.logger.info("Invalid origin for a cors request : " + origin);
            context.response().resetEverything();
            context.response().setStatusCode(200);
            throw new SkipRemainingHandlersException();
        }
        if (!this.isPreflightRequest(context)) {
            this.corsCore(context, allowedOrigins, allowCookies);
            this.corsAddExtraHeadersAllowedToBeRead(context, extraHeadersAllowedToBeRead);
            return;
        }
        context.response().resetEverything();
        context.response().setStatusCode(200);
        boolean bl3 = true;
        if (!this.isCorsRequestMethodHeaderValid(context, allowedMethods)) {
            this.logger.info("Invalid 'Access-Control-Allow-Methods' cors header received : " + context.request().getHeaderFirst("Access-Control-Request-Method"));
            bl2 = false;
        }
        if (bl2 && !this.isCorsRequestedHeadersToBeSentValid(context, hashSet)) {
            this.logger.info("Invalid 'Access-Control-Request-Headers' cors header received : " + context.request().getHeaderFirst("Access-Control-Request-Headers"));
            bl = false;
        }
        if (bl) {
            this.corsCore(context, allowedOrigins, allowCookies);
            this.corsAddAllowMethods(context, allowedMethods);
            this.corsAddExtraHeadersAllowedToBeSent(context, extraHeadersAllowedToBeSent);
            this.corsAddMaxAge(context, maxAgeInSeconds);
        }
        throw new SkipRemainingHandlersException();
    }

    protected int getCorsDefaultMaxAgeInSeconds() {
        return 86400;
    }

    protected boolean isCorsOriginValid(R context, Set<String> allowedOriginsLowercased) {
        if (allowedOriginsLowercased.contains("*")) {
            return true;
        }
        String origin = context.request().getHeaderFirst("Origin").toLowerCase();
        return allowedOriginsLowercased.contains(origin);
    }

    protected void corsCore(R context, Set<String> allowedOrigins, boolean allowCookies) {
        this.corsAddAlloweOrigin(context, allowedOrigins);
        if (allowCookies) {
            this.corsAddAllowCookies(context);
        }
    }

    protected boolean isCorsRequestMethodHeaderValid(R context, Set<HttpMethod> allowedMethods) {
        if (allowedMethods == null || allowedMethods.size() == 0) {
            return false;
        }
        String accessControlRequestMethodsStr = context.request().getHeaderFirst("Access-Control-Request-Method");
        if (accessControlRequestMethodsStr == null) {
            return false;
        }
        String[] accessControlRequestMethods = StringUtils.split(accessControlRequestMethodsStr, ",");
        if (accessControlRequestMethods == null || accessControlRequestMethods.length == 0) {
            return false;
        }
        for (String accessControlRequestMethod : accessControlRequestMethods) {
            HttpMethod method = HttpMethod.fromStringValue(accessControlRequestMethod);
            if (method == null) {
                return false;
            }
            if (allowedMethods.contains((Object)method)) continue;
            return false;
        }
        return true;
    }

    protected boolean isCorsRequestedHeadersToBeSentValid(R context, Set<String> extraHeadersAllowedToBeSentLowercased) {
        String requestedHeadersStr = context.request().getHeaderFirst("Access-Control-Request-Headers");
        if (requestedHeadersStr == null) {
            return true;
        }
        String[] requestedHeaders = StringUtils.split(requestedHeadersStr, ",");
        if (requestedHeaders == null || requestedHeaders.length == 0) {
            return true;
        }
        if (extraHeadersAllowedToBeSentLowercased.contains("*")) {
            return true;
        }
        if (extraHeadersAllowedToBeSentLowercased == null || extraHeadersAllowedToBeSentLowercased.size() == 0) {
            return false;
        }
        for (String requestedHeader : requestedHeaders) {
            if (extraHeadersAllowedToBeSentLowercased.contains(requestedHeader.toLowerCase().trim())) continue;
            return false;
        }
        return true;
    }

    protected boolean isPreflightRequest(R context) {
        String accessControlRequestMethod;
        HttpMethod httpMethod = context.request().getHttpMethod();
        return httpMethod == HttpMethod.OPTIONS && (accessControlRequestMethod = context.request().getHeaderFirst("Access-Control-Request-Method")) != null;
    }

    protected void corsAddExtraHeadersAllowedToBeRead(R context, Set<String> extraHeadersAllowedToBeRead) {
        String extraHeadersAllowedToBeReadStr = "";
        if (extraHeadersAllowedToBeRead != null && extraHeadersAllowedToBeRead.size() > 0) {
            extraHeadersAllowedToBeReadStr = StringUtils.join(extraHeadersAllowedToBeRead, ",");
        }
        context.response().addHeaderValue("Access-Control-Expose-Headers", extraHeadersAllowedToBeReadStr);
    }

    protected void corsAddExtraHeadersAllowedToBeSent(R context, Set<String> extraHeadersAllowedToBeSent) {
        String extraHeadersAllowedToBeSentStr = "";
        if (extraHeadersAllowedToBeSent != null && extraHeadersAllowedToBeSent.size() > 0) {
            if (extraHeadersAllowedToBeSent.contains("*")) {
                String requestedHeadersStr = context.request().getHeaderFirst("Access-Control-Request-Headers");
                if (!StringUtils.isBlank(requestedHeadersStr)) {
                    extraHeadersAllowedToBeSentStr = requestedHeadersStr;
                }
            } else {
                extraHeadersAllowedToBeSentStr = StringUtils.join(extraHeadersAllowedToBeSent, ",");
            }
        } else {
            Set<String> defaultExtraHeadersAllowedToBeSent = this.getDefaultHeadersAllowedToBeSent();
            if (defaultExtraHeadersAllowedToBeSent != null && defaultExtraHeadersAllowedToBeSent.size() > 0) {
                extraHeadersAllowedToBeSentStr = StringUtils.join(defaultExtraHeadersAllowedToBeSent, ",");
            }
        }
        context.response().addHeaderValue("Access-Control-Allow-Headers", extraHeadersAllowedToBeSentStr);
    }

    protected Set<String> getDefaultHeadersAllowedToBeSent() {
        return null;
    }

    protected void corsAddMaxAge(R context, int maxAgeInSeconds) {
        if (maxAgeInSeconds > 0) {
            context.response().addHeaderValue("Access-Control-Max-Age", String.valueOf(maxAgeInSeconds));
        }
    }

    protected void corsAddAllowMethods(R context, Set<HttpMethod> allowedMethods) {
        if (allowedMethods == null || allowedMethods.size() == 0) {
            return;
        }
        String allowedMethodsStr = StringUtils.join(allowedMethods, ",");
        context.response().addHeaderValue("Access-Control-Allow-Methods", allowedMethodsStr);
    }

    protected void corsAddAllowCookies(R context) {
        context.response().addHeaderValue("Access-Control-Allow-Credentials", "true");
    }

    protected void corsAddAlloweOrigin(R context, Set<String> allowedOrigins) {
        String allowedOriginsStr;
        boolean hasCookies;
        if (allowedOrigins == null || allowedOrigins.size() == 0) {
            return;
        }
        Map<String, ICookie> cookies = context.cookies().getCookies();
        boolean bl = hasCookies = cookies != null && cookies.size() > 0;
        if (!hasCookies && allowedOrigins.contains("*")) {
            allowedOriginsStr = "*";
        } else {
            allowedOriginsStr = context.request().getHeaderFirst("Origin");
            context.response().addHeaderValue("Vary", "Origin");
        }
        context.response().addHeaderValue("Access-Control-Allow-Origin", allowedOriginsStr);
    }
}

