/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.extension.escaper;

import com.mitchellbosecke.pebble.extension.AbstractExtension;
import com.mitchellbosecke.pebble.extension.Filter;
import com.mitchellbosecke.pebble.extension.NodeVisitorFactory;
import com.mitchellbosecke.pebble.extension.escaper.EscapeFilter;
import com.mitchellbosecke.pebble.extension.escaper.EscaperNodeVisitorFactory;
import com.mitchellbosecke.pebble.extension.escaper.EscapingStrategy;
import com.mitchellbosecke.pebble.extension.escaper.RawFilter;
import com.mitchellbosecke.pebble.tokenParser.AutoEscapeTokenParser;
import com.mitchellbosecke.pebble.tokenParser.TokenParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EscaperExtension
extends AbstractExtension {
    private final EscapeFilter filter = new EscapeFilter();
    private final EscaperNodeVisitorFactory visitorFactory = new EscaperNodeVisitorFactory();

    @Override
    public Map<String, Filter> getFilters() {
        HashMap<String, Filter> filters = new HashMap<String, Filter>();
        filters.put("escape", this.filter);
        filters.put("raw", new RawFilter());
        return filters;
    }

    @Override
    public List<TokenParser> getTokenParsers() {
        ArrayList<TokenParser> parsers = new ArrayList<TokenParser>();
        parsers.add(new AutoEscapeTokenParser());
        return parsers;
    }

    @Override
    public List<NodeVisitorFactory> getNodeVisitors() {
        ArrayList<NodeVisitorFactory> visitors = new ArrayList<NodeVisitorFactory>();
        visitors.add(this.visitorFactory);
        return visitors;
    }

    public void setDefaultStrategy(String strategy) {
        this.filter.setDefaultStrategy(strategy);
    }

    public void setAutoEscaping(boolean auto) {
        this.visitorFactory.setAutoEscaping(auto);
    }

    public void addSafeFilter(String filter) {
        this.visitorFactory.addSafeFilter(filter);
    }

    public void addEscapingStrategy(String name, EscapingStrategy strategy) {
        this.filter.addEscapingStrategy(name, strategy);
    }
}

