/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.website;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.File;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.filters.ISpincastFilters;
import org.spincast.core.routing.IRouter;
import org.spincast.core.server.IServer;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.shaded.org.apache.commons.io.FileUtils;
import org.spincast.website.IAppConfig;
import org.spincast.website.controllers.AppController;
import org.spincast.website.controllers.ErrorController;
import org.spincast.website.controllers.FeedController;
import org.spincast.website.exchange.IAppRequestContext;
import org.spincast.website.guice.AppModule;

public class App {
    protected final Logger logger = LoggerFactory.getLogger(App.class);
    private final IServer server;
    private final IAppConfig appConfig;
    private final IRouter<IAppRequestContext> router;
    private final AppController appController;
    private final ErrorController errorController;
    private final FeedController feedController;
    private final ISpincastFilters<IAppRequestContext> spincastFilters;

    public static void main(String[] args) {
        App.createApp(args);
    }

    public static Injector createApp() {
        return App.createApp(null);
    }

    public static Injector createApp(String[] args) {
        if (args == null) {
            args = new String[]{};
        }
        Injector guice = Guice.createInjector(new AppModule(args));
        App website = guice.getInstance(App.class);
        website.start();
        return guice;
    }

    @Inject
    public App(IServer server, IAppConfig config, IRouter<IAppRequestContext> router, AppController appController, ErrorController errorController, FeedController feedController, ISpincastFilters<IAppRequestContext> spincastFilters) {
        this.server = server;
        this.appConfig = config;
        this.router = router;
        this.appController = appController;
        this.errorController = errorController;
        this.feedController = feedController;
        this.spincastFilters = spincastFilters;
    }

    protected IServer getServer() {
        return this.server;
    }

    protected IAppConfig getConfig() {
        return this.appConfig;
    }

    protected IRouter<IAppRequestContext> getRouter() {
        return this.router;
    }

    protected AppController getAppController() {
        return this.appController;
    }

    protected ErrorController getErrorController() {
        return this.errorController;
    }

    protected FeedController getFeedController() {
        return this.feedController;
    }

    protected ISpincastFilters<IAppRequestContext> getSpincastFilters() {
        return this.spincastFilters;
    }

    public void start() {
        this.configureLogback();
        this.addRoutes();
        this.getServer().start();
        this.displayStartedMessage();
    }

    protected void configureLogback() {
        try {
            InputStream logbackFileIn;
            String logbackFilePath = "conf/logback.prod.xml";
            if (this.getConfig().isDebugEnabled()) {
                logbackFilePath = "conf/logback.debug.xml";
            }
            if ((logbackFileIn = this.getClass().getClassLoader().getResourceAsStream(logbackFilePath)) == null) {
                throw new RuntimeException("Logback file not found on the classpath : " + logbackFilePath);
            }
            LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext(context);
            context.reset();
            configurator.doConfigure(logbackFileIn);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    protected void displayStartedMessage() {
        System.out.println();
        System.out.println("====================================================");
        if (this.getConfig().getHttpServerPort() > 0) {
            System.out.println("Spincast HTTP website started on port " + this.getConfig().getHttpServerPort());
        }
        if (this.getConfig().getHttpsServerPort() > 0) {
            System.out.println("Spincast HTTPS website started on port " + this.getConfig().getHttpsServerPort());
        }
        System.out.println("Environment : " + this.getConfig().getEnvironmentName());
        System.out.println("Debug enabled? " + this.getConfig().isDebugEnabled());
        System.out.println("====================================================");
        System.out.println();
    }

    protected File getEmptyFeedDir() {
        try {
            File feedDir = new File(this.getConfig().getSpincastWritableDir().getAbsolutePath() + "/feeds");
            FileUtils.deleteDirectory(feedDir);
            boolean result = feedDir.mkdirs();
            if (!result) {
                throw new RuntimeException("Unable to create the feed directory: " + feedDir.getAbsolutePath());
            }
            return feedDir;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    protected void addRoutes() {
        IRouter<IAppRequestContext> router = this.getRouter();
        AppController appCtl = this.getAppController();
        router.dir("/public").classpath("/public").save();
        router.file("/favicon.ico").classpath("/public/favicon.ico").save();
        router.file("/robots.txt").classpath("/public/robots.txt").save();
        router.file("/humans.txt").classpath("/public/humans.txt").save();
        router.file("/browserconfig.xml").classpath("/public/browserconfig.xml").save();
        router.file("/apple-touch-icon.png").classpath("/public/apple-touch-icon.png").save();
        router.file("/tile-wide.png").classpath("/public/tile-wide.png").save();
        router.file("/tile.png").classpath("/public/tile.png").save();
        router.before(this.getSpincastFilters()::addSecurityHeaders);
        router.before(appCtl::addGlobalTemplatingVariables);
        router.notFound(this.getErrorController()::notFoundHandler);
        router.exception(this.getErrorController()::exceptionHandler);
        File feedDir = this.getEmptyFeedDir();
        router.file("/rss").fileSystem(feedDir + "/rss.xml").save(this.getFeedController()::rss);
        router.GET("/").save(appCtl::index);
        router.GET("/news").save(appCtl::news);
        router.GET("/documentation").save(appCtl::documentation);
        router.GET("/download").save(appCtl::download);
        router.GET("/plugins").save(appCtl::plugins);
        router.GET("/community").save(appCtl::community);
        router.GET("/about").save(appCtl::about);
        router.GET("/plugins/${pluginName}").save(appCtl::plugin);
    }
}

