/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.utils;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public final class PathUtils {
    private static final String UNIX_SEPARATOR = "/";
    private static final String WINDOWS_SEPARATOR = "\\";

    public static String resolveRelativePath(String relativePath, String anchorPath) {
        if (relativePath == null || relativePath.isEmpty()) {
            return null;
        }
        if (relativePath.startsWith("../") || relativePath.startsWith("./")) {
            return PathUtils.resolvePathInner(relativePath, anchorPath, UNIX_SEPARATOR);
        }
        if (relativePath.startsWith("..\\") || relativePath.startsWith(".\\")) {
            return PathUtils.resolvePathInner(relativePath, anchorPath, WINDOWS_SEPARATOR);
        }
        return null;
    }

    private static String resolvePathInner(String relativePath, String anchorPath, String separator) {
        StringBuilder resultingPath = new StringBuilder();
        for (String segment : PathUtils.resolvePathSegments(PathUtils.determineAnchorPathSegments(anchorPath, separator), PathUtils.splitBySeparator(relativePath, separator))) {
            resultingPath.append(segment).append(separator);
        }
        return resultingPath.substring(0, resultingPath.length() - separator.length());
    }

    private static Collection<String> determineAnchorPathSegments(String anchorPath, String separator) {
        if (anchorPath == null || anchorPath.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayDeque<String> anchorPathSegments = new ArrayDeque<String>(PathUtils.splitBySeparator(anchorPath, separator));
        if (!anchorPath.endsWith(separator)) {
            anchorPathSegments.pollLast();
        }
        return anchorPathSegments;
    }

    private static Collection<String> resolvePathSegments(Collection<String> anchorSegments, Collection<String> relativeSegements) {
        ArrayDeque<String> result = new ArrayDeque<String>(anchorSegments);
        for (String segment : relativeSegements) {
            if (segment.equals(".")) continue;
            if (segment.equals("..")) {
                result.pollLast();
                continue;
            }
            result.add(segment);
        }
        return result;
    }

    private static List<String> splitBySeparator(String path, String separator) {
        return Arrays.asList(path.split(separator.replace(WINDOWS_SEPARATOR, "\\\\")));
    }

    private PathUtils() {
        throw new IllegalAccessError();
    }
}

