/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.routing;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import javax.annotation.Nullable;
import org.spincast.core.exchange.IRequestContext;
import org.spincast.core.routing.IHandler;
import org.spincast.core.routing.IStaticResource;
import org.spincast.core.routing.IStaticResourceCorsConfig;
import org.spincast.core.routing.StaticResourceType;

public class StaticResource<R extends IRequestContext<?>>
implements IStaticResource<R> {
    private final StaticResourceType staticResourceType;
    private final String urlPath;
    private final String resourcePath;
    private final IHandler<R> generator;
    private final IStaticResourceCorsConfig corsConfig;

    @AssistedInject
    public StaticResource(@Assisted StaticResourceType staticResourceType, @Assisted(value="url") String urlPath, @Assisted(value="path") String resourcePath, @Assisted @Nullable IHandler<R> generator, @Assisted @Nullable IStaticResourceCorsConfig corsConfig) {
        this.staticResourceType = staticResourceType;
        this.urlPath = urlPath;
        this.resourcePath = resourcePath;
        this.generator = generator;
        this.corsConfig = corsConfig;
    }

    @Override
    public StaticResourceType getStaticResourceType() {
        return this.staticResourceType;
    }

    @Override
    public String getUrlPath() {
        return this.urlPath;
    }

    @Override
    public String getResourcePath() {
        return this.resourcePath;
    }

    @Override
    public boolean isCanBeGenerated() {
        return this.getGenerator() != null;
    }

    @Override
    public IHandler<R> getGenerator() {
        return this.generator;
    }

    @Override
    public IStaticResourceCorsConfig getCorsConfig() {
        return this.corsConfig;
    }

    @Override
    public boolean isFileResource() {
        return this.getStaticResourceType() == StaticResourceType.FILE || this.getStaticResourceType() == StaticResourceType.FILE_FROM_CLASSPATH;
    }

    @Override
    public boolean isDirResource() {
        return !this.isFileResource();
    }

    @Override
    public boolean isClasspath() {
        return this.getStaticResourceType() == StaticResourceType.FILE_FROM_CLASSPATH || this.getStaticResourceType() == StaticResourceType.DIRECTORY_FROM_CLASSPATH;
    }

    @Override
    public boolean isFileSytem() {
        return !this.isClasspath();
    }
}

