/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.builder;

import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateParser;
import io.undertow.predicate.Predicates;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.handlers.builder.HandlerParser;
import io.undertow.server.handlers.builder.PredicatedHandler;
import io.undertow.util.ChainedHandlerWrapper;
import io.undertow.util.FileUtils;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PredicatedHandlersParser {
    public static List<PredicatedHandler> parse(File file, ClassLoader classLoader) {
        return PredicatedHandlersParser.parse(FileUtils.readFile(file), classLoader);
    }

    public static List<PredicatedHandler> parse(InputStream inputStream, ClassLoader classLoader) {
        return PredicatedHandlersParser.parse(FileUtils.readFile(inputStream), classLoader);
    }

    public static List<PredicatedHandler> parse(String contents, ClassLoader classLoader) {
        String[] lines = contents.split("\\n");
        ArrayList<PredicatedHandler> wrappers = new ArrayList<PredicatedHandler>();
        for (String line : lines) {
            HandlerWrapper handler;
            Predicate predicate;
            if (line.trim().length() <= 0) continue;
            String[] parts = line.split("->");
            if (parts.length == 2) {
                predicate = PredicateParser.parse(parts[0], classLoader);
                handler = HandlerParser.parse(parts[1], classLoader);
            } else if (parts.length == 1) {
                predicate = Predicates.truePredicate();
                handler = HandlerParser.parse(parts[0], classLoader);
            } else {
                predicate = PredicateParser.parse(parts[0], classLoader);
                HandlerWrapper[] handlers = new HandlerWrapper[parts.length - 1];
                for (int i = 0; i < handlers.length; ++i) {
                    handlers[i] = HandlerParser.parse(parts[i + 1], classLoader);
                }
                handler = new ChainedHandlerWrapper(Arrays.asList(handlers));
            }
            wrappers.add(new PredicatedHandler(predicate, handler));
        }
        return wrappers;
    }
}

