/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public abstract class DelegatingStreamSourceChannel<T extends DelegatingStreamSourceChannel>
implements StreamSourceChannel {
    protected final ChannelListener.SimpleSetter<T> readSetter = new ChannelListener.SimpleSetter();
    protected final ChannelListener.SimpleSetter<T> closeSetter = new ChannelListener.SimpleSetter();
    protected final StreamSourceChannel delegate;

    public DelegatingStreamSourceChannel(StreamSourceChannel delegate) {
        this.delegate = delegate;
        delegate.getReadSetter().set(ChannelListeners.delegatingChannelListener(this, this.readSetter));
        delegate.getCloseSetter().set(ChannelListeners.delegatingChannelListener(this, this.closeSetter));
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        return this.delegate.transferTo(position, count, target);
    }

    @Override
    public void awaitReadable() throws IOException {
        this.delegate.awaitReadable();
    }

    @Override
    public void suspendReads() {
        this.delegate.suspendReads();
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        return this.delegate.transferTo(count, throughBuffer, target);
    }

    @Override
    public XnioWorker getWorker() {
        return this.delegate.getWorker();
    }

    @Override
    public boolean isReadResumed() {
        return this.delegate.isReadResumed();
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return this.delegate.setOption(option, value);
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return this.delegate.supportsOption(option);
    }

    @Override
    public void shutdownReads() throws IOException {
        this.delegate.shutdownReads();
    }

    @Override
    public ChannelListener.Setter<? extends StreamSourceChannel> getReadSetter() {
        return this.readSetter;
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        return this.delegate.read(dsts);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.delegate.read(dsts, offset, length);
    }

    @Override
    public void wakeupReads() {
        this.delegate.wakeupReads();
    }

    @Override
    public XnioExecutor getReadThread() {
        return this.delegate.getReadThread();
    }

    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        this.delegate.awaitReadable(time, timeUnit);
    }

    @Override
    public ChannelListener.Setter<? extends StreamSourceChannel> getCloseSetter() {
        return this.closeSetter;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return this.delegate.getOption(option);
    }

    @Override
    public void resumeReads() {
        this.delegate.resumeReads();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.delegate.read(dst);
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.delegate.getIoThread();
    }
}

