/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.website.controllers;

import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.SpincastConstants;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;
import org.spincast.website.exchange.IAppRequestContext;

public class ErrorController {
    protected final Logger logger = LoggerFactory.getLogger(ErrorController.class);

    public void notFoundHandler(IAppRequestContext context) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String message = "404 - Page not found";
        String customMessage = context.variables().getAsString(SpincastConstants.RequestScopedVariables.NOT_FOUND_PUBLIC_MESSAGE);
        if (!StringUtils.isBlank(customMessage)) {
            message = customMessage;
        }
        params.put("message", message);
        List<String> htmlSectionClasses = context.variables().get("locale", Key.get(new TypeLiteral<List<String>>(){}));
        if (htmlSectionClasses == null) {
            htmlSectionClasses = new ArrayList<String>();
        }
        params.put("htmlSectionClasses", htmlSectionClasses);
        context.response().sendHtmlTemplate("/templates/notFound.html", params);
    }

    public void exceptionHandler(IAppRequestContext context) {
        Exception exception = context.variables().get(SpincastConstants.RequestScopedVariables.EXCEPTION, Exception.class);
        this.logger.error(SpincastStatics.getStackTrace(exception));
        if (context.request().isJsonRequest()) {
            context.response().sendJson("Server error");
        } else {
            context.response().sendHtmlTemplate("/templates/exception.html", null);
        }
    }
}

