/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.ssl;

import io.undertow.protocols.ssl.SslConduit;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.SslClientAuthMode;
import org.xnio.StreamConnection;
import org.xnio.ssl.SslConnection;

class UndertowSslConnection
extends SslConnection {
    private static final Set<Option<?>> SUPPORTED_OPTIONS = Option.setBuilder().add((Option<?>)Options.SECURE, (Option<?>)Options.SSL_CLIENT_AUTH_MODE).create();
    private final StreamConnection delegate;
    private final SslConduit sslConduit;
    private final ChannelListener.SimpleSetter<SslConnection> handshakeSetter = new ChannelListener.SimpleSetter();
    private final SSLEngine engine;

    UndertowSslConnection(StreamConnection delegate, SSLEngine engine, Pool<ByteBuffer> bufferPool) {
        super(delegate.getIoThread());
        this.delegate = delegate;
        this.engine = engine;
        this.sslConduit = new SslConduit(this, delegate, engine, bufferPool, new HandshakeCallback());
        this.setSourceConduit(this.sslConduit);
        this.setSinkConduit(this.sslConduit);
    }

    @Override
    public void startHandshake() throws IOException {
        this.sslConduit.startHandshake();
    }

    @Override
    public SSLSession getSslSession() {
        return this.sslConduit.getSslSession();
    }

    @Override
    public ChannelListener.Setter<? extends SslConnection> getHandshakeSetter() {
        return this.handshakeSetter;
    }

    @Override
    protected void notifyWriteClosed() {
        this.sslConduit.notifyWriteClosed();
    }

    @Override
    protected void notifyReadClosed() {
        this.sslConduit.notifyReadClosed();
    }

    @Override
    public SocketAddress getPeerAddress() {
        return this.delegate.getPeerAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.delegate.getLocalAddress();
    }

    public SSLEngine getSSLEngine() {
        return this.sslConduit.getSSLEngine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        if (option == Options.SSL_CLIENT_AUTH_MODE) {
            T t;
            try {
                t = option.cast((Object)(this.engine.getNeedClientAuth() ? SslClientAuthMode.REQUIRED : (this.engine.getWantClientAuth() ? SslClientAuthMode.REQUESTED : SslClientAuthMode.NOT_REQUESTED)));
                this.engine.setNeedClientAuth(value == SslClientAuthMode.REQUIRED);
                this.engine.setWantClientAuth(value == SslClientAuthMode.REQUESTED);
            }
            catch (Throwable throwable) {
                this.engine.setNeedClientAuth(value == SslClientAuthMode.REQUIRED);
                this.engine.setWantClientAuth(value == SslClientAuthMode.REQUESTED);
                throw throwable;
            }
            return t;
        }
        if (option == Options.SECURE) {
            throw new IllegalArgumentException();
        }
        return this.delegate.setOption(option, value);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        if (option == Options.SSL_CLIENT_AUTH_MODE) {
            return option.cast((Object)(this.engine.getNeedClientAuth() ? SslClientAuthMode.REQUIRED : (this.engine.getWantClientAuth() ? SslClientAuthMode.REQUESTED : SslClientAuthMode.NOT_REQUESTED)));
        }
        return (T)(option == Options.SECURE ? Boolean.TRUE : this.delegate.getOption(option));
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return SUPPORTED_OPTIONS.contains(option) || this.delegate.supportsOption(option);
    }

    @Override
    protected boolean readClosed() {
        return super.readClosed();
    }

    @Override
    protected boolean writeClosed() {
        return super.writeClosed();
    }

    @Override
    protected void closeAction() {
        this.sslConduit.close();
    }

    private final class HandshakeCallback
    implements Runnable {
        private HandshakeCallback() {
        }

        @Override
        public void run() {
            ChannelListener listener = UndertowSslConnection.this.handshakeSetter.get();
            if (listener == null) {
                return;
            }
            ChannelListeners.invokeChannelListener(UndertowSslConnection.this, listener);
        }
    }
}

