/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.timezoneresolver;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.mitchellbosecke.pebble.extension.AbstractExtension;
import com.mitchellbosecke.pebble.extension.Function;
import com.mitchellbosecke.pebble.extension.escaper.SafeString;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.timezone.TimeZoneResolver;
import org.spincast.core.utils.SpincastUtils;
import org.spincast.plugins.timezoneresolver.SpincastTimeZonePebbleExtension;
import org.spincast.plugins.timezoneresolver.config.SpincastTimeZoneResolverConfig;

public class SpincastTimeZonePebbleExtensionDefault
extends AbstractExtension
implements SpincastTimeZonePebbleExtension {
    public static final String FONCTION_NAME_TIMEZONE_COOKIE = "timeZoneCookie";
    private final TimeZoneResolver timeZoneResolver;
    private final SpincastConfig spincastConfig;
    private final SpincastUtils spincastUtils;
    private final Provider<RequestContext<?>> requestContextProvider;
    private final SpincastTimeZoneResolverConfig spincastTimeZoneResolverConfig;

    @Inject
    public SpincastTimeZonePebbleExtensionDefault(TimeZoneResolver timeZoneResolver, SpincastConfig spincastConfig, SpincastUtils spincastUtils, Provider<RequestContext<?>> requestContextProvider, SpincastTimeZoneResolverConfig spincastTimeZoneResolverConfig) {
        this.timeZoneResolver = timeZoneResolver;
        this.spincastConfig = spincastConfig;
        this.spincastUtils = spincastUtils;
        this.requestContextProvider = requestContextProvider;
        this.spincastTimeZoneResolverConfig = spincastTimeZoneResolverConfig;
    }

    protected TimeZoneResolver getTimeZoneResolver() {
        return this.timeZoneResolver;
    }

    protected SpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected SpincastTimeZoneResolverConfig getSpincastTimeZoneResolverConfig() {
        return this.spincastTimeZoneResolverConfig;
    }

    protected SpincastUtils getSpincastUtils() {
        return this.spincastUtils;
    }

    protected Provider<RequestContext<?>> getRequestContextProvider() {
        return this.requestContextProvider;
    }

    public Map<String, Function> getFunctions() {
        HashMap<String, Function> functions = new HashMap<String, Function>();
        functions.put(FONCTION_NAME_TIMEZONE_COOKIE, this.getTimeZoneCookieFunction());
        return functions;
    }

    protected Function getTimeZoneCookieFunction() {
        String jstz = this.getSpincastUtils().readClasspathFile("spincast/spincast-plugins-timezone-resolver/jstz.2.0.0.min.js");
        final String jstzClean = jstz.replace(".jstz", ".spincast_jstz");
        return new Function(){

            public List<String> getArgumentNames() {
                return Lists.newArrayList((Object[])new String[]{"addScriptTag", "reloadPageIfSet"});
            }

            public Object execute(Map<String, Object> args) {
                try {
                    RequestContext context = (RequestContext)SpincastTimeZonePebbleExtensionDefault.this.getRequestContextProvider().get();
                    String cookieValue = context.request().getCookieValue(SpincastTimeZonePebbleExtensionDefault.this.getSpincastConfig().getCookieNameTimeZoneId());
                    if (cookieValue != null) {
                        return "";
                    }
                }
                catch (OutOfScopeException | ProvisionException context) {
                    // empty catch block
                }
                boolean addScriptTag = true;
                Object addScriptTagObj = args.get("addScriptTag");
                if (addScriptTagObj != null && addScriptTagObj.toString().toLowerCase().equals("false")) {
                    addScriptTag = false;
                }
                OffsetDateTime hoursFromNow = OffsetDateTime.now(ZoneOffset.UTC).plus(Duration.ofHours(SpincastTimeZonePebbleExtensionDefault.this.getSpincastTimeZoneResolverConfig().getPebbleTimeZoneCookieExpiredHoursNbr()));
                String expiresDate = DateTimeFormatter.RFC_1123_DATE_TIME.format(hoursFromNow);
                StringBuilder b = new StringBuilder();
                if (addScriptTag) {
                    b.append("<script>\n");
                }
                b.append(jstzClean).append("\n");
                b.append("(function(){\n");
                b.append("function getCookie(n) {\n");
                b.append("  var v = \"; \" + document.cookie;\n");
                b.append("  var p = v.split(\"; \" + n + \"=\");\n");
                b.append("  if (p.length == 2) return p.pop().split(\";\").shift();\n");
                b.append("}\n");
                b.append("var previousTz = getCookie('").append(SpincastTimeZonePebbleExtensionDefault.this.getSpincastConfig().getCookieNameTimeZoneId()).append("');\n");
                b.append("var newTz = spincast_jstz.determine().name();\n");
                b.append("if(newTz !== previousTz) {\n");
                b.append("document.cookie ='").append(SpincastTimeZonePebbleExtensionDefault.this.getSpincastConfig().getCookieNameTimeZoneId()).append("=' + newTz + '; expires=").append(expiresDate).append("; domain=").append(SpincastTimeZonePebbleExtensionDefault.this.getSpincastTimeZoneResolverConfig().getPebbleTimeZoneCookieDomain()).append("; path=").append(SpincastTimeZonePebbleExtensionDefault.this.getSpincastTimeZoneResolverConfig().getPebbleTimeZoneCookiePath()).append("';\n");
                b.append("var url = window.location.href;\n");
                b.append("var flag = '").append(SpincastTimeZonePebbleExtensionDefault.this.getSpincastTimeZoneResolverConfig().getPebbleTimeZoneCookieReloadingQsParamName()).append("=1';\n");
                b.append("if (getCookie('").append(SpincastTimeZonePebbleExtensionDefault.this.getSpincastConfig().getCookieNameTimeZoneId()).append("') === newTz && !url.includes(flag)) {\n");
                b.append("url = (url.indexOf(\"?\") != -1 ? url.split(\"?\")[0]+\"?\"+flag+\"&\"+url.split(\"?\")[1] : (url.indexOf(\"#\") != -1 ? url.split(\"#\")[0]+\"?\"+flag+\"#\"+ url.split(\"#\")[1] : url+'?'+flag));\n");
                b.append("window.location.replace(url);\n");
                b.append("}\n");
                b.append("}\n");
                b.append("})()\n");
                if (addScriptTag) {
                    b.append("</script>\n");
                }
                String script = b.toString();
                return new SafeString(script);
            }
        };
    }
}

