/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.timezoneresolver;

import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.mitchellbosecke.pebble.extension.Extension;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.guice.SpincastGuiceModuleBase;
import org.spincast.core.timezone.TimeZoneResolver;
import org.spincast.core.websocket.WebsocketContext;
import org.spincast.plugins.timezoneresolver.SpincastTimeZonePebbleExtension;
import org.spincast.plugins.timezoneresolver.SpincastTimeZonePebbleExtensionDefault;
import org.spincast.plugins.timezoneresolver.TimeZoneResolverDefault;

public class SpincastTimeZoneResolverPluginModule
extends SpincastGuiceModuleBase {
    public SpincastTimeZoneResolverPluginModule() {
    }

    public SpincastTimeZoneResolverPluginModule(Class<? extends RequestContext<?>> requestContextImplementationClass, Class<? extends WebsocketContext<?>> websocketContextImplementationClass) {
        super(requestContextImplementationClass, websocketContextImplementationClass);
    }

    protected void configure() {
        this.bindTimeZoneResolver();
        if (this.isPebbleAvailable()) {
            this.bindPebbleExtension();
        }
    }

    protected boolean isPebbleAvailable() {
        try {
            Class.forName("com.mitchellbosecke.pebble.extension.Extension");
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    protected void bindTimeZoneResolver() {
        this.bind(TimeZoneResolver.class).to(TimeZoneResolverDefault.class).in(Scopes.SINGLETON);
    }

    protected void bindPebbleExtension() {
        this.bind(SpincastTimeZonePebbleExtension.class).to(this.getPebbleExtensionImplClass()).in(Scopes.SINGLETON);
        Multibinder pebbleExtensionsMultibinder = Multibinder.newSetBinder((Binder)this.binder(), Extension.class);
        pebbleExtensionsMultibinder.addBinding().to(SpincastTimeZonePebbleExtension.class).in(Scopes.SINGLETON);
    }

    protected Class<? extends SpincastTimeZonePebbleExtension> getPebbleExtensionImplClass() {
        return SpincastTimeZonePebbleExtensionDefault.class;
    }
}

