/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.jdbc.statements;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.jdbc.statements.InsertStatement;
import org.spincast.plugins.jdbc.statements.StatementBase;

public class InsertStatementDefault
extends StatementBase
implements InsertStatement {
    @AssistedInject
    public InsertStatementDefault(@Assisted Connection connection) {
        super(connection);
    }

    @Override
    public int insert() {
        Long affectedRowsNbr = this.insertPrivate(null);
        return affectedRowsNbr.intValue();
    }

    @Override
    public Long insertGetGeneratedId(String primaryKeyColumnName) {
        return this.insertPrivate(primaryKeyColumnName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Long insertPrivate(String primaryKeyColumnName) {
        Connection connection = this.getConnection();
        try {
            PreparedStatement realStatement = primaryKeyColumnName != null ? connection.prepareStatement(this.getParsedQuery(), new String[]{primaryKeyColumnName}) : connection.prepareStatement(this.getParsedQuery());
            this.addCurrentParamsToStatement(realStatement);
            try {
                Long id;
                int affectedRowsNbr = realStatement.executeUpdate();
                if (primaryKeyColumnName == null) {
                    Long l = affectedRowsNbr;
                    return l;
                }
                ResultSet resultSet = realStatement.getGeneratedKeys();
                if (resultSet == null) throw new RuntimeException("Unable to get the generated id!");
                if (!resultSet.next()) throw new RuntimeException("Unable to get the generated id!");
                Long l = id = Long.valueOf(resultSet.getLong(1));
                return l;
            }
            finally {
                this.close(realStatement);
            }
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }
}

