/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.jdbc;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.jdbc.ConnectionScope;
import org.spincast.plugins.jdbc.JdbcQueries;
import org.spincast.plugins.jdbc.SpincastConnection;
import org.spincast.plugins.jdbc.SpincastConnectionFactory;
import org.spincast.plugins.jdbc.SpincastDataSource;
import org.spincast.plugins.jdbc.TransactionalScope;

@Singleton
public class JdbcScope {
    protected static final Logger logger = LoggerFactory.getLogger(JdbcScope.class);
    private static final ThreadLocal<Boolean> insideTransactionScopeFlagThreadLocal = new ThreadLocal();
    protected static final ThreadLocal<Map<String, SpincastConnection>> spincastConnectionsThreadLocal = new ThreadLocal();
    private static final ThreadLocal<Boolean> insideSpecificConnectionScopeFlagThreadLocal = new ThreadLocal();
    protected static final ThreadLocal<Map<String, Connection>> spincastSpecificConnectionsThreadLocal = new ThreadLocal();
    private final SpincastConnectionFactory spincastConnectionFactory;

    @Inject
    public JdbcScope(SpincastConnectionFactory spincastConnectionFactory) {
        this.spincastConnectionFactory = spincastConnectionFactory;
    }

    protected SpincastConnectionFactory getSpincastConnectionFactory() {
        return this.spincastConnectionFactory;
    }

    protected String getDataSourceKey(DataSource dataSource) {
        return dataSource.getClass().getName();
    }

    public boolean isInTransactionScope() {
        Boolean result = insideTransactionScopeFlagThreadLocal.get();
        return result != null && result != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T autoCommit(DataSource dataSource, JdbcQueries<T> queries) {
        try {
            Connection specificConnection;
            Map<String, Connection> specificConnectionByDataSourceKey = spincastSpecificConnectionsThreadLocal.get();
            if (specificConnectionByDataSourceKey != null && (specificConnection = specificConnectionByDataSourceKey.get(this.getDataSourceKey(dataSource))) != null) {
                logger.debug("Specific connection in ThreadLocal, using it.");
                T result2 = queries.run(specificConnection);
                return result2;
            }
            Connection connection = dataSource.getConnection();
            if (!(connection instanceof SpincastConnection)) {
                connection = this.getSpincastConnectionFactory().create(connection);
            }
            connection.setAutoCommit(true);
            try {
                T result;
                T t = result = queries.run(connection);
                return t;
            }
            finally {
                if (!this.isInTransactionScope()) {
                    ((SpincastConnection)connection).getWrappedConnection().close();
                }
            }
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public <T> T specificConnection(Connection connection, DataSource dataSource, ConnectionScope<T> connectionScope) {
        boolean isFirstSpecificTransactionScope;
        Objects.requireNonNull(connection, "The connection can't be NULL");
        Objects.requireNonNull(connectionScope, "The connectionScope can't be NULL");
        Objects.requireNonNull(dataSource, "The dataSource can't be NULL");
        boolean bl = isFirstSpecificTransactionScope = insideSpecificConnectionScopeFlagThreadLocal.get() == null;
        if (isFirstSpecificTransactionScope) {
            insideSpecificConnectionScopeFlagThreadLocal.set(true);
        }
        try {
            String dataSourceKey;
            Connection connectionExisting;
            Map<String, Connection> specificConnectionsByDataSourceKey = spincastSpecificConnectionsThreadLocal.get();
            if (specificConnectionsByDataSourceKey == null) {
                specificConnectionsByDataSourceKey = new HashMap<String, Connection>();
                spincastSpecificConnectionsThreadLocal.set(specificConnectionsByDataSourceKey);
            }
            if ((connectionExisting = specificConnectionsByDataSourceKey.get(dataSourceKey = this.getDataSourceKey(dataSource))) == null) {
                specificConnectionsByDataSourceKey.put(dataSourceKey, connection);
            } else {
                connection = connectionExisting;
                logger.debug("Specific connection in thread locale, using it.");
            }
            T t = connectionScope.run(connection);
            return t;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
        finally {
            if (isFirstSpecificTransactionScope) {
                insideSpecificConnectionScopeFlagThreadLocal.remove();
                spincastSpecificConnectionsThreadLocal.remove();
            }
        }
    }

    public <T> T specificConnection(Connection connection, DataSource dataSource, final JdbcQueries<T> queries) {
        Objects.requireNonNull(connection, "The connection can't be NULL");
        Objects.requireNonNull(queries, "The queries can't be NULL");
        return this.specificConnection(connection, dataSource, new ConnectionScope<T>(){

            @Override
            public T run(Connection connection) throws Exception {
                Object result = queries.run(connection);
                return result;
            }
        });
    }

    public <T> T transactional(final DataSource dataSource, final JdbcQueries<T> queries) {
        try {
            Connection specificConnection;
            Map<String, Connection> specificConnectionByDataSourceKey = spincastSpecificConnectionsThreadLocal.get();
            if (specificConnectionByDataSourceKey != null && (specificConnection = specificConnectionByDataSourceKey.get(this.getDataSourceKey(dataSource))) != null) {
                logger.debug("Specific connection in ThreadLocal, using it.");
                T result = queries.run(specificConnection);
                return result;
            }
            return this.transactional(new TransactionalScope<T>(){

                @Override
                public T run() throws Exception {
                    Connection connection = dataSource.getConnection();
                    if (!(connection instanceof SpincastConnection)) {
                        throw new RuntimeException("Only a Datasource which has been wrapped in a " + SpincastDataSource.class.getName() + " can be part of a Spincast transactionnal scope! This one isn't : " + dataSource.getClass().getName());
                    }
                    Object result = queries.run(connection);
                    return result;
                }
            });
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public <T> T transactional(TransactionalScope<T> scope) {
        Map<String, SpincastConnection> map;
        boolean isFirstTransactionalScope;
        boolean bl = isFirstTransactionalScope = insideTransactionScopeFlagThreadLocal.get() == null;
        if (isFirstTransactionalScope) {
            insideTransactionScopeFlagThreadLocal.set(true);
        }
        if ((map = spincastConnectionsThreadLocal.get()) != null) {
            for (Map.Entry<String, SpincastConnection> entry : map.entrySet()) {
                try {
                    SpincastConnection spincastConnection = entry.getValue();
                    spincastConnection.setNewRootSavePoint();
                }
                catch (Exception exception) {
                    throw SpincastStatics.runtimize((Exception)exception);
                }
            }
        }
        try {
            T result = scope.run();
            if (isFirstTransactionalScope && (map = spincastConnectionsThreadLocal.get()) != null) {
                for (Map.Entry entry : map.entrySet()) {
                    try {
                        SpincastConnection spincastConnection = (SpincastConnection)entry.getValue();
                        spincastConnection.getWrappedConnection().commit();
                    }
                    catch (Exception exception) {
                        throw SpincastStatics.runtimize((Exception)exception);
                    }
                }
            }
            T t = result;
            return t;
        }
        catch (Throwable ex) {
            map = spincastConnectionsThreadLocal.get();
            if (map != null) {
                for (Map.Entry entry : map.entrySet()) {
                    try {
                        SpincastConnection spincastConnection = (SpincastConnection)entry.getValue();
                        spincastConnection.getWrappedConnection().rollback();
                    }
                    catch (Exception exception) {
                        logger.error("Error rollbacking a connection...");
                    }
                }
            }
            if (ex instanceof Error) {
                throw (Error)ex;
            }
            throw SpincastStatics.runtimize((Exception)((Exception)ex));
        }
        finally {
            if (isFirstTransactionalScope) {
                map = spincastConnectionsThreadLocal.get();
                if (map != null) {
                    for (Map.Entry<String, SpincastConnection> entry : map.entrySet()) {
                        SpincastConnection spincastConnection = entry.getValue();
                        try {
                            spincastConnection.getWrappedConnection().setAutoCommit(true);
                        }
                        catch (Exception ex) {
                            logger.error("Error setAutoCommit(true) on a connection...");
                        }
                        try {
                            spincastConnection.getWrappedConnection().close();
                        }
                        catch (Exception ex) {
                            logger.error("Error closing a connection...");
                        }
                    }
                }
                insideTransactionScopeFlagThreadLocal.remove();
                spincastConnectionsThreadLocal.remove();
            }
        }
    }

    public Connection getConnectionInterceptor(MethodInvocation invocation) {
        try {
            String dataSourceKey;
            SpincastConnection spincastConnection;
            if (!(invocation.getThis() instanceof DataSource)) {
                throw new RuntimeException("getConnection() called on an object which is not a DataSource : " + invocation.getThis());
            }
            if (!"getConnection".equals(invocation.getMethod().getName())) {
                return (Connection)invocation.proceed();
            }
            if (!this.isInTransactionScope()) {
                return (Connection)invocation.proceed();
            }
            Map<String, SpincastConnection> connectionsForThisThread = spincastConnectionsThreadLocal.get();
            if (connectionsForThisThread == null) {
                connectionsForThisThread = new HashMap<String, SpincastConnection>();
                spincastConnectionsThreadLocal.set(connectionsForThisThread);
            }
            if ((spincastConnection = connectionsForThisThread.get(dataSourceKey = this.getDataSourceKey((DataSource)invocation.getThis()))) == null) {
                Connection originalConnection = (Connection)invocation.proceed();
                originalConnection.setAutoCommit(false);
                spincastConnection = !(originalConnection instanceof SpincastConnection) ? this.getSpincastConnectionFactory().create(originalConnection) : (SpincastConnection)originalConnection;
                connectionsForThisThread.put(dataSourceKey, spincastConnection);
            }
            return spincastConnection;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }
}

