/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.jdbc.statements;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.jdbc.SpincastResultSetDefault;
import org.spincast.plugins.jdbc.statements.DeleteStatement;
import org.spincast.plugins.jdbc.statements.ResultSetHandler;
import org.spincast.plugins.jdbc.statements.StatementBase;

public class DeleteStatementDefault
extends StatementBase
implements DeleteStatement {
    @AssistedInject
    public DeleteStatementDefault(@Assisted Connection connection) {
        super(connection);
    }

    protected PreparedStatement getStatementWithParamsAdded(Connection connection) {
        try {
            PreparedStatement statement = connection.prepareStatement(this.getParsedQuery());
            this.addCurrentParamsToStatement(statement);
            return statement;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete() {
        int n;
        Connection connection = this.getConnection();
        PreparedStatement realStatement = this.getStatementWithParamsAdded(connection);
        try {
            int affectedRowsNbr;
            n = affectedRowsNbr = realStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            try {
                this.close(realStatement);
                throw throwable;
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize((Exception)ex);
            }
        }
        this.close(realStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> List<T> delete(ResultSetHandler<T> resultSetHandler) {
        Connection connection = this.getConnection();
        try {
            PreparedStatement realStatement = this.getStatementWithParamsAdded(connection);
            try {
                ArrayList<T> arrayList;
                ResultSet resultSet = realStatement.executeQuery();
                try {
                    ArrayList<T> items = new ArrayList<T>();
                    if (resultSetHandler != null && resultSet.isBeforeFirst()) {
                        while (resultSet.next()) {
                            T item = resultSetHandler.handle(new SpincastResultSetDefault(resultSet));
                            items.add(item);
                        }
                    }
                    arrayList = items;
                }
                catch (Throwable throwable) {
                    this.close(resultSet);
                    throw throwable;
                }
                this.close(resultSet);
                return arrayList;
            }
            finally {
                this.close(realStatement);
            }
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }
}

