/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.jdbc;

import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.matcher.Matchers;
import javax.sql.DataSource;
import org.aopalliance.intercept.MethodInterceptor;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.guice.SpincastGuiceModuleBase;
import org.spincast.core.websocket.WebsocketContext;
import org.spincast.plugins.jdbc.DataSourceInterceptor;
import org.spincast.plugins.jdbc.JdbcScope;
import org.spincast.plugins.jdbc.JdbcStatementFactory;
import org.spincast.plugins.jdbc.JdbcUtils;
import org.spincast.plugins.jdbc.JdbcUtilsDefault;
import org.spincast.plugins.jdbc.SpincastConnection;
import org.spincast.plugins.jdbc.SpincastConnectionDefault;
import org.spincast.plugins.jdbc.SpincastConnectionFactory;
import org.spincast.plugins.jdbc.SpincastDataSource;
import org.spincast.plugins.jdbc.SpincastDataSourceDefault;
import org.spincast.plugins.jdbc.SpincastDataSourceFactory;
import org.spincast.plugins.jdbc.statements.BatchInsertStatement;
import org.spincast.plugins.jdbc.statements.BatchInsertStatementDefault;
import org.spincast.plugins.jdbc.statements.DeleteStatement;
import org.spincast.plugins.jdbc.statements.DeleteStatementDefault;
import org.spincast.plugins.jdbc.statements.InsertStatement;
import org.spincast.plugins.jdbc.statements.InsertStatementDefault;
import org.spincast.plugins.jdbc.statements.SelectStatement;
import org.spincast.plugins.jdbc.statements.SelectStatementDefault;
import org.spincast.plugins.jdbc.statements.UpdateStatement;
import org.spincast.plugins.jdbc.statements.UpdateStatementDefault;

public class SpincastJdbcPluginModule
extends SpincastGuiceModuleBase {
    public SpincastJdbcPluginModule() {
    }

    public SpincastJdbcPluginModule(Class<? extends RequestContext<?>> requestContextImplementationClass, Class<? extends WebsocketContext<?>> websocketContextImplementationClass) {
        super(requestContextImplementationClass, websocketContextImplementationClass);
    }

    protected void configure() {
        this.install(new FactoryModuleBuilder().implement(SelectStatement.class, this.getSelectJdbcStatementImpl()).implement(InsertStatement.class, this.getInsertJdbcStatementDefaultImpl()).implement(BatchInsertStatement.class, this.getBatchInsertJdbcStatementImpl()).implement(UpdateStatement.class, this.getUpdateJdbcStatementImpl()).implement(DeleteStatement.class, this.getDeleteJdbcStatementImpl()).build(JdbcStatementFactory.class));
        this.install(new FactoryModuleBuilder().implement(SpincastDataSource.class, this.getSpincastDataSourceImpl()).build(SpincastDataSourceFactory.class));
        this.install(new FactoryModuleBuilder().implement(SpincastConnection.class, this.getSpincastConnectionImpl()).build(SpincastConnectionFactory.class));
        this.bind(JdbcUtils.class).to(this.getJdbcUtilsImpl()).in(Scopes.SINGLETON);
        this.bindInterceptor(Matchers.subclassesOf(DataSource.class), Matchers.any(), new MethodInterceptor[]{this.getDataSourceInterceptor()});
    }

    protected Class<? extends SelectStatement> getSelectJdbcStatementImpl() {
        return SelectStatementDefault.class;
    }

    protected Class<? extends InsertStatement> getInsertJdbcStatementDefaultImpl() {
        return InsertStatementDefault.class;
    }

    protected Class<? extends BatchInsertStatement> getBatchInsertJdbcStatementImpl() {
        return BatchInsertStatementDefault.class;
    }

    protected Class<? extends UpdateStatement> getUpdateJdbcStatementImpl() {
        return UpdateStatementDefault.class;
    }

    protected Class<? extends DeleteStatement> getDeleteJdbcStatementImpl() {
        return DeleteStatementDefault.class;
    }

    protected Class<? extends SpincastDataSource> getSpincastDataSourceImpl() {
        return SpincastDataSourceDefault.class;
    }

    protected Class<? extends SpincastConnection> getSpincastConnectionImpl() {
        return SpincastConnectionDefault.class;
    }

    protected MethodInterceptor getDataSourceInterceptor() {
        return new DataSourceInterceptor((Provider<JdbcScope>)this.getProvider(JdbcScope.class));
    }

    private Class<? extends JdbcUtils> getJdbcUtilsImpl() {
        return JdbcUtilsDefault.class;
    }
}

