/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.jdbc.statements;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.jdbc.SpincastResultSetDefault;
import org.spincast.plugins.jdbc.statements.ResultSetHandler;
import org.spincast.plugins.jdbc.statements.StatementBase;
import org.spincast.plugins.jdbc.statements.UpdateStatement;

public class UpdateStatementDefault
extends StatementBase
implements UpdateStatement {
    @AssistedInject
    public UpdateStatementDefault(@Assisted Connection connection) {
        super(connection);
    }

    protected PreparedStatement getStatementWithParamsAdded(Connection connection) {
        try {
            PreparedStatement statement = connection.prepareStatement(this.getParsedQuery());
            this.addCurrentParamsToStatement(statement);
            return statement;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update() {
        int n;
        Connection connection = this.getConnection();
        PreparedStatement realStatement = this.getStatementWithParamsAdded(connection);
        try {
            int affectedRows;
            n = affectedRows = realStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            try {
                this.close(realStatement);
                throw throwable;
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize((Exception)ex);
            }
        }
        this.close(realStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> List<T> update(ResultSetHandler<T> resultSetHandler) {
        Connection connection = this.getConnection();
        try {
            PreparedStatement realStatement = this.getStatementWithParamsAdded(connection);
            try {
                ArrayList<T> arrayList;
                ResultSet resultSet = realStatement.executeQuery();
                try {
                    ArrayList<T> items = new ArrayList<T>();
                    if (resultSetHandler != null && resultSet.isBeforeFirst()) {
                        while (resultSet.next()) {
                            T item = resultSetHandler.handle(new SpincastResultSetDefault(resultSet));
                            items.add(item);
                        }
                    }
                    arrayList = items;
                }
                catch (Throwable throwable) {
                    this.close(resultSet);
                    throw throwable;
                }
                this.close(resultSet);
                return arrayList;
            }
            finally {
                this.close(realStatement);
            }
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    @Override
    public void setCase(String paramName, String columnNameToCheck, Map<?, ?> map) {
        StringBuilder caseQuery = new StringBuilder();
        if (map == null || map.size() == 0) {
            caseQuery.append(" null ");
        } else {
            caseQuery.append(" CASE ");
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                String caseParamName = this.createUniqueParamName();
                caseQuery.append("WHEN ").append(columnNameToCheck).append("=").append(":").append(caseParamName).append(" ");
                this.addParam(caseParamName, entry.getKey());
                caseParamName = this.createUniqueParamName();
                caseQuery.append(" THEN ").append(":").append(caseParamName).append(" ");
                this.addParam(caseParamName, entry.getValue());
            }
            caseQuery.append(" END ");
        }
        this.getStaticTokens().put(paramName, caseQuery.toString());
    }

    protected String createUniqueParamName() {
        return "x" + UUID.randomUUID().toString().replace("-", "_") + "x";
    }
}

