/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.jdbc.statements;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.jdbc.statements.InsertResultWithGeneratedKey;
import org.spincast.plugins.jdbc.statements.InsertStatement;
import org.spincast.plugins.jdbc.statements.QueryResult;
import org.spincast.plugins.jdbc.statements.QueryResultFactory;
import org.spincast.plugins.jdbc.statements.StatementBase;

public class InsertStatementDefault
extends StatementBase
implements InsertStatement {
    @AssistedInject
    public InsertStatementDefault(@Assisted Connection connection, QueryResultFactory queryResultFactory) {
        super(connection, queryResultFactory);
    }

    @Override
    public QueryResult insert() {
        return this.insertPrivate(null);
    }

    @Override
    public InsertResultWithGeneratedKey insertGetGeneratedKey(String primaryKeyName) {
        return this.insertPrivate(primaryKeyName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected InsertResultWithGeneratedKey insertPrivate(String primaryKeyName) {
        Connection connection = this.getConnection();
        try {
            PreparedStatement realStatement = primaryKeyName != null ? connection.prepareStatement(this.getParsedQuery(), new String[]{primaryKeyName}) : connection.prepareStatement(this.getParsedQuery());
            this.addCurrentParamsToStatement(realStatement);
            try {
                int queryResult = realStatement.executeUpdate();
                if (primaryKeyName == null) {
                    InsertResultWithGeneratedKey insertResultWithGeneratedKey = this.getQueryResultFactory().create(queryResult, null);
                    return insertResultWithGeneratedKey;
                }
                ResultSet resultSet = realStatement.getGeneratedKeys();
                if (resultSet == null) throw new RuntimeException("Unable to get the generated id!");
                if (!resultSet.next()) throw new RuntimeException("Unable to get the generated id!");
                Long id = resultSet.getLong(1);
                InsertResultWithGeneratedKey insertResultWithGeneratedKey = this.getQueryResultFactory().create(queryResult, id);
                return insertResultWithGeneratedKey;
            }
            finally {
                this.close(realStatement);
            }
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }
}

