/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.jdbc.statements;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Map;
import java.util.UUID;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.jdbc.statements.QueryResult;
import org.spincast.plugins.jdbc.statements.QueryResultFactory;
import org.spincast.plugins.jdbc.statements.StatementBase;
import org.spincast.plugins.jdbc.statements.UpdateStatement;

public class UpdateStatementDefault
extends StatementBase
implements UpdateStatement {
    @AssistedInject
    public UpdateStatementDefault(@Assisted Connection connection, QueryResultFactory queryResultFactory) {
        super(connection, queryResultFactory);
    }

    protected PreparedStatement getStatementWithParamsAdded(Connection connection) {
        try {
            PreparedStatement statement = connection.prepareStatement(this.getParsedQuery());
            this.addCurrentParamsToStatement(statement);
            return statement;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryResult update() {
        QueryResult queryResult;
        Connection connection = this.getConnection();
        PreparedStatement realStatement = this.getStatementWithParamsAdded(connection);
        try {
            QueryResult queryResultObj;
            int queryResult2 = realStatement.executeUpdate();
            queryResult = queryResultObj = this.getQueryResultFactory().create(queryResult2);
        }
        catch (Throwable throwable) {
            try {
                this.close(realStatement);
                throw throwable;
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize((Exception)ex);
            }
        }
        this.close(realStatement);
        return queryResult;
    }

    @Override
    public void setCase(String paramName, String columnNameToCheck, Map<?, ?> map) {
        StringBuilder caseQuery = new StringBuilder();
        if (map == null || map.size() == 0) {
            caseQuery.append(" null ");
        } else {
            caseQuery.append(" CASE ");
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                String caseParamName = this.createUniqueParamName();
                caseQuery.append("WHEN ").append(columnNameToCheck).append("=").append(":").append(caseParamName).append(" ");
                this.addParam(caseParamName, entry.getKey());
                caseParamName = this.createUniqueParamName();
                caseQuery.append(" THEN ").append(":").append(caseParamName).append(" ");
                this.addParam(caseParamName, entry.getValue());
            }
            caseQuery.append(" END ");
        }
        this.getStaticTokens().put(paramName, caseQuery.toString());
    }

    protected String createUniqueParamName() {
        return "x" + UUID.randomUUID().toString().replace("-", "_") + "x";
    }
}

