/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.jdbc;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.jdbc.JdbcQueries;
import org.spincast.plugins.jdbc.SpincastConnection;
import org.spincast.plugins.jdbc.SpincastConnectionFactory;
import org.spincast.plugins.jdbc.SpincastDataSource;
import org.spincast.plugins.jdbc.TransactionalScope;

@Singleton
public class JdbcScope {
    protected final Logger logger = LoggerFactory.getLogger(JdbcScope.class);
    private static final ThreadLocal<Boolean> insideTransactionScopeFlagThreadLocal = new ThreadLocal();
    protected static final ThreadLocal<Map<String, SpincastConnection>> spincastConnectionsThreadLocal = new ThreadLocal();
    private final SpincastConnectionFactory spincastConnectionFactory;

    @Inject
    public JdbcScope(SpincastConnectionFactory spincastConnectionFactory) {
        this.spincastConnectionFactory = spincastConnectionFactory;
    }

    protected SpincastConnectionFactory getSpincastConnectionFactory() {
        return this.spincastConnectionFactory;
    }

    protected String getDataSourceKey(DataSource dataSource) {
        return dataSource.getClass().getName();
    }

    public boolean isInTransactionScope() {
        Boolean result = insideTransactionScopeFlagThreadLocal.get();
        return result != null && result != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T autoCommit(DataSource dataSource, JdbcQueries<T> queries) {
        try {
            Connection connection = dataSource.getConnection();
            if (!(connection instanceof SpincastConnection)) {
                connection = this.getSpincastConnectionFactory().create(connection);
            }
            try {
                T result;
                connection.setAutoCommit(true);
                T t = result = queries.run(connection);
                return t;
            }
            finally {
                if (!this.isInTransactionScope()) {
                    ((SpincastConnection)connection).getWrappedConnection().close();
                }
            }
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public <T> T transactional(final DataSource dataSource, final JdbcQueries<T> queries) {
        try {
            return this.transactional(new TransactionalScope<T>(){

                @Override
                public T run() throws Exception {
                    Connection connection = dataSource.getConnection();
                    if (!(connection instanceof SpincastConnection)) {
                        throw new RuntimeException("Only a Datasource which has been wrapped in a " + SpincastDataSource.class.getName() + " can be part of a Spincast transactionnal scope! This one isn't : " + dataSource.getClass().getName());
                    }
                    Object result = queries.run(connection);
                    return result;
                }
            });
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public <T> T transactional(TransactionalScope<T> scope) {
        Map<String, SpincastConnection> map;
        boolean isFirstTransactionalScope;
        boolean bl = isFirstTransactionalScope = insideTransactionScopeFlagThreadLocal.get() == null;
        if (isFirstTransactionalScope) {
            insideTransactionScopeFlagThreadLocal.set(true);
        }
        if ((map = spincastConnectionsThreadLocal.get()) != null) {
            for (Map.Entry<String, SpincastConnection> entry : map.entrySet()) {
                try {
                    SpincastConnection spincastConnection = entry.getValue();
                    spincastConnection.setNewRootSavePoint();
                }
                catch (Exception exception) {
                    throw SpincastStatics.runtimize((Exception)exception);
                }
            }
        }
        try {
            T result = scope.run();
            if (isFirstTransactionalScope && (map = spincastConnectionsThreadLocal.get()) != null) {
                for (Map.Entry entry : map.entrySet()) {
                    try {
                        SpincastConnection spincastConnection = (SpincastConnection)entry.getValue();
                        spincastConnection.getWrappedConnection().commit();
                    }
                    catch (Exception exception) {
                        throw SpincastStatics.runtimize((Exception)exception);
                    }
                }
            }
            T t = result;
            return t;
        }
        catch (Exception ex) {
            map = spincastConnectionsThreadLocal.get();
            if (map != null) {
                for (Map.Entry entry : map.entrySet()) {
                    try {
                        SpincastConnection spincastConnection = (SpincastConnection)entry.getValue();
                        spincastConnection.getWrappedConnection().rollback();
                    }
                    catch (Exception exception) {
                        this.logger.error("Error rollbacking a connection...");
                    }
                }
            }
            throw SpincastStatics.runtimize((Exception)ex);
        }
        finally {
            if (isFirstTransactionalScope) {
                map = spincastConnectionsThreadLocal.get();
                if (map != null) {
                    for (Map.Entry<String, SpincastConnection> entry : map.entrySet()) {
                        SpincastConnection connection = entry.getValue();
                        try {
                            connection.getWrappedConnection().setAutoCommit(true);
                        }
                        catch (Exception ex2) {
                            this.logger.error("Error setAutoCommit(true) on a connection...");
                        }
                        try {
                            connection.getWrappedConnection().close();
                        }
                        catch (Exception ex3) {
                            this.logger.error("Error closing a connection...");
                        }
                    }
                }
                insideTransactionScopeFlagThreadLocal.remove();
                spincastConnectionsThreadLocal.remove();
            }
        }
    }

    public Connection getConnection(MethodInvocation invocation) {
        try {
            String dataSourceKey;
            SpincastConnection spincastConnection;
            if (!(invocation.getThis() instanceof DataSource)) {
                throw new RuntimeException("getConnection() called on an object which is not a DataSource : " + invocation.getThis());
            }
            if (!"getConnection".equals(invocation.getMethod().getName())) {
                return (Connection)invocation.proceed();
            }
            if (!this.isInTransactionScope()) {
                return (Connection)invocation.proceed();
            }
            Map<String, SpincastConnection> connectionsForThisThread = spincastConnectionsThreadLocal.get();
            if (connectionsForThisThread == null) {
                connectionsForThisThread = new HashMap<String, SpincastConnection>();
                spincastConnectionsThreadLocal.set(connectionsForThisThread);
            }
            if ((spincastConnection = connectionsForThisThread.get(dataSourceKey = this.getDataSourceKey((DataSource)invocation.getThis()))) == null) {
                Connection originalConnection = (Connection)invocation.proceed();
                originalConnection.setAutoCommit(false);
                spincastConnection = this.getSpincastConnectionFactory().create(originalConnection);
                connectionsForThisThread.put(dataSourceKey, spincastConnection);
            }
            return spincastConnection;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }
}

