/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.httpclient.websocket.builders;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import io.undertow.websockets.WebSocketExtension;
import io.undertow.websockets.client.WebSocketClient;
import io.undertow.websockets.client.WebSocketClientNegotiation;
import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedBinaryMessage;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.CloseMessage;
import io.undertow.websockets.core.WebSocketCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.cookies.ICookieFactory;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.httpclient.IHttpResponse;
import org.spincast.plugins.httpclient.IHttpResponseFactory;
import org.spincast.plugins.httpclient.ISpincastHttpClientConfig;
import org.spincast.plugins.httpclient.builders.SpincastHttpRequestBuilderBase;
import org.spincast.plugins.httpclient.utils.ISpincastHttpClientUtils;
import org.spincast.plugins.httpclient.websocket.ISpincastHttpClientWithWebsocketConfig;
import org.spincast.plugins.httpclient.websocket.ISpincastWebsocketClientWriter;
import org.spincast.plugins.httpclient.websocket.IWebsocketClientHandler;
import org.spincast.plugins.httpclient.websocket.IWebsocketClientWriter;
import org.spincast.plugins.httpclient.websocket.builders.IWebsocketRequestBuilder;
import org.spincast.plugins.httpclient.websocket.utils.ISpincastHttpClientWithWebsocketUtils;
import org.spincast.shaded.org.apache.commons.codec.binary.Base64;
import org.spincast.shaded.org.apache.http.client.methods.HttpGet;
import org.spincast.shaded.org.apache.http.client.methods.HttpRequestBase;
import org.spincast.shaded.org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.spincast.shaded.org.apache.http.cookie.Cookie;
import org.spincast.shaded.org.apache.http.ssl.SSLContexts;
import org.spincast.shaded.org.apache.http.ssl.TrustStrategy;
import org.xnio.ByteBufferSlicePool;
import org.xnio.ChannelListener;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.ssl.JsseXnioSsl;
import org.xnio.ssl.XnioSsl;

public class WebsocketRequestBuilder
extends SpincastHttpRequestBuilderBase<IWebsocketRequestBuilder>
implements IWebsocketRequestBuilder {
    protected final Logger logger = LoggerFactory.getLogger(WebsocketRequestBuilder.class);
    private final ISpincastHttpClientWithWebsocketUtils spincastHttpClientWithWebsocketUtils;
    private final ISpincastHttpClientWithWebsocketConfig spincastHttpClientWithWebsocketConfig;
    private SSLContext sslContext;
    private Integer pingsIntervalSeconds = null;
    private volatile Thread pingSenderThread = null;
    private volatile boolean connectionIsClosed = false;
    private boolean onConnectionClosedEventCalled = false;
    private Object onConnectionClosedEventCalledLock = new Object();
    private WebSocketCallback<Void> websocketWriteHandler = null;
    private IWebsocketClientHandler websocketClientHandler = null;
    private ExecutorService threadExecutorForClientEvents;

    @AssistedInject
    public WebsocketRequestBuilder(@Assisted String url, ICookieFactory cookieFactory, IHttpResponseFactory spincastHttpResponseFactory, ISpincastHttpClientWithWebsocketUtils spincastHttpClientWithWebsocketUtils, ISpincastHttpClientWithWebsocketConfig spincastHttpClientWithWebsocketConfig) {
        super(url, cookieFactory, spincastHttpResponseFactory, (ISpincastHttpClientUtils)spincastHttpClientWithWebsocketUtils, (ISpincastHttpClientConfig)spincastHttpClientWithWebsocketConfig);
        this.spincastHttpClientWithWebsocketConfig = spincastHttpClientWithWebsocketConfig;
        this.spincastHttpClientWithWebsocketUtils = spincastHttpClientWithWebsocketUtils;
    }

    protected ISpincastHttpClientWithWebsocketConfig getSpincastHttpClientWithWebsocketConfig() {
        return this.spincastHttpClientWithWebsocketConfig;
    }

    protected ISpincastHttpClientWithWebsocketUtils getSpincastHttpClientWithWebsocketUtils() {
        return this.spincastHttpClientWithWebsocketUtils;
    }

    protected HttpRequestBase createMethodSpecificHttpRequest(String url) {
        return new HttpGet(url);
    }

    protected int getPingsIntervalSeconds() {
        if (this.pingsIntervalSeconds == null) {
            return this.getSpincastHttpClientWithWebsocketConfig().getWebsocketAutomaticPingIntervalSeconds();
        }
        return this.pingsIntervalSeconds;
    }

    protected IWebsocketClientHandler getWebsocketClientReader() {
        return this.websocketClientHandler;
    }

    @Override
    public IWebsocketRequestBuilder ping(int seconds) {
        this.pingsIntervalSeconds = seconds;
        return this;
    }

    @Override
    public IHttpResponse send() {
        this.addWebsocketRequestHeaders();
        return super.send();
    }

    protected void addWebsocketRequestHeaders() {
        this.addHeaderValue("Sec-WebSocket-Version", "13");
        ArrayList<String> keys = (ArrayList<String>)this.getHeaders().get("Sec-WebSocket-Key");
        if (keys == null || keys.size() == 0) {
            keys = new ArrayList<String>();
            keys.add(UUID.randomUUID().toString());
            this.getHeaders().put("Sec-WebSocket-Key", keys);
        }
        this.addHeaderValue("Connection", "Upgrade");
        this.addHeaderValue("Upgrade", "websocket");
    }

    @Override
    public IWebsocketClientWriter connect(IWebsocketClientHandler websocketClientHandler) {
        this.websocketClientHandler = websocketClientHandler;
        try {
            final WebSocketChannel channel = this.createWebSocketChannel();
            channel.getReceiveSetter().set((ChannelListener)new AbstractReceiveListener(){

                protected void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage bufferedTextMessage) throws IOException {
                    String message = bufferedTextMessage.getData();
                    WebsocketRequestBuilder.this.sendOnStringMessageClientEvent(message);
                }

                protected void onFullBinaryMessage(WebSocketChannel channel, BufferedBinaryMessage message) throws IOException {
                    ByteBuffer[] byteBuffersArray = (ByteBuffer[])message.getData().getResource();
                    ByteBuffer byteBuffer = WebSockets.mergeBuffers((ByteBuffer[])byteBuffersArray);
                    WebsocketRequestBuilder.this.sendOnBytesMessageClientEvent(byteBuffer.array());
                }

                protected void onCloseMessage(CloseMessage cm, WebSocketChannel channel) {
                    try {
                        WebsocketRequestBuilder.this.connectionIsClosed = true;
                        if (channel.isOpen()) {
                            channel.close();
                        }
                    }
                    catch (Exception ex) {
                        WebsocketRequestBuilder.this.logger.warn("Error closing Websocket connection: " + ex.getMessage());
                    }
                    WebsocketRequestBuilder.this.sendOnConnectionClosedMessageClientEvent(cm.getCode(), cm.getReason());
                }
            });
            channel.resumeReceives();
            final WebSocketCallback<Void> webSocketCallback = this.getWebsocketWriteCallback(websocketClientHandler);
            ISpincastWebsocketClientWriter writer = new ISpincastWebsocketClientWriter(){

                @Override
                public void sendMessage(byte[] message) {
                    if (WebsocketRequestBuilder.this.connectionIsClosed) {
                        WebsocketRequestBuilder.this.logger.warn("Connection is closed...");
                        return;
                    }
                    ByteBuffer buffer = ByteBuffer.wrap(message);
                    WebSockets.sendBinary((ByteBuffer)buffer, (WebSocketChannel)channel, (WebSocketCallback)webSocketCallback);
                }

                @Override
                public void sendMessage(String message) {
                    if (WebsocketRequestBuilder.this.connectionIsClosed) {
                        WebsocketRequestBuilder.this.logger.warn("Connection is closed...");
                        return;
                    }
                    WebSockets.sendText((String)message, (WebSocketChannel)channel, (WebSocketCallback)webSocketCallback);
                }

                @Override
                public void closeConnection() {
                    if (WebsocketRequestBuilder.this.connectionIsClosed) {
                        WebsocketRequestBuilder.this.logger.info("Connection is already closed...");
                        return;
                    }
                    WebsocketRequestBuilder.this.connectionIsClosed = true;
                    try {
                        if (channel.isOpen()) {
                            channel.close();
                        }
                    }
                    catch (Exception ex) {
                        WebsocketRequestBuilder.this.logger.error("Erreur closing the connection: " + ex.getMessage());
                    }
                }

                @Override
                public void sendPing() {
                    if (WebsocketRequestBuilder.this.connectionIsClosed) {
                        return;
                    }
                    ByteBuffer buffer = null;
                    try {
                        buffer = ByteBuffer.wrap(WebsocketRequestBuilder.this.getSpincastHttpClientWithWebsocketConfig().getWebsocketPingMessageString().getBytes("UTF-8"));
                    }
                    catch (Exception ex) {
                        throw SpincastStatics.runtimize((Exception)ex);
                    }
                    WebSockets.sendPing((ByteBuffer)buffer, (WebSocketChannel)channel, (WebSocketCallback)webSocketCallback);
                }
            };
            this.startSendingPings(writer);
            return writer;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    protected WebSocketCallback<Void> getWebsocketWriteCallback(final IWebsocketClientHandler reader) {
        if (this.websocketWriteHandler == null) {
            this.websocketWriteHandler = new WebSocketCallback<Void>(){

                public void onError(WebSocketChannel channel, Void context, Throwable throwable) {
                    if (throwable instanceof IOException || !channel.isOpen()) {
                        WebsocketRequestBuilder.this.connectionIsClosed = true;
                        WebsocketRequestBuilder.this.sendConnectionClosedAppEvent(reader);
                    } else {
                        WebsocketRequestBuilder.this.logger.error("None IOException when trying to write to Websocket endpoint: " + throwable);
                    }
                }

                public void complete(WebSocketChannel channel, Void context) {
                }
            };
        }
        return this.websocketWriteHandler;
    }

    protected void startSendingPings(final ISpincastWebsocketClientWriter writer) {
        final int pingsIntervalSeconds = this.getPingsIntervalSeconds();
        if (pingsIntervalSeconds <= 0) {
            return;
        }
        this.pingSenderThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(pingsIntervalSeconds * 1000);
                    }
                    catch (Exception ex) {
                        WebsocketRequestBuilder.this.logger.warn("Exception sleeping the thread: " + ex.getMessage());
                    }
                    if (WebsocketRequestBuilder.this.connectionIsClosed || WebsocketRequestBuilder.this.pingSenderThread == null || WebsocketRequestBuilder.this.pingSenderThread != Thread.currentThread()) break;
                    writer.sendPing();
                }
            }
        });
        this.pingSenderThread.start();
    }

    protected Xnio getXnio() {
        return this.getSpincastHttpClientWithWebsocketUtils().getXnioInstance();
    }

    protected XnioWorker createXnioWorker() {
        try {
            Xnio xnio = this.getXnio();
            SSLContext sslContext = this.getSslContext();
            OptionMap.Builder builder = OptionMap.builder();
            builder.set(Options.WORKER_IO_THREADS, 2).set(Options.WORKER_TASK_CORE_THREADS, 30).set(Options.WORKER_TASK_MAX_THREADS, 30).set(Options.TCP_NODELAY, true).set(Options.CORK, true).set(Options.SSL_PROTOCOL, (Object)sslContext.getProtocol()).set(Options.SSL_PROVIDER, (Object)sslContext.getProvider().getName());
            return xnio.createWorker(builder.getMap());
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    protected SSLContext getSslContext() {
        if (this.sslContext == null) {
            try {
                this.sslContext = this.isDisableSslCertificateErrors() ? SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build() : SSLContexts.createSystemDefault();
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize((Exception)ex);
            }
        }
        return this.sslContext;
    }

    protected Pool<ByteBuffer> createByteBufferPool() {
        return new ByteBufferSlicePool(1024, 1024);
    }

    protected WebSocketChannel createWebSocketChannel() {
        try {
            XnioWorker worker = this.createXnioWorker();
            Pool<ByteBuffer> bufferPool = this.createByteBufferPool();
            URI uri = this.createWebsocketUri();
            WebSocketClient.ConnectionBuilder connectionBuilder = WebSocketClient.connectionBuilder((XnioWorker)worker, bufferPool, (URI)uri);
            this.addSslContext(connectionBuilder);
            connectionBuilder.setClientNegotiation(new WebSocketClientNegotiation(this.createSupportedSubProtocols(), this.createSupportedExtensions()){

                public void beforeRequest(Map<String, List<String>> headers) {
                    WebsocketRequestBuilder.this.addCustomHeaders(headers);
                    WebsocketRequestBuilder.this.addCustomCookies(headers);
                    WebsocketRequestBuilder.this.addHttpAuthHeaders(headers);
                }
            });
            return (WebSocketChannel)connectionBuilder.connect().get();
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    protected void addSslContext(WebSocketClient.ConnectionBuilder connectionBuilder) {
        SSLContext sslContext = this.getSslContext();
        JsseXnioSsl xnioSsl = new JsseXnioSsl(this.getXnio(), OptionMap.create((Option)Options.USE_DIRECT_BUFFERS, (Object)true), sslContext);
        connectionBuilder.setSsl((XnioSsl)xnioSsl);
    }

    protected URI createWebsocketUri() {
        try {
            String url = this.getUrl().trim();
            if (url.toLowerCase().startsWith("https://")) {
                url = "wss://" + url.substring("https://".length());
            }
            return new URI(url);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    protected void addCustomHeaders(Map<String, List<String>> headers) {
        Map headersToAdd = this.getHeaders();
        if (headersToAdd != null) {
            for (Map.Entry entry : headersToAdd.entrySet()) {
                List<String> values = headers.get(entry.getKey());
                if (values == null) {
                    values = new ArrayList<String>();
                    headers.put((String)entry.getKey(), values);
                }
                values.addAll((Collection)entry.getValue());
            }
        }
    }

    protected void addCustomCookies(Map<String, List<String>> headers) {
        List cookiesToAdd = this.getCookieStore().getCookies();
        if (cookiesToAdd == null || cookiesToAdd.size() == 0) {
            return;
        }
        List<String> cookies = headers.get("Cookie");
        if (cookies == null) {
            cookies = new ArrayList<String>();
            headers.put("Cookie", cookies);
        }
        for (Cookie cookie : cookiesToAdd) {
            String cookieHeaderValue = this.getSpincastHttpClientUtils().apacheCookieToHttpHeaderValue(cookie);
            cookies.add(cookieHeaderValue);
        }
    }

    protected void addHttpAuthHeaders(Map<String, List<String>> headers) {
        if (this.getHttpAuthUsername() == null) {
            return;
        }
        String value = this.getHttpAuthUsername() + ":" + this.getHttpAuthPassword();
        try {
            value = "Basic " + Base64.encodeBase64String((byte[])value.getBytes("UTF-8"));
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        headers.put("Authorization", values);
    }

    protected List<String> createSupportedSubProtocols() {
        return new ArrayList<String>();
    }

    protected List<WebSocketExtension> createSupportedExtensions() {
        return new ArrayList<WebSocketExtension>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendConnectionClosedAppEvent(IWebsocketClientHandler reader) {
        if (!this.onConnectionClosedEventCalled) {
            Object object = this.onConnectionClosedEventCalledLock;
            synchronized (object) {
                if (!this.onConnectionClosedEventCalled) {
                    this.onConnectionClosedEventCalled = true;
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            int code = WebsocketRequestBuilder.this.getSpincastHttpClientWithWebsocketConfig().getWebsocketDefaultClosingCode();
                            String reason = WebsocketRequestBuilder.this.getSpincastHttpClientWithWebsocketConfig().getWebsocketDefaultClosingReason();
                            WebsocketRequestBuilder.this.getWebsocketClientReader().onConnectionClosed(code, reason);
                        }
                    };
                    this.sendClientEventInNewThread(runnable);
                }
            }
        }
    }

    protected void sendOnStringMessageClientEvent(final String message) {
        if (this.connectionIsClosed) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                WebsocketRequestBuilder.this.getWebsocketClientReader().onEndpointMessage(message);
            }
        };
        this.sendClientEventInNewThread(runnable);
    }

    protected void sendOnBytesMessageClientEvent(final byte[] message) {
        if (this.connectionIsClosed) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                WebsocketRequestBuilder.this.getWebsocketClientReader().onEndpointMessage(message);
            }
        };
        this.sendClientEventInNewThread(runnable);
    }

    protected void sendOnConnectionClosedMessageClientEvent(final int code, final String reason) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                WebsocketRequestBuilder.this.getWebsocketClientReader().onConnectionClosed(code, reason);
            }
        };
        this.sendClientEventInNewThread(runnable);
    }

    protected void sendClientEventInNewThread(final Runnable runnable) {
        try {
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    runnable.run();
                    return null;
                }
            };
            HashSet<10> callables = new HashSet<10>();
            callables.add(callable);
            this.getThreadExecutorForClientEvents().invokeAll(callables, this.getThreadExecutorForClientEventsTimeoutAmount(), this.getThreadExecutorForClientEventsTimeoutTimeUnit());
        }
        catch (InterruptedException ex) {
            this.logger.error("A Thread used for sending a Websocket event to the client took too long (max " + this.getThreadExecutorForClientEventsTimeoutAmount() + " " + this.getThreadExecutorForClientEventsTimeoutTimeUnit().toString() + "): " + ex.getMessage());
        }
        catch (Exception ex) {
            this.logger.error("A Thread used for sending a Websocket event to the application thrown an exception: " + ex.getMessage());
        }
    }

    protected int getThreadExecutorForClientEventsTimeoutAmount() {
        return this.getSpincastHttpClientWithWebsocketConfig().getWebsocketThreadExecutorForClientEventsTimeoutAmount();
    }

    protected TimeUnit getThreadExecutorForClientEventsTimeoutTimeUnit() {
        return this.getSpincastHttpClientWithWebsocketConfig().getWebsocketThreadExecutorForClientEventsTimeoutTimeUnit();
    }

    protected ExecutorService getThreadExecutorForClientEvents() {
        if (this.threadExecutorForClientEvents == null) {
            ThreadFactory threadFactory = this.getThreadExecutorForClientEventsThreadThreadFactory();
            this.threadExecutorForClientEvents = threadFactory != null ? Executors.newFixedThreadPool(this.getThreadExecutorForClientEventsThreadNumber(), threadFactory) : Executors.newFixedThreadPool(this.getThreadExecutorForClientEventsThreadNumber());
        }
        return this.threadExecutorForClientEvents;
    }

    protected int getThreadExecutorForClientEventsThreadNumber() {
        return this.getSpincastHttpClientWithWebsocketConfig().getWebsocketThreadExecutorForClientEventsThreadNumber();
    }

    protected ThreadFactory getThreadExecutorForClientEventsThreadThreadFactory() {
        return this.getSpincastHttpClientWithWebsocketConfig().getWebsocketThreadExecutorForClientEventsThreadFactory();
    }
}

