/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.dateformatter;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.extension.AbstractExtension;
import com.mitchellbosecke.pebble.extension.Filter;
import com.mitchellbosecke.pebble.extension.core.DefaultFilter;
import com.mitchellbosecke.pebble.template.EvaluationContext;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.dateformatter.DateFormatter;
import org.spincast.plugins.dateformatter.DateFormatterFactory;
import org.spincast.plugins.dateformatter.DateParts;
import org.spincast.plugins.dateformatter.DatePattern;
import org.spincast.plugins.dateformatter.RelativeDateFormatType;
import org.spincast.plugins.dateformatter.RelativeDateFormatter;
import org.spincast.plugins.dateformatter.SpincastDateFormatterPebbleExtension;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class SpincastDateFormatterPebbleExtensionDefault
extends AbstractExtension
implements SpincastDateFormatterPebbleExtension {
    public static final String FILTER_NAME_DATE_FORMAT = "dateFormat";
    private final DateFormatterFactory dateFormatterFactory;

    @Inject
    public SpincastDateFormatterPebbleExtensionDefault(DateFormatterFactory dateFormatterFactory) {
        this.dateFormatterFactory = dateFormatterFactory;
    }

    protected DateFormatterFactory getDateFormatterFactory() {
        return this.dateFormatterFactory;
    }

    public Map<String, Filter> getFilters() {
        HashMap<String, Filter> filters = new HashMap<String, Filter>();
        Filter filter = this.getDateFormatFilter();
        if (filter != null) {
            filters.put(this.getDateFormatFilterName(), filter);
        }
        return filters;
    }

    protected String getDateFormatFilterName() {
        return FILTER_NAME_DATE_FORMAT;
    }

    protected Filter getDateFormatFilter() {
        DefaultFilter filter = new DefaultFilter(){

            public List<String> getArgumentNames() {
                return Lists.newArrayList((Object[])new String[]{"firstParam", "secondParam", "thirdParam"});
            }

            public Object apply(Object value, Map<String, Object> args, PebbleTemplate self, EvaluationContext evaluationContext, int lineNumber) throws PebbleException {
                if (value != null) {
                    try {
                        Object firstParam = args.get("firstParam");
                        if (firstParam != null && firstParam.toString().toLowerCase().equals("relative")) {
                            return SpincastDateFormatterPebbleExtensionDefault.this.formatUsingRelativeFormatter(value, args);
                        }
                        return SpincastDateFormatterPebbleExtensionDefault.this.formatUsingStandardFormatter(value, args);
                    }
                    catch (Exception ex) {
                        return value.toString();
                    }
                }
                return "";
            }
        };
        return filter;
    }

    protected Object formatUsingRelativeFormatter(Object dateObj, Map<String, Object> args) {
        RelativeDateFormatter formatter;
        RelativeDateFormatType relativeDateFormatType = null;
        Object relativeDateFormatTypeObj = args.get("secondParam");
        if (relativeDateFormatTypeObj != null) {
            try {
                String type = relativeDateFormatTypeObj.toString().toUpperCase();
                relativeDateFormatType = RelativeDateFormatType.valueOf(type);
            }
            catch (Exception type) {
                // empty catch block
            }
        }
        if (dateObj instanceof Date) {
            formatter = this.getDateFormatterFactory().createRelativeFormatter((Date)dateObj);
        } else if (dateObj instanceof Instant) {
            formatter = this.getDateFormatterFactory().createRelativeFormatter((Instant)dateObj);
        } else {
            Date date = SpincastStatics.parseISO8601date((String)dateObj.toString());
            formatter = this.getDateFormatterFactory().createRelativeFormatter(date);
        }
        if (relativeDateFormatType != null) {
            formatter.formatType(relativeDateFormatType);
        }
        String result = formatter.format();
        return result;
    }

    protected String formatUsingStandardFormatter(Object dateObj, Map<String, Object> args) {
        Object separatorObj;
        String timePatternNameOrPattern;
        String datePatternNameOrPattern;
        DateFormatter formatter;
        if (dateObj instanceof Date) {
            formatter = this.getDateFormatterFactory().createFormatter((Date)dateObj);
        } else if (dateObj instanceof Instant) {
            formatter = this.getDateFormatterFactory().createFormatter((Instant)dateObj);
        } else {
            Date date = SpincastStatics.parseISO8601date((String)dateObj.toString());
            formatter = this.getDateFormatterFactory().createFormatter(date);
        }
        boolean hasDatePart = false;
        Object datePatternNameOrPatternObj = args.get("firstParam");
        if (datePatternNameOrPatternObj != null && !StringUtils.isBlank((CharSequence)(datePatternNameOrPattern = datePatternNameOrPatternObj.toString()))) {
            hasDatePart = true;
            if (!datePatternNameOrPattern.equals("_")) {
                datePatternNameOrPattern = datePatternNameOrPattern.toUpperCase();
                DatePattern datePattern = null;
                try {
                    datePattern = DatePattern.valueOf(datePatternNameOrPattern);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (datePattern != null) {
                    formatter.datePattern(datePattern);
                } else {
                    formatter.datePattern(datePatternNameOrPattern);
                }
            }
        }
        boolean hasTimePart = false;
        Object timePatternNameOrPatternObj = args.get("secondParam");
        if (timePatternNameOrPatternObj != null && !StringUtils.isBlank((CharSequence)(timePatternNameOrPattern = timePatternNameOrPatternObj.toString()))) {
            hasTimePart = true;
            if (!timePatternNameOrPattern.equals("_")) {
                timePatternNameOrPattern = timePatternNameOrPattern.toUpperCase();
                DatePattern timePattern = null;
                try {
                    timePattern = DatePattern.valueOf(timePatternNameOrPattern);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (timePattern != null) {
                    formatter.timePattern(timePattern);
                } else {
                    formatter.timePattern(timePatternNameOrPattern);
                }
            }
        }
        if ((separatorObj = args.get("thirdParam")) != null) {
            String separator = separatorObj.toString();
            formatter.separator(separator);
        }
        if (hasDatePart && !hasTimePart) {
            formatter.parts(DateParts.DATE);
        } else if (!hasDatePart && hasTimePart) {
            formatter.parts(DateParts.TIME);
        } else {
            formatter.parts(DateParts.BOTH);
        }
        String result = formatter.format();
        return result;
    }
}

