/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.dateformatter;

import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.multibindings.Multibinder;
import com.mitchellbosecke.pebble.extension.Extension;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.guice.SpincastGuiceModuleBase;
import org.spincast.core.websocket.WebsocketContext;
import org.spincast.plugins.dateformatter.DateFormatter;
import org.spincast.plugins.dateformatter.DateFormatterDefault;
import org.spincast.plugins.dateformatter.DateFormatterFactory;
import org.spincast.plugins.dateformatter.RelativeDateFormatter;
import org.spincast.plugins.dateformatter.RelativeDateFormatterDefault;
import org.spincast.plugins.dateformatter.SpincastDateFormatterPebbleExtension;
import org.spincast.plugins.dateformatter.SpincastDateFormatterPebbleExtensionDefault;

public class SpincastDateFormatterPluginModule
extends SpincastGuiceModuleBase {
    public SpincastDateFormatterPluginModule() {
    }

    public SpincastDateFormatterPluginModule(Class<? extends RequestContext<?>> requestContextImplementationClass, Class<? extends WebsocketContext<?>> websocketContextImplementationClass) {
        super(requestContextImplementationClass, websocketContextImplementationClass);
    }

    protected void configure() {
        this.bindDateFormatterFactory();
        if (this.isPebbleAvailable()) {
            this.bindPebbleExtension();
        }
    }

    protected boolean isPebbleAvailable() {
        try {
            Class.forName("com.mitchellbosecke.pebble.extension.Extension");
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    protected void bindDateFormatterFactory() {
        this.install(new FactoryModuleBuilder().implement(DateFormatter.class, this.getDateFormatterImplClass()).implement(RelativeDateFormatter.class, this.getDateFormatterAgoImplClass()).build(DateFormatterFactory.class));
    }

    protected Class<? extends DateFormatter> getDateFormatterImplClass() {
        return DateFormatterDefault.class;
    }

    protected Class<? extends RelativeDateFormatter> getDateFormatterAgoImplClass() {
        return RelativeDateFormatterDefault.class;
    }

    protected void bindPebbleExtension() {
        this.bind(SpincastDateFormatterPebbleExtension.class).to(this.getPebbleExtensionImplClass()).in(Scopes.SINGLETON);
        Multibinder pebbleExtensionsMultibinder = Multibinder.newSetBinder((Binder)this.binder(), Extension.class);
        pebbleExtensionsMultibinder.addBinding().to(SpincastDateFormatterPebbleExtension.class).in(Scopes.SINGLETON);
    }

    protected Class<? extends SpincastDateFormatterPebbleExtension> getPebbleExtensionImplClass() {
        return SpincastDateFormatterPebbleExtensionDefault.class;
    }
}

