/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.dateformatter;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.ocpsoft.prettytime.PrettyTime;
import org.spincast.core.locale.LocaleResolver;
import org.spincast.plugins.dateformatter.RelativeDateFormatType;
import org.spincast.plugins.dateformatter.RelativeDateFormatter;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class RelativeDateFormatterDefault
implements RelativeDateFormatter {
    private final Date date;
    private final LocaleResolver localeResolver;
    private final Map<Locale, PrettyTime> prettyTimesByLocale;
    private Locale locale;
    private RelativeDateFormatType formatType;

    @AssistedInject
    public RelativeDateFormatterDefault(@Assisted Instant instant, LocaleResolver localeResolver) {
        this(Date.from(instant), localeResolver);
    }

    @AssistedInject
    public RelativeDateFormatterDefault(@Assisted Date date, LocaleResolver localeResolver) {
        this.date = date;
        this.localeResolver = localeResolver;
        this.prettyTimesByLocale = new HashMap<Locale, PrettyTime>();
    }

    protected Date getDate() {
        return this.date;
    }

    protected LocaleResolver getLocaleResolver() {
        return this.localeResolver;
    }

    protected Map<Locale, PrettyTime> getPrettyTimesByLocale() {
        return this.prettyTimesByLocale;
    }

    protected PrettyTime getPrettyTime(Locale locale) {
        Map<Locale, PrettyTime> map = this.getPrettyTimesByLocale();
        PrettyTime prettyTime = map.get(locale);
        if (prettyTime == null) {
            prettyTime = new PrettyTime(locale);
            map.put(locale, prettyTime);
        }
        return prettyTime;
    }

    @Override
    public RelativeDateFormatter locale(Locale locale) {
        this.locale = locale;
        return this;
    }

    @Override
    public RelativeDateFormatter formatType(RelativeDateFormatType formatType) {
        this.formatType = formatType;
        return this;
    }

    @Override
    public String format() {
        String formatted;
        RelativeDateFormatType formatType;
        Locale locale = this.locale;
        if (locale == null) {
            locale = this.getLocaleResolver().getLocaleToUse();
        }
        if ((formatType = this.formatType) == null) {
            formatType = RelativeDateFormatType.DEFAULT;
        }
        if (formatType == RelativeDateFormatType.DEFAULT) {
            formatted = this.getPrettyTime(locale).format(this.getDate());
        } else if (formatType == RelativeDateFormatType.DURATION) {
            formatted = this.getPrettyTime(locale).formatDuration(this.getDate());
            if (StringUtils.isBlank((CharSequence)formatted)) {
                formatted = this.getAFewSecondsLabel();
            }
        } else if (formatType == RelativeDateFormatType.UNROUNDED) {
            formatted = this.getPrettyTime(locale).formatUnrounded(this.getDate());
        } else {
            throw new RuntimeException("Unmanaged relative format type : " + (Object)((Object)formatType));
        }
        return formatted;
    }

    protected String getAFewSecondsLabel() {
        return "a few seconds";
    }
}

