/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.cssyuicompressor;

import com.google.inject.Inject;
import com.mitchellbosecke.pebble.extension.AbstractExtension;
import com.mitchellbosecke.pebble.extension.Function;
import com.mitchellbosecke.pebble.extension.escaper.SafeString;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.routing.Router;
import org.spincast.core.server.Server;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.utils.SpincastUtils;
import org.spincast.plugins.cssyuicompressor.SpincastCssYuiCompressorManager;
import org.spincast.plugins.cssyuicompressor.SpincastCssYuiCompressorPebbleExtension;
import org.spincast.plugins.cssyuicompressor.config.SpincastCssYuiCompressorConfig;
import org.spincast.plugins.httpclient.HttpClient;
import org.spincast.plugins.httpclient.HttpResponse;
import org.spincast.plugins.httpclient.builders.GetRequestBuilder;
import org.spincast.shaded.org.apache.commons.codec.digest.DigestUtils;
import org.spincast.shaded.org.apache.commons.io.FileUtils;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class SpincastCssYuiCompressorPebbleExtensionDefault
extends AbstractExtension
implements SpincastCssYuiCompressorPebbleExtension {
    public static final String CSS_BUNDLE_FUNCTION_ARG_DISABLE_CACHE_BUSTING = "--spincast-no-cache-busting";
    public static final String CSS_BUNDLE_FUNCTION_ARG_LINE_BREAK_POS = "--line-break-pos";
    private final SpincastCssYuiCompressorConfig spincastCssYuiCompressorConfig;
    private final SpincastConfig spincastConfig;
    private final SpincastUtils spincastUtils;
    private final Router<?, ?> router;
    private final Server server;
    private final HttpClient httpClient;
    private final SpincastCssYuiCompressorManager spincastCssYuiCompressorManager;
    private final Object cssBundleLock = new Object();

    @Inject
    public SpincastCssYuiCompressorPebbleExtensionDefault(SpincastCssYuiCompressorConfig spincastCssYuiCompressorConfig, SpincastConfig spincastConfig, SpincastUtils spincastUtils, Router<?, ?> router, Server server, HttpClient httpClient, SpincastCssYuiCompressorManager spincastCssYuiCompressorManager) {
        this.spincastCssYuiCompressorConfig = spincastCssYuiCompressorConfig;
        this.spincastConfig = spincastConfig;
        this.spincastUtils = spincastUtils;
        this.router = router;
        this.server = server;
        this.httpClient = httpClient;
        this.spincastCssYuiCompressorManager = spincastCssYuiCompressorManager;
    }

    protected SpincastCssYuiCompressorConfig getSpincastCssYuiCompressorConfig() {
        return this.spincastCssYuiCompressorConfig;
    }

    protected SpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected SpincastUtils getSpincastUtils() {
        return this.spincastUtils;
    }

    protected Router<?, ?> getRouter() {
        return this.router;
    }

    protected Server getServer() {
        return this.server;
    }

    protected HttpClient getHttpClient() {
        return this.httpClient;
    }

    protected SpincastCssYuiCompressorManager getSpincastCssYuiCompressorManager() {
        return this.spincastCssYuiCompressorManager;
    }

    public Map<String, Function> getFunctions() {
        HashMap<String, Function> functions = new HashMap<String, Function>();
        functions.put(this.getSpincastCssYuiCompressorConfig().getCssBundlePebbleFunctionName(), new Function(){

            public List<String> getArgumentNames() {
                return null;
            }

            public Object execute(Map<String, Object> args) {
                List numericalKeys = args.keySet().stream().filter(key -> StringUtils.isNumeric((CharSequence)key)).sorted().collect(Collectors.toList());
                ArrayList<String> cssFilesUrlRelativePaths = new ArrayList<String>();
                boolean lineBreakPosNext = false;
                int lineBreakPos = -1;
                boolean disableCacheBusting = false;
                boolean inArgs = false;
                for (String numericalKey : numericalKeys) {
                    String val = args.get(numericalKey).toString();
                    if (!inArgs) {
                        if (val.startsWith("-")) {
                            inArgs = true;
                        } else {
                            cssFilesUrlRelativePaths.add(val);
                            continue;
                        }
                    }
                    if (val.startsWith("-spincast") || val.startsWith("--spincast")) {
                        if (!SpincastCssYuiCompressorPebbleExtensionDefault.CSS_BUNDLE_FUNCTION_ARG_DISABLE_CACHE_BUSTING.equals(val)) continue;
                        disableCacheBusting = true;
                        continue;
                    }
                    if (SpincastCssYuiCompressorPebbleExtensionDefault.CSS_BUNDLE_FUNCTION_ARG_LINE_BREAK_POS.equals(val)) {
                        lineBreakPosNext = true;
                        continue;
                    }
                    if (!lineBreakPosNext) continue;
                    lineBreakPosNext = false;
                    try {
                        lineBreakPos = Integer.parseInt(val);
                    }
                    catch (Exception ex) {
                        throw SpincastStatics.runtimize((Exception)ex);
                    }
                }
                if (cssFilesUrlRelativePaths.size() == 0) {
                    return "";
                }
                if (SpincastCssYuiCompressorPebbleExtensionDefault.this.getSpincastCssYuiCompressorConfig().isCssBundlesDisabled()) {
                    return SpincastCssYuiCompressorPebbleExtensionDefault.this.bundlingDisabledOutput(cssFilesUrlRelativePaths);
                }
                String hash = SpincastCssYuiCompressorPebbleExtensionDefault.this.generateCssBundleHash(cssFilesUrlRelativePaths);
                File bundleFile = SpincastCssYuiCompressorPebbleExtensionDefault.this.getCssBundleFile(hash);
                String urlPath = SpincastCssYuiCompressorPebbleExtensionDefault.this.generateCssBundleUrlPath(hash, false);
                SpincastCssYuiCompressorPebbleExtensionDefault.this.bundleCss(bundleFile, cssFilesUrlRelativePaths, urlPath, lineBreakPos);
                String path = SpincastCssYuiCompressorPebbleExtensionDefault.this.generateCssBundleUrlPath(hash, !disableCacheBusting);
                return SpincastCssYuiCompressorPebbleExtensionDefault.this.bundlingOutput(path);
            }
        });
        return functions;
    }

    protected Object bundlingDisabledOutput(List<String> cssFilesUrlRelativePaths) {
        StringBuilder builder = new StringBuilder();
        for (String path : cssFilesUrlRelativePaths) {
            builder.append("<link rel=\"stylesheet\" href=\"").append(path).append("\">\n");
        }
        return new SafeString(builder.toString());
    }

    protected Object bundlingOutput(String path) {
        return new SafeString("<link rel=\"stylesheet\" href=\"" + path + "\">\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bundleCss(File bundleFile, List<String> cssFilesUrlRelativePaths, String urlPath, int lineBreakPos) {
        if (!this.getSpincastConfig().isTestingMode() && bundleFile.isFile() && this.getServer().getStaticResourceServed(urlPath) != null) {
            return;
        }
        Object object = this.cssBundleLock;
        synchronized (object) {
            if (!this.getSpincastConfig().isTestingMode() && bundleFile.isFile() && this.getServer().getStaticResourceServed(urlPath) != null) {
                return;
            }
            try {
                if (!bundleFile.isFile()) {
                    StringBuilder content = new StringBuilder();
                    String publicUrlBase = this.getSpincastConfig().getPublicUrlBase();
                    if (!publicUrlBase.endsWith("/")) {
                        publicUrlBase = publicUrlBase + "/";
                    }
                    for (String cssFileUrlRelativePath : cssFilesUrlRelativePaths) {
                        HttpResponse response;
                        cssFileUrlRelativePath = StringUtils.stripStart((String)cssFileUrlRelativePath, (String)"/");
                        String url = publicUrlBase + cssFileUrlRelativePath;
                        GetRequestBuilder requestBuilder = this.getHttpClient().GET(url);
                        if (this.getSpincastCssYuiCompressorConfig().isCssBundlesIgnoreSslCertificateErrors()) {
                            requestBuilder = (GetRequestBuilder)requestBuilder.disableSslCertificateErrors();
                        }
                        if ((response = requestBuilder.send()).getStatus() != 200) {
                            throw new RuntimeException("Invalid response for file '" + url + "' : " + response.getStatus());
                        }
                        content.append(response.getContentAsString() + "\n");
                    }
                    String optimizedContent = this.getSpincastCssYuiCompressorManager().minify(content.toString(), lineBreakPos);
                    FileUtils.writeStringToFile((File)bundleFile, (String)optimizedContent, (String)"UTF-8");
                }
                if (this.getServer().getStaticResourceServed(urlPath) == null) {
                    this.getRouter().file(urlPath).cache(31536000).pathAbsolute(bundleFile.getAbsolutePath()).handle();
                }
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize((Exception)ex);
            }
        }
    }

    protected String generateCssBundleHash(List<String> cssFilesUrlRelativePaths) {
        StringBuilder builder = new StringBuilder();
        for (String path : cssFilesUrlRelativePaths) {
            builder.append(path).append("|");
        }
        String hash = DigestUtils.md5Hex((String)builder.toString());
        return hash;
    }

    protected File getCssBundleFile(String hash) {
        File dir = this.getSpincastCssYuiCompressorConfig().getCssBundlesDir();
        if (!dir.isDirectory()) {
            try {
                FileUtils.forceMkdir((File)dir);
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize((Exception)ex);
            }
        }
        return new File(dir, hash + ".css");
    }

    protected String generateCssBundleUrlPath(String hash, boolean withCacheBuster) {
        String path = this.getSpincastCssYuiCompressorConfig().getCssBundlesUrlPath();
        if (StringUtils.isBlank((CharSequence)path)) {
            path = "/";
        } else if (!path.endsWith("/")) {
            path = path + "/";
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (withCacheBuster) {
            path = path + this.getSpincastUtils().getCacheBusterCode();
        }
        path = path + hash + ".css";
        return path;
    }
}

