/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.cssyuicompressor;

import com.yahoo.platform.yui.compressor.CssCompressor;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.cssyuicompressor.SpincastCssYuiCompressorManager;
import org.spincast.shaded.org.apache.commons.io.FileUtils;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class SpincastCssYuiCompressorManagerDefault
implements SpincastCssYuiCompressorManager {
    @Override
    public void minify(File cssFile) {
        this.minify(cssFile, StandardCharsets.UTF_8, -1);
    }

    @Override
    public void minify(File cssFile, int lineBreakPos) {
        this.minify(cssFile, StandardCharsets.UTF_8, lineBreakPos);
    }

    @Override
    public void minify(File cssFile, Charset encoding) {
        this.minify(cssFile, encoding, -1);
    }

    @Override
    public void minify(File cssFile, Charset encoding, int lineBreakPos) {
        if (!cssFile.isFile()) {
            throw new RuntimeException("The specified file doesn't exit: " + cssFile.getAbsolutePath());
        }
        try {
            String content = FileUtils.readFileToString((File)cssFile, (Charset)encoding);
            content = this.minify(content, lineBreakPos);
            FileUtils.writeStringToFile((File)cssFile, (String)content, (Charset)encoding);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    @Override
    public String minify(String cssContent) {
        return this.minify(cssContent, -1);
    }

    @Override
    public String minify(String cssContent, int lineBreakPos) {
        if (lineBreakPos <= 0) {
            lineBreakPos = -1;
        }
        if (StringUtils.isBlank((CharSequence)cssContent)) {
            return "";
        }
        try {
            StringReader cssContentReader = new StringReader(cssContent);
            CssCompressor compressor = new CssCompressor((Reader)cssContentReader);
            StringWriter stringWriter = new StringWriter();
            compressor.compress((Writer)stringWriter, lineBreakPos);
            cssContent = stringWriter.toString();
            return cssContent;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }
}

