/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.cssautoprefixer;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.json.JsonManager;
import org.spincast.core.json.JsonObject;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.utils.SpincastUtils;
import org.spincast.plugins.cssautoprefixer.SpincastCssAutoprefixerManager;
import org.spincast.plugins.cssautoprefixer.config.SpincastCssAutoprefixerConfig;
import org.spincast.plugins.processutils.ExecutionOutputStrategy;
import org.spincast.plugins.processutils.SpincastProcessUtils;
import org.spincast.plugins.processutils.SyncExecutionResult;
import org.spincast.shaded.org.apache.commons.codec.digest.DigestUtils;
import org.spincast.shaded.org.apache.commons.io.FileUtils;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;
import org.spincast.shaded.org.apache.commons.lang3.SystemUtils;

public class SpincastCssAutoprefixerManagerDefault
implements SpincastCssAutoprefixerManager {
    protected static final Logger logger = LoggerFactory.getLogger(SpincastCssAutoprefixerManagerDefault.class);
    private final SpincastUtils spincastUtils;
    private final SpincastProcessUtils spincastProcessUtils;
    private final SpincastConfig spincastConfig;
    private final SpincastCssAutoprefixerConfig spincastCssAutoprefixerConfig;
    private final JsonManager jsonManager;
    private File postCssConfigFileDirsParentDir = null;
    private File nodeGlobalDir = null;
    private boolean isValidAutoprefixerEnvironment = false;
    private boolean isValidAutoprefixerEnvironmentEvaluated = false;
    private Object isValidAutoprefixerEnvironmentLock = new Object();

    @Inject
    public SpincastCssAutoprefixerManagerDefault(SpincastUtils spincastUtils, SpincastProcessUtils spincastProcessUtils, SpincastConfig spincastConfig, SpincastCssAutoprefixerConfig spincastCssAutoprefixerConfig, JsonManager jsonManager) {
        this.spincastUtils = spincastUtils;
        this.spincastProcessUtils = spincastProcessUtils;
        this.spincastConfig = spincastConfig;
        this.spincastCssAutoprefixerConfig = spincastCssAutoprefixerConfig;
        this.jsonManager = jsonManager;
    }

    protected SpincastUtils getSpincastUtils() {
        return this.spincastUtils;
    }

    protected SpincastProcessUtils getSpincastProcessUtils() {
        return this.spincastProcessUtils;
    }

    protected SpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected SpincastCssAutoprefixerConfig getSpincastCssAutoprefixerConfig() {
        return this.spincastCssAutoprefixerConfig;
    }

    protected JsonManager getJsonManager() {
        return this.jsonManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValidAutoprefixerEnvironment() {
        if (this.isValidAutoprefixerEnvironmentEvaluated) {
            return this.isValidAutoprefixerEnvironment;
        }
        Object object = this.isValidAutoprefixerEnvironmentLock;
        synchronized (object) {
            if (this.isValidAutoprefixerEnvironmentEvaluated) {
                return this.isValidAutoprefixerEnvironment;
            }
            this.isValidAutoprefixerEnvironmentEvaluated = true;
            try {
                String css = "::placeholder {    color: gray;}";
                this.autoPrefix(css);
                return true;
            }
            catch (Exception ex) {
                logger.info("Autoprefixer doesn't seem to be installed properly:\n" + SpincastStatics.getStackTrace((Throwable)ex));
                logger.info("Read https://www.spincast.org/plugins/spincast-css-autoprefixer in order to learn how to install it!");
                return false;
            }
        }
    }

    protected String getNomExecutableName() {
        String postcssExecutable = "npm";
        if (SystemUtils.IS_OS_WINDOWS) {
            postcssExecutable = postcssExecutable + ".cmd";
        }
        return postcssExecutable;
    }

    protected File getNodeGlobalDir() {
        if (this.nodeGlobalDir == null) {
            try {
                SyncExecutionResult result = this.getSpincastProcessUtils().executeSync(30L, TimeUnit.SECONDS, ExecutionOutputStrategy.BUFFER, new String[]{this.getNomExecutableName(), "root", "-g"});
                int exitCode = result.getExitCode();
                if (exitCode != 0) {
                    throw new RuntimeException("Exited with " + exitCode);
                }
                if (result.getSystemOutLines().size() != 1) {
                    throw new RuntimeException("Was expecting one line, the version: " + result.getSystemOutLines());
                }
                String line = (String)result.getSystemOutLines().get(0);
                File temp = new File(line);
                if (!temp.isDirectory()) {
                    throw new RuntimeException("Command 'npm root -g' returned an invalid directory!: " + this.nodeGlobalDir.getAbsolutePath());
                }
                this.nodeGlobalDir = temp;
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize((Exception)ex);
            }
        }
        return this.nodeGlobalDir;
    }

    @Override
    public void autoPrefix(File cssFile) {
        this.autoPrefix(cssFile, StandardCharsets.UTF_8, null);
    }

    @Override
    public void autoPrefix(File cssFile, JsonObject options) {
        this.autoPrefix(cssFile, StandardCharsets.UTF_8, options);
    }

    @Override
    public void autoPrefix(File cssFile, Charset encoding) {
        this.autoPrefix(cssFile, encoding, null);
    }

    @Override
    public void autoPrefix(File cssFile, Charset encoding, JsonObject options) {
        if (!cssFile.isFile()) {
            throw new RuntimeException("The specified file doesn't exit: " + cssFile.getAbsolutePath());
        }
        try {
            String content = FileUtils.readFileToString((File)cssFile, (Charset)encoding);
            content = this.autoPrefix(content, options);
            FileUtils.writeStringToFile((File)cssFile, (String)content, (Charset)encoding);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    @Override
    public String autoPrefix(String cssContent) {
        return this.autoPrefix(cssContent, null);
    }

    @Override
    public String autoPrefix(String cssContent, JsonObject options) {
        if (StringUtils.isBlank((CharSequence)cssContent)) {
            return "";
        }
        File tempCssFile = null;
        try {
            String resultContent;
            if (options == null) {
                options = this.getJsonManager().create();
            }
            tempCssFile = new File(this.getSpincastUtils().createTempFilePath() + ".css");
            FileUtils.write((File)tempCssFile, (CharSequence)cssContent, (String)"UTF-8");
            String postcssExecutableName = this.getSpincastCssAutoprefixerConfig().getPostcssExecutableName();
            File postCssConfigFileDir = this.getPostCssConfigFileDir(options);
            this.createPostCssConfigFile(postCssConfigFileDir, options);
            List<String> args = this.getCommandArgs(postcssExecutableName, tempCssFile, postCssConfigFileDir);
            logger.info("Executing: " + StringUtils.join(args, (String)" "));
            SyncExecutionResult result = this.getSpincastProcessUtils().executeSync((long)this.getAutoprefixCommandMaxNbrMinutes(), TimeUnit.MINUTES, args);
            if (result.getExitCode() != 0) {
                throw new RuntimeException("Program did not exit with code '0': " + result.getExitCode());
            }
            String string = resultContent = FileUtils.readFileToString((File)tempCssFile, (String)"UTF-8");
            return string;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
        finally {
            if (tempCssFile != null && tempCssFile.isFile()) {
                FileUtils.deleteQuietly((File)tempCssFile);
            }
        }
    }

    protected int getAutoprefixCommandMaxNbrMinutes() {
        return 1;
    }

    protected File getPostCssConfigFileDirsParentDir() {
        if (this.postCssConfigFileDirsParentDir == null) {
            try {
                this.postCssConfigFileDirsParentDir = new File(this.getSpincastConfig().getTempDir(), this.getClass().getSimpleName() + "/postCssConfigFileDirsParentDir");
                FileUtils.forceMkdir((File)this.postCssConfigFileDirsParentDir);
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize((Exception)ex);
            }
        }
        return this.postCssConfigFileDirsParentDir;
    }

    protected File getPostCssConfigFileDir(JsonObject options) {
        String hash;
        File postCssConfigFileDirsParentDir = this.getPostCssConfigFileDirsParentDir();
        File postCssConfigFileDir = new File(postCssConfigFileDirsParentDir, hash = DigestUtils.md5Hex((String)options.toJsonString()));
        if (!postCssConfigFileDir.isDirectory()) {
            try {
                FileUtils.forceMkdir((File)postCssConfigFileDir);
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize((Exception)ex);
            }
        }
        return postCssConfigFileDir;
    }

    protected void createPostCssConfigFile(File postCssConfigFileDir, JsonObject options) {
        File configFile = new File(postCssConfigFileDir, "postcss.config.js");
        if (configFile.isFile()) {
            return;
        }
        File nodeGlobalDir = this.getNodeGlobalDir();
        String nodeGlobalDirJsPath = nodeGlobalDir.getAbsolutePath().replace("\\", "\\\\");
        String content = "module.exports = ctx => {    try {        module.paths.push('" + nodeGlobalDirJsPath + "');        return ({            plugins: [                require('autoprefixer')(" + options.toJsonString(false) + ")            ]        })    } finally {        module.paths.pop();    }}";
        try {
            FileUtils.writeStringToFile((File)configFile, (String)content, (String)"UTF-8");
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    protected List<String> getCommandArgs(String postcssExecutableName, File tempCssFile, File postCssConfigFileDir) {
        ArrayList args = Lists.newArrayList((Object[])new String[]{postcssExecutableName, tempCssFile.getAbsolutePath(), "--no-map", "--config", postCssConfigFileDir.getAbsolutePath(), "-o", tempCssFile.getAbsolutePath()});
        return args;
    }
}

